/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants;

import com.azure.ai.openai.assistants.AssistantsClientBuilder;
import com.azure.ai.openai.assistants.implementation.AssistantsClientImpl;
import com.azure.ai.openai.assistants.implementation.MultipartFormDataHelper;
import com.azure.ai.openai.assistants.implementation.OpenAIUtils;
import com.azure.ai.openai.assistants.implementation.accesshelpers.PageableListAccessHelper;
import com.azure.ai.openai.assistants.implementation.models.CreateVectorStoreFileBatchRequest;
import com.azure.ai.openai.assistants.implementation.models.CreateVectorStoreFileRequest;
import com.azure.ai.openai.assistants.implementation.models.FileListResponse;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfAssistant;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfRunStep;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfThreadMessage;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfThreadRun;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfVectorStore;
import com.azure.ai.openai.assistants.implementation.models.OpenAIPageableListOfVectorStoreFile;
import com.azure.ai.openai.assistants.implementation.models.SubmitToolOutputsToRunRequest;
import com.azure.ai.openai.assistants.implementation.models.UpdateMessageRequest;
import com.azure.ai.openai.assistants.implementation.models.UpdateRunRequest;
import com.azure.ai.openai.assistants.implementation.models.UploadFileRequest;
import com.azure.ai.openai.assistants.implementation.streaming.OpenAIServerSentEvents;
import com.azure.ai.openai.assistants.models.Assistant;
import com.azure.ai.openai.assistants.models.AssistantCreationOptions;
import com.azure.ai.openai.assistants.models.AssistantDeletionStatus;
import com.azure.ai.openai.assistants.models.AssistantThread;
import com.azure.ai.openai.assistants.models.AssistantThreadCreationOptions;
import com.azure.ai.openai.assistants.models.CreateAndRunThreadOptions;
import com.azure.ai.openai.assistants.models.CreateRunOptions;
import com.azure.ai.openai.assistants.models.FileDeletionStatus;
import com.azure.ai.openai.assistants.models.FileDetails;
import com.azure.ai.openai.assistants.models.FilePurpose;
import com.azure.ai.openai.assistants.models.ListSortOrder;
import com.azure.ai.openai.assistants.models.OpenAIFile;
import com.azure.ai.openai.assistants.models.PageableList;
import com.azure.ai.openai.assistants.models.RunIncludes;
import com.azure.ai.openai.assistants.models.RunStep;
import com.azure.ai.openai.assistants.models.StreamUpdate;
import com.azure.ai.openai.assistants.models.ThreadDeletionStatus;
import com.azure.ai.openai.assistants.models.ThreadMessage;
import com.azure.ai.openai.assistants.models.ThreadMessageOptions;
import com.azure.ai.openai.assistants.models.ThreadRun;
import com.azure.ai.openai.assistants.models.ToolOutput;
import com.azure.ai.openai.assistants.models.UpdateAssistantOptions;
import com.azure.ai.openai.assistants.models.UpdateAssistantThreadOptions;
import com.azure.ai.openai.assistants.models.VectorStore;
import com.azure.ai.openai.assistants.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.openai.assistants.models.VectorStoreDeletionStatus;
import com.azure.ai.openai.assistants.models.VectorStoreFile;
import com.azure.ai.openai.assistants.models.VectorStoreFileBatch;
import com.azure.ai.openai.assistants.models.VectorStoreFileDeletionStatus;
import com.azure.ai.openai.assistants.models.VectorStoreFileStatusFilter;
import com.azure.ai.openai.assistants.models.VectorStoreOptions;
import com.azure.ai.openai.assistants.models.VectorStoreUpdateOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AssistantsClientBuilder.class, isAsync=true)
public final class AssistantsAsyncClient {
    private final AssistantsClientImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createAssistantWithResponse(BinaryData assistantCreationOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createAssistantWithResponseAsync(assistantCreationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listAssistantsWithResponse(RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listAssistantsWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteAssistantWithResponse(String assistantId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteAssistantWithResponseAsync(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Assistant> createAssistant(AssistantCreationOptions assistantCreationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createAssistantWithResponse(BinaryData.fromObject((Object)assistantCreationOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Assistant)protocolMethodData.toObject(Assistant.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<Assistant>> listAssistants(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listAssistantsWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfAssistant)protocolMethodData.toObject(OpenAIPageableListOfAssistant.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<Assistant>> listAssistants() {
        RequestOptions requestOptions = new RequestOptions();
        return this.listAssistantsWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfAssistant)protocolMethodData.toObject(OpenAIPageableListOfAssistant.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AssistantDeletionStatus> deleteAssistant(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteAssistantWithResponse(assistantId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AssistantDeletionStatus)protocolMethodData.toObject(AssistantDeletionStatus.class));
    }

    AssistantsAsyncClient(AssistantsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAssistantWithResponse(String assistantId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getAssistantWithResponseAsync(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createThreadWithResponse(BinaryData assistantThreadCreationOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createThreadWithResponseAsync(assistantThreadCreationOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getThreadWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getThreadWithResponseAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteThreadWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteThreadWithResponseAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createMessageWithResponse(String threadId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createMessageWithResponseAsync(threadId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listMessagesWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listMessagesWithResponseAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMessageWithResponse(String threadId, String messageId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getMessageWithResponseAsync(threadId, messageId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createRunWithResponse(String threadId, BinaryData createRunOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createRunWithResponseAsync(threadId, createRunOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listRunsWithResponse(String threadId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listRunsWithResponseAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getRunWithResponseAsync(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> submitToolOutputsToRunWithResponse(String threadId, String runId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.submitToolOutputsToRunWithResponseAsync(threadId, runId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.cancelRunWithResponseAsync(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createThreadAndRunWithResponse(BinaryData createAndRunThreadOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createThreadAndRunWithResponseAsync(createAndRunThreadOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunStepWithResponse(String threadId, String runId, String stepId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getRunStepWithResponseAsync(threadId, runId, stepId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listRunStepsWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listRunStepsWithResponseAsync(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listFilesWithResponse(RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listFilesWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteFileWithResponse(String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteFileWithResponseAsync(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Assistant> getAssistant(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAssistantWithResponse(assistantId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Assistant)protocolMethodData.toObject(Assistant.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AssistantThread> createThread(AssistantThreadCreationOptions assistantThreadCreationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createThreadWithResponse(BinaryData.fromObject((Object)assistantThreadCreationOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AssistantThread)protocolMethodData.toObject(AssistantThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AssistantThread> getThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getThreadWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AssistantThread)protocolMethodData.toObject(AssistantThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadDeletionStatus> deleteThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteThreadWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadDeletionStatus)protocolMethodData.toObject(ThreadDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<ThreadMessage>> listMessages(String threadId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listMessagesWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfThreadMessage)protocolMethodData.toObject(OpenAIPageableListOfThreadMessage.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<ThreadMessage>> listMessages(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.listMessagesWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfThreadMessage)protocolMethodData.toObject(OpenAIPageableListOfThreadMessage.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> getMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getMessageWithResponse(threadId, messageId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<ThreadRun>> listRuns(String threadId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listRunsWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfThreadRun)protocolMethodData.toObject(OpenAIPageableListOfThreadRun.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<ThreadRun>> listRuns(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.listRunsWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfThreadRun)protocolMethodData.toObject(OpenAIPageableListOfThreadRun.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> getRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRunWithResponse(threadId, runId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> cancelRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.cancelRunWithResponse(threadId, runId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> createThreadAndRun(CreateAndRunThreadOptions createAndRunThreadOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createThreadAndRunWithResponse(BinaryData.fromObject((Object)createAndRunThreadOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamUpdate> createThreadAndRunStream(CreateAndRunThreadOptions createAndRunThreadOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData inputJson = BinaryData.fromObject((Object)createAndRunThreadOptions);
        BinaryData adjustedJson = OpenAIUtils.injectStreamJsonField(inputJson, true);
        Flux responseStream = this.createThreadAndRunWithResponse(adjustedJson, requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents eventStream = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return eventStream.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunStep> getRunStep(String threadId, String runId, String stepId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRunStepWithResponse(threadId, runId, stepId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RunStep)protocolMethodData.toObject(RunStep.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<RunStep>> listRunSteps(String threadId, String runId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listRunStepsWithResponse(threadId, runId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfRunStep)protocolMethodData.toObject(OpenAIPageableListOfRunStep.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<RunStep>> listRunSteps(String threadId, String runId, List<RunIncludes> runInclude) {
        RequestOptions requestOptions = new RequestOptions();
        if (runInclude != null && !runInclude.isEmpty()) {
            requestOptions.addQueryParam("include[]", runInclude.stream().map(item -> Objects.toString(item, "")).collect(Collectors.joining(",")), false);
        }
        return this.listRunStepsWithResponse(threadId, runId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfRunStep)protocolMethodData.toObject(OpenAIPageableListOfRunStep.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<RunStep>> listRunSteps(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.listRunStepsWithResponse(threadId, runId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfRunStep)protocolMethodData.toObject(OpenAIPageableListOfRunStep.class)).map(assistantList -> PageableListAccessHelper.create(assistantList.getData(), assistantList.getFirstId(), assistantList.getLastId(), assistantList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<OpenAIFile>> listFiles(FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        if (purpose != null) {
            requestOptions.addQueryParam("purpose", purpose.toString(), false);
        }
        return this.listFilesWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> ((FileListResponse)protocolMethodData.toObject(FileListResponse.class)).getData());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<OpenAIFile>> listFiles() {
        RequestOptions requestOptions = new RequestOptions();
        return this.listFilesWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> ((FileListResponse)protocolMethodData.toObject(FileListResponse.class)).getData());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileDeletionStatus> deleteFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteFileWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (FileDeletionStatus)protocolMethodData.toObject(FileDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateAssistantWithResponse(String assistantId, BinaryData updateAssistantOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateAssistantWithResponseAsync(assistantId, updateAssistantOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateThreadWithResponse(String threadId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateThreadWithResponseAsync(threadId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateMessageWithResponse(String threadId, String messageId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateMessageWithResponseAsync(threadId, messageId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateRunWithResponse(String threadId, String runId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.updateRunWithResponseAsync(threadId, runId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> uploadFileWithResponse(BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.uploadFileWithResponseAsync(request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getFileWithResponseAsync(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Assistant> updateAssistant(String assistantId, UpdateAssistantOptions updateAssistantOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateAssistantWithResponse(assistantId, BinaryData.fromObject((Object)updateAssistantOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Assistant)protocolMethodData.toObject(Assistant.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> updateMessage(String threadId, String messageId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest().setMetadata(metadata);
        BinaryData updateMessageRequest = BinaryData.fromObject((Object)updateMessageRequestObj);
        return this.updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> updateMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest();
        BinaryData updateMessageRequest = BinaryData.fromObject((Object)updateMessageRequestObj);
        return this.updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> createRun(String threadId, CreateRunOptions createRunOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createRunWithResponse(threadId, BinaryData.fromObject((Object)createRunOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> createRun(AssistantThread thread, Assistant assistant) {
        return this.createRun(thread.getId(), new CreateRunOptions(assistant.getId()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamUpdate> createRunStream(String threadId, String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData inputJson = BinaryData.fromObject((Object)new CreateRunOptions(assistantId));
        BinaryData adjustedJson = OpenAIUtils.injectStreamJsonField(inputJson, true);
        Flux responseStream = this.createRunWithResponse(threadId, BinaryData.fromObject((Object)adjustedJson), requestOptions).flatMapMany(it -> ((BinaryData)it.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents openAIServerSentEvents = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return openAIServerSentEvents.getEvents();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamUpdate> createRunStream(String threadId, CreateRunOptions createRunOptions) {
        RequestOptions requestOptions = new RequestOptions();
        BinaryData inputJson = BinaryData.fromObject((Object)createRunOptions);
        BinaryData adjustedJson = OpenAIUtils.injectStreamJsonField(inputJson, true);
        Flux responseStream = this.createRunWithResponse(threadId, adjustedJson, requestOptions).flatMapMany(it -> ((BinaryData)it.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents openAIServerSentEvents = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return openAIServerSentEvents.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> createRun(String threadId, CreateRunOptions createRunOptions, List<RunIncludes> runInclude) {
        RequestOptions requestOptions = new RequestOptions();
        if (runInclude != null && !runInclude.isEmpty()) {
            requestOptions.addQueryParam("include[]", runInclude.stream().map(Object::toString).collect(Collectors.joining(",")), false);
        }
        return this.createRunWithResponse(threadId, BinaryData.fromObject((Object)createRunOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamUpdate> createRunStream(String threadId, CreateRunOptions createRunOptions, List<RunIncludes> runInclude) {
        RequestOptions requestOptions = new RequestOptions();
        if (runInclude != null && !runInclude.isEmpty()) {
            requestOptions.addQueryParam("include[]", runInclude.stream().map(Object::toString).collect(Collectors.joining(",")), false);
        }
        BinaryData inputJson = BinaryData.fromObject((Object)createRunOptions);
        BinaryData adjustedJson = OpenAIUtils.injectStreamJsonField(inputJson, true);
        Flux responseStream = this.createRunWithResponse(threadId, adjustedJson, requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents openAIServerSentEvents = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return openAIServerSentEvents.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> updateRun(String threadId, String runId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest().setMetadata(metadata);
        BinaryData updateRunRequest = BinaryData.fromObject((Object)updateRunRequestObj);
        return this.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> updateRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest();
        BinaryData updateRunRequest = BinaryData.fromObject((Object)updateRunRequestObj);
        return this.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OpenAIFile> getFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getFileWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIFile)protocolMethodData.toObject(OpenAIFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<OpenAIFile> uploadFile(FileDetails file, FilePurpose purpose, String filename) {
        file.setFilename(filename);
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest requestObj = new UploadFileRequest(file, purpose).setFilename(filename);
        BinaryData request = new MultipartFormDataHelper(requestOptions).serializeFileField("file", requestObj.getFile().getContent(), requestObj.getFile().getContentType(), requestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)requestObj.getPurpose())).serializeTextField("filename", requestObj.getFilename()).end().getRequestBody();
        return this.uploadFileWithResponse(request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIFile)protocolMethodData.toObject(OpenAIFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OpenAIFile> uploadFile(FileDetails file, FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest requestObj = new UploadFileRequest(file, purpose);
        BinaryData request = new MultipartFormDataHelper(requestOptions).serializeFileField("file", requestObj.getFile().getContent(), requestObj.getFile().getContentType(), requestObj.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)requestObj.getPurpose())).serializeTextField("filename", requestObj.getFilename()).end().getRequestBody();
        return this.uploadFileWithResponse(request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIFile)protocolMethodData.toObject(OpenAIFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileContentWithResponseAsync(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> getFileContent(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getFileContentWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (byte[])protocolMethodData.toObject(byte[].class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamUpdate> submitToolOutputsToRunStream(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest requestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(false);
        Flux responseStream = this.submitToolOutputsToRunWithResponse(threadId, runId, BinaryData.fromObject((Object)requestObj), requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents openAIServerSentEvents = new OpenAIServerSentEvents((Flux<ByteBuffer>)responseStream);
        return openAIServerSentEvents.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest requestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(false);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.submitToolOutputsToRunWithResponse(threadId, runId, request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listVectorStoresWithResponse(RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listVectorStoresWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreWithResponse(BinaryData vectorStoreOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createVectorStoreWithResponseAsync(vectorStoreOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getVectorStoreWithResponseAsync(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> modifyVectorStoreWithResponse(String vectorStoreId, BinaryData vectorStoreUpdateOptions, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.modifyVectorStoreWithResponseAsync(vectorStoreId, vectorStoreUpdateOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteVectorStoreWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteVectorStoreWithResponseAsync(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listVectorStoreFilesWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listVectorStoreFilesWithResponseAsync(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreFileWithResponse(String vectorStoreId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createVectorStoreFileWithResponseAsync(vectorStoreId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreFileWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getVectorStoreFileWithResponseAsync(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteVectorStoreFileWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.deleteVectorStoreFileWithResponseAsync(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreFileBatchWithResponse(String vectorStoreId, BinaryData request, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.createVectorStoreFileBatchWithResponseAsync(vectorStoreId, request, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.getVectorStoreFileBatchWithResponseAsync(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.cancelVectorStoreFileBatchWithResponseAsync(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listVectorStoreFileBatchFilesWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        OpenAIUtils.addAzureVersionToRequestOptions(this.serviceClient.getEndpoint(), requestOptions, this.serviceClient.getServiceVersion());
        return this.serviceClient.listVectorStoreFileBatchFilesWithResponseAsync(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AssistantThread> updateThread(String threadId, UpdateAssistantThreadOptions updateAssistantThreadOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateThreadWithResponse(threadId, BinaryData.fromObject((Object)updateAssistantThreadOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AssistantThread)protocolMethodData.toObject(AssistantThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, ThreadMessageOptions threadMessageOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createMessageWithResponse(threadId, BinaryData.fromObject((Object)threadMessageOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<VectorStore>> listVectorStores(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listVectorStoresWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfVectorStore)protocolMethodData.toObject(OpenAIPageableListOfVectorStore.class)).map(vectorStoreList -> PageableListAccessHelper.create(vectorStoreList.getData(), vectorStoreList.getFirstId(), vectorStoreList.getLastId(), vectorStoreList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<VectorStore>> listVectorStores() {
        RequestOptions requestOptions = new RequestOptions();
        return this.listVectorStoresWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfVectorStore)protocolMethodData.toObject(OpenAIPageableListOfVectorStore.class)).map(vectorStoreList -> PageableListAccessHelper.create(vectorStoreList.getData(), vectorStoreList.getFirstId(), vectorStoreList.getLastId(), vectorStoreList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> createVectorStore(VectorStoreOptions vectorStoreOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createVectorStoreWithResponse(BinaryData.fromObject((Object)vectorStoreOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> getVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getVectorStoreWithResponse(vectorStoreId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> modifyVectorStore(String vectorStoreId, VectorStoreUpdateOptions vectorStoreUpdateOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.modifyVectorStoreWithResponse(vectorStoreId, BinaryData.fromObject((Object)vectorStoreUpdateOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreDeletionStatus> deleteVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteVectorStoreWithResponse(vectorStoreId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreDeletionStatus)protocolMethodData.toObject(VectorStoreDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<VectorStoreFile>> listVectorStoreFiles(String vectorStoreId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listVectorStoreFilesWithResponse(vectorStoreId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfVectorStoreFile)protocolMethodData.toObject(OpenAIPageableListOfVectorStoreFile.class)).map(vectorStoreFileList -> PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<VectorStoreFile>> listVectorStoreFiles(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.listVectorStoreFilesWithResponse(vectorStoreId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfVectorStoreFile)protocolMethodData.toObject(OpenAIPageableListOfVectorStoreFile.class)).map(vectorStoreFileList -> PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFile> createVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileRequest createVectorStoreFileRequestObj = new CreateVectorStoreFileRequest(fileId);
        BinaryData createVectorStoreFileRequest = BinaryData.fromObject((Object)createVectorStoreFileRequestObj);
        return this.createVectorStoreFileWithResponse(vectorStoreId, createVectorStoreFileRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFile> getVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileDeletionStatus> deleteVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileDeletionStatus)protocolMethodData.toObject(VectorStoreFileDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> createVectorStoreFileBatch(String vectorStoreId, List<String> fileIds) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileBatchRequest createVectorStoreFileBatchRequestObj = new CreateVectorStoreFileBatchRequest(fileIds);
        BinaryData createVectorStoreFileBatchRequest = BinaryData.fromObject((Object)createVectorStoreFileBatchRequestObj);
        return this.createVectorStoreFileBatchWithResponse(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> getVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> cancelVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.cancelVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<VectorStoreFile>> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.listVectorStoreFileBatchFilesWithResponse(vectorStoreId, batchId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfVectorStoreFile)protocolMethodData.toObject(OpenAIPageableListOfVectorStoreFile.class)).map(vectorStoreFileList -> PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageableList<VectorStoreFile>> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.listVectorStoreFileBatchFilesWithResponse(vectorStoreId, batchId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OpenAIPageableListOfVectorStoreFile)protocolMethodData.toObject(OpenAIPageableListOfVectorStoreFile.class)).map(vectorStoreFileList -> PageableListAccessHelper.create(vectorStoreFileList.getData(), vectorStoreFileList.getFirstId(), vectorStoreFileList.getLastId(), vectorStoreFileList.isHasMore()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFile> createVectorStoreFile(String vectorStoreId, String fileId, VectorStoreChunkingStrategyRequest chunkingStrategy) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileRequest createVectorStoreFileRequestObj = new CreateVectorStoreFileRequest(fileId).setChunkingStrategy(chunkingStrategy);
        BinaryData createVectorStoreFileRequest = BinaryData.fromObject((Object)createVectorStoreFileRequestObj);
        return this.createVectorStoreFileWithResponse(vectorStoreId, createVectorStoreFileRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> createVectorStoreFileBatch(String vectorStoreId, List<String> fileIds, VectorStoreChunkingStrategyRequest chunkingStrategy) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileBatchRequest createVectorStoreFileBatchRequestObj = new CreateVectorStoreFileBatchRequest(fileIds).setChunkingStrategy(chunkingStrategy);
        BinaryData createVectorStoreFileBatchRequest = BinaryData.fromObject((Object)createVectorStoreFileBatchRequestObj);
        return this.createVectorStoreFileBatchWithResponse(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunStep> getRunStep(String threadId, String runId, String stepId, List<RunIncludes> runInclude) {
        RequestOptions requestOptions = new RequestOptions();
        if (runInclude != null) {
            requestOptions.addQueryParam("include[]", runInclude.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getRunStepWithResponse(threadId, runId, stepId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RunStep)protocolMethodData.toObject(RunStep.class));
    }
}

