/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.persistence;

import com.ontotext.forest.persistence.JsonDB;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.graphdb.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class RepositorySimilarityConfig
extends PersistedConfig {
    private File storageDirectory;
    private static final String FILENAME = "similarity.js";

    @Override
    protected void init(File storageDirectory) {
        this.storageDirectory = storageDirectory;
        Path path = RepositorySimilarityConfig.getDBFile(storageDirectory, FILENAME).toPath();
        this.db = new JsonDB(path);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void initPersistentConfigForRepo(String repo) {
        this.init(new File(Config.getDataDirectory() + File.separator + "repositories" + File.separator + repo));
    }

    public static void deletePersistentConfigForRepo(String repo) {
        new File(Config.getDataDirectory() + File.separator + "repositories" + File.separator + repo + File.separator + FILENAME).delete();
    }
}

