/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.persistence;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;

public class ConverterClassLoader
extends URLClassLoader {
    public ConverterClassLoader(URL url) {
        super(new URL[]{url}, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            this.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(name);
    }

    public ObjectNode invokeConverter(Path path) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = this.loadClass("com.ontotext.forest.JsonTreeConvertor");
            Method m = c.getMethod("openDBandConvertAll", Path.class);
            m.setAccessible(true);
            Thread.currentThread().setContextClassLoader(this);
            ObjectNode objectNode = (ObjectNode)m.invoke(null, path);
            return objectNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }
}

