/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.rdf4j.experimental;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.rdf4j.RDF4J;
import org.apache.commons.rdf.rdf4j.RDF4JBlankNodeOrIRI;
import org.apache.commons.rdf.rdf4j.RDF4JDataset;
import org.apache.commons.rdf.rdf4j.RDF4JGraph;
import org.apache.commons.rdf.simple.experimental.AbstractRDFParser;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.repository.util.RDFLoader;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class RDF4JParser
extends AbstractRDFParser<RDF4JParser> {
    private RDF4J rdf4jTermFactory;
    private ParserConfig parserConfig = new ParserConfig();

    protected RDF4J createRDFTermFactory() {
        return new RDF4J();
    }

    protected RDF4JParser prepareForParsing() throws IOException, IllegalStateException {
        RDF4JParser c = (RDF4JParser)super.prepareForParsing();
        c.rdf4jTermFactory = (RDF4J)this.getRdfTermFactory().filter(RDF4J.class::isInstance).orElseGet(c::createRDFTermFactory);
        return c;
    }

    protected void parseSynchronusly() throws IOException {
        Optional formatByMimeType = this.getContentType().flatMap(Rio::getParserFormatForMIMEType);
        String base = this.getBase().map(IRI::getIRIString).orElse(null);
        ParserConfig parserConfig = this.getParserConfig();
        RDFLoader loader = new RDFLoader(parserConfig, this.rdf4jTermFactory.getValueFactory());
        RDFHandler rdfHandler = this.makeRDFHandler();
        if (this.getSourceFile().isPresent()) {
            Optional formatByFilename = this.getSourceFile().map(Path::getFileName).map(Path::toString).flatMap(Rio::getParserFormatForFileName);
            RDFFormat format = formatByMimeType.orElse(formatByFilename.orElse(null));
            try (InputStream in = Files.newInputStream((Path)this.getSourceFile().get(), new OpenOption[0]);){
                loader.load(in, base, format, rdfHandler);
            }
        }
        if (this.getSourceIri().isPresent()) {
            try {
                URL url = new URL(((IRI)this.getSourceIri().get()).getIRIString());
                loader.load(url, base, (RDFFormat)formatByMimeType.orElse(null), this.makeRDFHandler());
            }
            catch (MalformedURLException ex) {
                throw new IOException("Can't handle source URL: " + this.getSourceIri().get(), ex);
            }
        }
        loader.load((InputStream)this.getSourceInputStream().get(), base, (RDFFormat)formatByMimeType.orElse(null), rdfHandler);
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    protected RDFHandler makeRDFHandler() {
        if (this.getTargetDataset().filter(RDF4JDataset.class::isInstance).isPresent()) {
            RDF4JDataset dataset = (RDF4JDataset)this.getTargetDataset().get();
            if (dataset.asRepository().isPresent()) {
                return new RDFInserter(((Repository)dataset.asRepository().get()).getConnection());
            }
            if (dataset.asModel().isPresent()) {
                Model model = (Model)dataset.asModel().get();
                return new AddToModel(model);
            }
        } else if (this.getTargetGraph().filter(RDF4JGraph.class::isInstance).isPresent()) {
            RDF4JGraph graph = (RDF4JGraph)this.getTargetGraph().get();
            if (graph.asRepository().isPresent()) {
                RDFInserter inserter = new RDFInserter(((Repository)graph.asRepository().get()).getConnection());
                if (!graph.getContextMask().isEmpty()) {
                    Stream b = graph.getContextMask().stream();
                    Stream<Resource> c = b.map(RDF4JBlankNodeOrIRI::asValue);
                    Resource[] contexts = (Resource[])c.toArray(Resource[]::new);
                    inserter.enforceContext(contexts);
                }
                return inserter;
            }
            if (graph.asModel().isPresent() && graph.getContextMask().isEmpty()) {
                Model model = (Model)graph.asModel().get();
                return new AddToModel(model);
            }
        }
        return new AddToQuadConsumer(this.getTarget());
    }

    private static final class AddToModel
    extends AbstractRDFHandler {
        private final Model model;

        public AddToModel(Model model) {
            this.model = model;
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            this.model.add((Object)st);
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            this.model.setNamespace(prefix, uri);
        }
    }

    private final class AddToQuadConsumer
    extends AbstractRDFHandler {
        private final Consumer<Quad> quadTarget;

        private AddToQuadConsumer(Consumer<Quad> quadTarget) {
            this.quadTarget = quadTarget;
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            this.quadTarget.accept(RDF4JParser.this.rdf4jTermFactory.asQuad(st));
        }
    }
}

