import { TranslationParameter } from '../../models/translation/translation-parameter';
/**
 * The purpose of this component is to display translated literals in the DOM. A Stencil component re-renders when a prop or state changes,
 * but it may not re-render when the language changes. In such cases, this component should be used. It handles language change events
 * and re-translates the passed language and translation parameters.
 * Example of usage:
 * <code>
 *    <translate-label labelKey={item.labelKey} translationParameter={item.translationParameter}></translate-label>
 *    <translate-label labelKey="example.label></translate-label>
 * </code>
 */
export declare class TranslateLabel {
    private unsubscribeTranslationChanged;
    /**
     * Represents a label key.
     */
    labelKey: string;
    /**
     * Represents an array of translation parameters.
     */
    translationParameters: TranslationParameter[];
    translatedLabel: string;
    connectedCallback(): void;
    disconnectedCallback(): void;
    render(): any;
}
