import { NavbarToggledEvent } from '../onto-navbar/navbar-toggled-event';
import { AuthenticatedUser, SecurityConfig } from "../../../../api/dist/ontotext-workbench-api";
export declare class OntoLayout {
    private readonly authenticationService;
    private readonly navigationContextService;
    hostElement: HTMLOntoLayoutElement;
    private navbarRef;
    authenticatedUser: AuthenticatedUser;
    authToken: string | null;
    securityConfig: SecurityConfig;
    isLowResolution: boolean;
    showHeader: boolean;
    /**
     * List of subscriptions to manage component lifecycle
     * */
    private readonly subscriptions;
    private readonly windowResizeObserver;
    private isNavbarCollapsed;
    constructor();
    componentDidLoad(): void;
    connectedCallback(): void;
    /**
     * Lifecycle method called when the component is about to be removed from the DOM.
     * Unsubscribes from all subscriptions to prevent memory leaks.
     */
    disconnectedCallback(): void;
    render(): any;
    /**
     * Event listener for the navbar toggled event. The layout needs to respond properly when the navbar is toggled in
     * order to fit the content.
     * @param event
     */
    onNavbarToggled(event: CustomEvent<NavbarToggledEvent>): void;
    /**
     * Event listener for window resize event. We need to handle this in order to allow the navbar to collapse when the
     * window is resized.
     */
    onResize(): void;
    private windowResizeHandler;
    private handleStorageChange;
    private subscribeToSecurityChanges;
    private updateVisibility;
    private isAuthenticatedFully;
    private shouldShowMenu;
    private assignNavbarRef;
    private setNavbarItemVisibility;
    private subscribeToNavigationEnd;
}
