import{EventService,AuthenticatedUserMapper,LanguageContextService,LicenseContextService,NavigationEnd,MapperProvider,ProductInfoContextService,RepositoryContextService,RepositoryService,SecurityContextService,ServiceProvider,ToastMessage,EventEmitter,CREATE_TOAST_EVENT,RepositoryLocationContextService,AutocompleteContextService,NamespacesContextService,NamespaceMap}from"../../../../../api/dist/ontotext-workbench-api";import en from"../../assets/i18n/en.json";import fr from"../../assets/i18n/fr.json";export class OntoTestContext{constructor(){this.bundles={en,fr},this.eventEmitter=new EventEmitter,this.onLanguageChanged()}updateLicense(e){return ServiceProvider.get(LicenseContextService).updateGraphdbLicense(e),Promise.resolve()}updateProductInfo(e){return ServiceProvider.get(ProductInfoContextService).updateProductInfo(e),Promise.resolve()}loadRepositories(){return ServiceProvider.get(RepositoryService).getRepositories().then(e=>{ServiceProvider.get(RepositoryContextService).updateRepositoryList(e)}),Promise.resolve()}setAuthenticatedUser(e){return ServiceProvider.get(SecurityContextService).updateAuthenticatedUser(MapperProvider.get(AuthenticatedUserMapper).mapToModel(e)),Promise.resolve()}setSecurityConfig(e){return ServiceProvider.get(SecurityContextService).updateSecurityConfig(e),Promise.resolve()}changeLanguage(e){return ServiceProvider.get(LanguageContextService).updateLanguageBundle(this.bundles[e]),Promise.resolve()}emitNavigateEndEvent(e,t){return ServiceProvider.get(EventService).emit(new NavigationEnd(e,t)),Promise.resolve()}updateSelectedRepository(e){return ServiceProvider.get(RepositoryContextService).updateSelectedRepository(e),Promise.resolve()}updateIsLoadingActiveRepositoryLocation(e){return ServiceProvider.get(RepositoryLocationContextService).updateIsLoading(e),Promise.resolve()}addToastr(e){return this.eventEmitter.emit({NAME:CREATE_TOAST_EVENT,payload:new ToastMessage(e.type,e.message)}),Promise.resolve()}setAutocomplete(e){return ServiceProvider.get(AutocompleteContextService).updateAutocompleteEnabled(e),Promise.resolve()}updateNamespaces(e){return ServiceProvider.get(NamespacesContextService).updateNamespaces(new NamespaceMap(e)),Promise.resolve()}onLanguageChanged(){ServiceProvider.get(LanguageContextService).onSelectedLanguageChanged(e=>{e&&this.changeLanguage(e)})}static get is(){return"onto-test-context"}static get methods(){return{updateLicense:{complexType:{signature:"(license: License) => Promise<void>",parameters:[{name:"license",type:"License",docs:"- The new License object to be set."}],references:{Promise:{location:"global",id:"global::Promise"},License:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::License"}},return:"Promise<void>"},docs:{text:"Updates the license information in the context.\n\nThis method uses the LicenseContextService to update the license\nand returns a resolved Promise once the operation is complete.",tags:[{name:"param",text:"license - The new License object to be set."},{name:"returns",text:"A Promise that resolves when the license update is complete."}]}},updateProductInfo:{complexType:{signature:"(productInfo: ProductInfo) => Promise<void>",parameters:[{name:"productInfo",type:"ProductInfo",docs:"- The new ProductInfo object to be set."}],references:{Promise:{location:"global",id:"global::Promise"},ProductInfo:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::ProductInfo"}},return:"Promise<void>"},docs:{text:"Updates the product information in the context.\n\nThis method uses the ProductInfoContextService to update the product information\nand returns a resolved Promise once the operation is complete.",tags:[{name:"param",text:"productInfo - The new ProductInfo object to be set."},{name:"returns",text:"A Promise that resolves when the product information update is complete."}]}},loadRepositories:{complexType:{signature:"() => Promise<void>",parameters:[],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<void>"},docs:{text:"Loads the repositories in the application.",tags:[]}},setAuthenticatedUser:{complexType:{signature:"(user: AuthenticatedUser) => Promise<void>",parameters:[{name:"user",type:"AuthenticatedUser",docs:"- The AuthenticatedUser object containing the user's authentication information."}],references:{Promise:{location:"global",id:"global::Promise"},AuthenticatedUser:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::AuthenticatedUser"}},return:"Promise<void>"},docs:{text:"Sets the authenticated user in the application context.",tags:[{name:"param",text:"user - The AuthenticatedUser object containing the user's authentication information."},{name:"returns",text:"A Promise that resolves when the authenticated user has been successfully updated"}]}},setSecurityConfig:{complexType:{signature:"(securityConfig: SecurityConfig) => Promise<void>",parameters:[{name:"securityConfig",type:"SecurityConfig",docs:"- The SecurityConfig object containing the new security settings to be applied."}],references:{Promise:{location:"global",id:"global::Promise"},SecurityConfig:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::SecurityConfig"}},return:"Promise<void>"},docs:{text:"Sets the security configuration in the application context.",tags:[{name:"param",text:"securityConfig - The SecurityConfig object containing the new security settings to be applied."},{name:"returns",text:"A Promise that resolves when the security configuration has been successfully updated."}]}},changeLanguage:{complexType:{signature:"(language: string) => Promise<void>",parameters:[{name:"language",type:"string",docs:"- The language code (e.g., 'en' for English, 'fr' for French)\n  representing the desired language to switch to."}],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<void>"},docs:{text:"Changes the application's language by updating the language bundle.\n\nThis method uses the LanguageContextService to update the language bundle\nbased on the provided language code. It retrieves the corresponding bundle\nfrom the predefined bundles object and updates the context.",tags:[{name:"param",text:"language - The language code (e.g., 'en' for English, 'fr' for French)\n  representing the desired language to switch to."},{name:"returns",text:"A Promise that resolves when the language update is complete."}]}},emitNavigateEndEvent:{complexType:{signature:"(oldUrl: string, newUrl: string) => Promise<void>",parameters:[{name:"oldUrl",type:"string",docs:"- the value will be used as old url in the event payload."},{name:"newUrl",type:"string",docs:"- the value will be used as new url in the event payload."}],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<void>"},docs:{text:"Emits {@see NavigationEnd} event with <code>oldUrl</code> and <code>newUrl</code>.",tags:[{name:"param",text:"oldUrl - the value will be used as old url in the event payload."},{name:"param",text:"newUrl - the value will be used as new url in the event payload."}]}},updateSelectedRepository:{complexType:{signature:"(repositoryReference: RepositoryReference) => Promise<void>",parameters:[{name:"repositoryReference",type:"RepositoryReference",docs:"- The RepositoryReference object representing the repository to select."}],references:{Promise:{location:"global",id:"global::Promise"},RepositoryReference:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::RepositoryReference"}},return:"Promise<void>"},docs:{text:"Updates the selected repository in the application context.",tags:[{name:"method",text:"updateSelectedRepository"},{name:"param",text:"repositoryReference - The RepositoryReference object representing the repository to select."},{name:"returns",text:"A Promise that resolves when the selected repository has been updated."}]}},updateIsLoadingActiveRepositoryLocation:{complexType:{signature:"(isLoading: boolean) => Promise<void>",parameters:[{name:"isLoading",type:"boolean",docs:"- A boolean value indicating whether the repository location is in a loading state.\n  True indicates request is in progress, false indicates loading is complete."}],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<void>"},docs:{text:"Updates whether the active repository request is in a loading state.",tags:[{name:"param",text:"isLoading - A boolean value indicating whether the repository location is in a loading state.\n  True indicates request is in progress, false indicates loading is complete."},{name:"returns",text:"A Promise that resolves when the loading state update is complete."}]}},addToastr:{complexType:{signature:"(toast: ToastMessage) => Promise<void>",parameters:[{name:"toast",type:"ToastMessage",docs:"- The ToastMessage object containing the notification details\n  such as message content, type, and display options."}],references:{Promise:{location:"global",id:"global::Promise"},ToastMessage:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::ToastMessage"}},return:"Promise<void>"},docs:{text:"Adds a toast notification to the application.",tags:[{name:"param",text:"toast - The ToastMessage object containing the notification details\n  such as message content, type, and display options."}]}},setAutocomplete:{complexType:{signature:"(enabled: boolean) => Promise<void>",parameters:[{name:"enabled",type:"boolean",docs:"whether autocomplete is enabled or disabled."}],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<void>"},docs:{text:"Sets the autocomplete status in the context.",tags:[{name:"param",text:"enabled whether autocomplete is enabled or disabled."}]}},updateNamespaces:{complexType:{signature:"(rawNamespaces: Record<string, string>) => Promise<void>",parameters:[{name:"rawNamespaces",type:"{ [x: string]: string; }",docs:"- The namespace map containing prefix-to-URI mappings to be used throughout the application"}],references:{Promise:{location:"global",id:"global::Promise"},Record:{location:"global",id:"global::Record"}},return:"Promise<void>"},docs:{text:"Sets the namespace map in the application context.",tags:[{name:"param",text:"rawNamespaces - The namespace map containing prefix-to-URI mappings to be used throughout the application"},{name:"returns",text:"A Promise that resolves when the namespace map has been successfully updated"}]}}}}}