import{h}from"@stencil/core";import{AutocompleteContextService,AutocompleteService,AutocompleteStorageService,EventService,NamespacesContextService,navigateTo,OntoToastrService,ResourceSearchStorageService,ServiceProvider,SubscriptionList,Suggestion,SuggestionSelectedPayload,SuggestionType,UriUtil}from"../../../../../api/dist/ontotext-workbench-api";import{TranslationService}from"../../services/translation.service";import{HtmlUtil}from"../../utils/html-util";import{OntoTooltipPlacement}from"../onto-tooltip/models/onto-tooltip-placement";import{ResourceSearchConstants}from"../../models/resource-search/resource-search-constants";export class OntoSearchResourceInput{constructor(){this.autocompleteService=ServiceProvider.get(AutocompleteService),this.autocompleteContextService=ServiceProvider.get(AutocompleteContextService),this.autocompleteStorageService=ServiceProvider.get(AutocompleteStorageService),this.resourceSearchStorageService=ServiceProvider.get(ResourceSearchStorageService),this.toastrService=ServiceProvider.get(OntoToastrService),this.eventService=ServiceProvider.get(EventService),this.namespaceContextService=ServiceProvider.get(NamespacesContextService),this.subscriptions=new SubscriptionList,this.autocompleteWarningShown=!1,this.skipValidation=!1,this.isHidden=!1,this.isAutocompleteEnabled=!1,this.handleInput=e=>{const t=e.target;t.value?(this.setInputValue(t.value),this.checkForAutocomplete()):this.clearInput()},this.clearInput=()=>{this.setInputValue(""),this.preserveSearch&&this.resourceSearchStorageService.clearStoredSearch()},this.onKeyDown=e=>{switch(e.key){case"Enter":this.onEnter(e);break;case"Escape":this.onEscape();break;case"ArrowUp":this.onArrowUp(e);break;case"ArrowDown":this.onArrowDown(e)}}}onVisibilityChange(e){var t;e?null===(t=this.searchResult)||void 0===t||t.clearSuggestions():this.setInputValue(this.resourceSearchStorageService.getInputValue())}connectedCallback(){this.onAutocompleteEnabledChange(),this.onNamespaceChange(),this.loadInputFromStorage()}disconnectedCallback(){this.subscriptions.unsubscribeAll()}render(){var e,t,s;return h("section",{key:"c038af36fa4270f35dab06147536206eab600ce5",class:"search-resources-input"},h("div",{key:"d9b3044c17de9765bd3cbc724ab76bb13e823136",class:"input-row"},h("span",{key:"297d9e5f94d414f227349b79f26f277e3c246c39",class:"input-wrapper"},h("input",{key:"65db17686344b92e8fb59cba15e48538da26c07e",value:this.inputValue,id:this.context,type:"text",autocomplete:"off",placeholder:`${TranslationService.translate("rdf_search.labels.search")}...`,ref:e=>this.inputRef=e,onKeyDown:this.onKeyDown,"data-test":this.context,onInput:this.handleInput}),(null===(e=this.inputValue)||void 0===e?void 0:e.length)?h("i",{onClick:this.clearInput,"tooltip-content":TranslationService.translate("rdf_search.tooltips.clear"),"tooltip-placement":OntoTooltipPlacement.BOTTOM,class:"ri-close-line clear-input"}):""),null===(t=this.buttonConfig)||void 0===t?void 0:t.getButtons().getItems().map(e=>h("button",{key:e.label,onClick:this.handleButtonClick(e),class:e.selected?"selected":""},e.label))),h("span",{key:"cfb1aa194945352f33b786eb7bf2bae98c6e9ea2",class:"hint"},TranslationService.translate("rdf_search.labels.hint")),h("section",{key:"e17c4e528f8c05ed983df81e2c364356170dac12",class:"autocomplete-results-wrapper","data-test":"onto-autocomplete-results"},null===(s=this.searchResult)||void 0===s?void 0:s.getSuggestions().getItems().map(e=>h("p",{key:e.getId(),onClick:this.onSuggestionClick(e),"data-test":"onto-autocomplete-suggestion",onMouseMove:this.hoverSuggestion(e),class:`${e.isHovered()?"hovered":""} ${e.isSelected()?"selected":""}`,innerHTML:e.getDescription()}))))}handleButtonClick(e){return()=>this.buttonConfig=this.buttonConfig.selectButton(e)}loadAutocompleteResults(){var e;this.inputValue?this.isAutocompleteEnabled&&this.autocompleteService.search(this.inputValue).then(e=>{this.onResultsReceived(e)}):null===(e=this.searchResult)||void 0===e||e.clearSuggestions()}hoverSuggestion(e){return()=>this.searchResult=this.searchResult.hoverSuggestion(e)}onAutocompleteEnabledChange(){this.isAutocompleteEnabled=this.autocompleteStorageService.isEnabled(),this.subscriptions.add(this.autocompleteContextService.onAutocompleteEnabledChanged(e=>{this.isAutocompleteEnabled=null!=e?e:this.isAutocompleteEnabled}))}checkForAutocomplete(){if(this.inputValue.length>0&&!this.isAutocompleteEnabled&&!this.autocompleteWarningShown){this.autocompleteWarningShown=!0;const e=TranslationService.translate("rdf_search.toasts.autocomplete_is_off");this.toastrService.warning(`<a class="no-underline" style="font-weight: 500">${e}</a>`,{onClick:navigateTo("autocomplete"),removeOnClick:!0})}}onSuggestionClick(e){return t=>{e.setOverrideToVisual(t.ctrlKey||t.metaKey),this.searchRdfResource(e)}}searchRdfResource(e){e.getType()===SuggestionType.PREFIX?this.expandPrefix(e):(this.notifyRdfResourceSelected(e),this.preserveSearch&&this.resourceSearchStorageService.setLastSelected(e))}notifyRdfResourceSelected(e){var t;this.searchResult=null===(t=this.searchResult)||void 0===t?void 0:t.selectSuggestion(e),this.eventService.emit({NAME:ResourceSearchConstants.SUGGESTION_SELECTED_EVENT,payload:new SuggestionSelectedPayload(e,this.context)})}expandPrefix(e){this.setInputValue(this.namespaces.getByPrefix(e.getValue())),this.inputRef.focus()}setInputValue(e){this.inputValue=e,this.preserveSearch&&this.resourceSearchStorageService.setInputValue(this.inputValue),this.loadAutocompleteResults()}onNamespaceChange(){this.subscriptions.add(this.namespaceContextService.onNamespacesChanged(e=>{this.namespaces=e}))}onEnter(e){var t;let s=null===(t=this.searchResult)||void 0===t?void 0:t.getHoveredSuggestion();s||(s=new Suggestion({value:UriUtil.removeAngleBrackets(this.inputValue),type:SuggestionType.URI})),s.setOverrideToVisual(e.ctrlKey||e.metaKey),this.validateAndSearch(s)}onArrowUp(e){this.searchResult=this.searchResult.hoverPreviousSuggestion(),this.displaySuggestion(e)}onArrowDown(e){this.searchResult=this.searchResult.hoverNextSuggestion(),this.displaySuggestion(e)}displaySuggestion(e){e.preventDefault(),this.inputRef.value=this.searchResult.getHoveredSuggestion().getValue(),this.scrollToSuggestionBySelector("p.hovered")}getSuggestionValue(e){return e.getType()===SuggestionType.PREFIX?this.namespaces.getByPrefix(e.getValue()):e.getValue()}scrollToSuggestionBySelector(e,t){HtmlUtil.waitForElement(e).then(()=>{HtmlUtil.scrollElementIntoView(e,t)})}validateAndSearch(e){if(!this.skipValidation){if(!e.getValue())return void this.toastrService.error(TranslationService.translate("rdf_search.toasts.empty_input"));if(!UriUtil.isValidUri(this.getSuggestionValue(e)))return void this.toastrService.error(TranslationService.translate("rdf_search.toasts.invalid_uri"))}this.searchRdfResource(e)}onEscape(){this.preserveSearch||this.clearInput()}loadInputFromStorage(){this.preserveSearch&&(this.inputValue=this.resourceSearchStorageService.getInputValue()||"")}onResultsReceived(e){const t=null==e?void 0:e.getByValue(this.resourceSearchStorageService.getLastSelectedValue());t&&this.preserveSearch?(e.hoverSuggestion(t),this.searchResult=e.selectSuggestion(t),this.scrollToSuggestionBySelector("p.hovered.selected",{block:"start"})):(this.searchResult=e.hoverFirstSuggestion(),this.scrollToSuggestionBySelector("p.hovered",{block:"start"}))}static get is(){return"onto-search-resource-input"}static get originalStyleUrls(){return{$:["onto-search-resource-input.scss"]}}static get styleUrls(){return{$:["onto-search-resource-input.css"]}}static get properties(){return{context:{type:"string",attribute:"context",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"The search resource component can appear more than once per page. This context\nis used to differentiate them. When a suggestion is selected different parents\nmay need to do different things. The context is emitted alongside the suggestion\nupon select."},getter:!1,setter:!1,reflect:!1},skipValidation:{type:"boolean",attribute:"skip-validation",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Whether the rdf resource pre-search validation should be skipped."},getter:!1,setter:!1,reflect:!1,defaultValue:"false"},preserveSearch:{type:"boolean",attribute:"preserve-search",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Whether to preserve the input value and last selected suggestion\nIf true, both will be stored in local storage and loaded, when the component is rendered"},getter:!1,setter:!1,reflect:!1},isHidden:{type:"boolean",attribute:"is-hidden",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Whether the search component is currently hidden. Can be shown/hidden in the RDF search"},getter:!1,setter:!1,reflect:!1,defaultValue:"false"},buttonConfig:{type:"unknown",attribute:"button-config",mutable:!1,complexType:{original:"SearchButtonConfig",resolved:"SearchButtonConfig",references:{SearchButtonConfig:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::SearchButtonConfig"}}},required:!1,optional:!1,docs:{tags:[],text:"Button configuration for the search resource input.\nHolds buttons to be displayed, as well as additional configuration,\nsuch as whether the buttons should be treated as radio buttons."},getter:!1,setter:!1}}}static get states(){return{inputValue:{},searchResult:{},isAutocompleteEnabled:{}}}static get watchers(){return[{propName:"isHidden",methodName:"onVisibilityChange"}]}}