import { Service } from '../../providers/service/service';
import { AuthenticatedUser, SecurityConfig } from '../../models/security';
/**
 * Service class for handling security-related operations.
 */
export declare class SecurityService implements Service {
    private readonly securityRestService;
    private readonly securityContextService;
    /**
     * Updates the data of an authenticated user.
     *
     * Updates the authenticated user's data in the backend using the provided user object and updates the
     * context with the updated user data.
     *
     * @param user - The authenticated user object containing the updated data.
     * @returns A Promise that resolves when the user data has been successfully updated.
     */
    updateUserData(user: AuthenticatedUser): Promise<void>;
    /**
     * Retrieves the current security configuration from the backend.
     *
     * Fetches the security configuration and maps it to a `SecurityConfig` model using the appropriate mapper.
     *
     * @returns A Promise that resolves with the mapped `SecurityConfig` instance.
     */
    getSecurityConfig(): Promise<SecurityConfig>;
    /**
     * Retrieves the currently authenticated user from the backend.
     *
     * Fetches the authenticated user's information and maps it to an `AuthenticatedUser` model
     * using the appropriate mapper.
     *
     * @returns A Promise that resolves with the mapped `AuthenticatedUser` instance
     */
    getAuthenticatedUser(): Promise<AuthenticatedUser>;
}
