import { Mapper } from '../../../providers/mapper/mapper';
import { RepositoryList } from '../../../models/repositories';
/**
 * Maps server response data to a {@link RepositoryList} model.
 *
 * This mapper processes repository data grouped by location into a flat list of {@link Repository}
 * instances wrapped in a {@link RepositoryList}.
 */
export declare class RepositoryListMapper extends Mapper<RepositoryList> {
    private repositoryMapper;
    constructor();
    /**
     * Maps the raw data to an instance of the {@link RepositoryList} model.
     *
     * @param data - The raw server response containing repositories grouped by location URLs.
     *               The structure is a record where keys are location URLs and values are arrays of repository data.
     * @returns A {@link RepositoryList} model containing all repositories as a flat list.
     */
    mapToModel(data?: Record<string, unknown[]>): RepositoryList;
}
