import { DeriveContextServiceContract } from '../../models/context/update-context-method';
import { ContextService } from '../context';
type NavigationContextFields = {
    readonly PREVIOUS_ROUTE: string;
};
type NavigationContextFieldParams = {
    readonly PREVIOUS_ROUTE: string;
};
/**
 * Service for managing navigation context within the application.
 */
export declare class NavigationContextService extends ContextService<NavigationContextFields> implements DeriveContextServiceContract<NavigationContextFields, NavigationContextFieldParams> {
    /** Key used to store the previous route in the context */
    readonly PREVIOUS_ROUTE = "previousRoute";
    /**
     * Updates the previous route in the navigation context.
     *
     * @param value - The route path to store as the previous route
     */
    updatePreviousRoute(value: string): void;
    /**
     * Retrieves the previous route from the navigation context.
     * If the route ends with a '#' character, it will be removed as single-spa
     * doesn't handle trailing hash characters correctly.
     *
     * @returns The previous route path or undefined if not set
     */
    getPreviousRoute(): string | undefined;
}
export {};
