/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.importrdf;

import java.io.File;
import java.util.Properties;
import picocli.CommandLine;

public class PicoUtils {

    public static class PreloadDefaultProvider
    implements CommandLine.IDefaultValueProvider {
        private final Properties properties;

        public PreloadDefaultProvider() {
            int processors = Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
            String tasks = Integer.toString(Math.min(processors, 6));
            String queueFolder = new File(".").getAbsolutePath();
            this.properties = new Properties();
            this.properties.put("parsing-tasks", tasks);
            this.properties.put("queue-folder", queueFolder);
        }

        public String defaultValue(CommandLine.Model.ArgSpec argSpec) {
            return argSpec.isOption() ? this.optionDefaultValue((CommandLine.Model.OptionSpec)argSpec) : this.positionalDefaultValue((CommandLine.Model.PositionalParamSpec)argSpec);
        }

        private String optionDefaultValue(CommandLine.Model.OptionSpec option) {
            String result = this.getValue(option.descriptionKey(), option.command());
            result = result != null ? result : this.getValue(PreloadDefaultProvider.stripPrefix(option.longestName()), option.command());
            return result;
        }

        private static String stripPrefix(String prefixed) {
            for (int i = 0; i < prefixed.length(); ++i) {
                if (!Character.isJavaIdentifierPart(prefixed.charAt(i))) continue;
                return prefixed.substring(i);
            }
            return prefixed;
        }

        private String positionalDefaultValue(CommandLine.Model.PositionalParamSpec positional) {
            String result = this.getValue(positional.descriptionKey(), positional.command());
            result = result != null ? result : this.getValue(positional.paramLabel(), positional.command());
            return result;
        }

        private String getValue(String key, CommandLine.Model.CommandSpec spec) {
            String result = null;
            if (spec != null) {
                result = this.properties.getProperty(key);
            }
            return result != null ? result : this.properties.getProperty(key);
        }
    }

    static class ChunkConverter
    implements CommandLine.ITypeConverter<Integer> {
        ChunkConverter() {
        }

        public Integer convert(String value) {
            if ("auto".equalsIgnoreCase((String)value)) {
                return -1;
            }
            if (((String)value).endsWith("m") || ((String)value).endsWith("M")) {
                value = ((String)value).substring(0, ((String)value).length() - 1);
                value = (String)value + "000000";
            } else if (((String)value).endsWith("k") || ((String)value).endsWith("K")) {
                value = ((String)value).substring(0, ((String)value).length() - 1);
                value = (String)value + "000";
            }
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new CommandLine.TypeConversionException(String.format("Error converting chunk size to number for value: %s. Aborting...", value));
            }
        }
    }

    static class CacheConverter
    implements CommandLine.ITypeConverter<Integer> {
        CacheConverter() {
        }

        public Integer convert(String value) {
            if ("auto".equalsIgnoreCase(value)) {
                return -1;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new CommandLine.TypeConversionException(String.format("Error converting iterCache to number for value: %s. Aborting...", value));
            }
        }
    }
}

