/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.persistent;

import com.ontotext.platform.owl2soml.BaseDataAccess;
import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.Utils;
import com.ontotext.platform.owl2soml.persistent.ModelQueryDao;
import com.ontotext.platform.owl2soml.persistent.ModelQueryDaoCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rdf4jDataAccess
extends BaseDataAccess {
    private final ModelQueryDaoCache dao;
    private final ModelQueryDao queryDao;
    private Map<IRI, Map<IRI, OwlRestrictionsInfo>> restrictionsMapping;

    public Rdf4jDataAccess(ModelQueryDao queryDao) {
        this.dao = new ModelQueryDaoCache(queryDao);
        this.queryDao = queryDao;
    }

    @Override
    public void loadConfigurations() {
        super.loadConfigurations();
        this.dao.configure(this.getConfig(), this.namespaces);
    }

    @Override
    public Optional<Pair<Value, Value>> extractIriAndPrefixFromVann(IRI ontology, IRI storeContext) {
        return this.dao.extractIriAndPrefixFromVann(ontology, storeContext);
    }

    @Override
    public Optional<Value> extractIriAndPrefixFromSwc(IRI ontologyIri, IRI storedContext) {
        return this.dao.extractIriAndPrefixFromSwc(ontologyIri, storedContext);
    }

    @Override
    public Optional<String> extractBaseIri(IRI ontologyIri, IRI graphqlModelId, IRI storedContext) {
        return this.dao.extractBaseIri(ontologyIri, graphqlModelId, storedContext);
    }

    @Override
    public Optional<Pair<String, String>> getDefaultPrefix(IRI graphqlModelId, IRI ontologyId, IRI storedContext) {
        return this.dao.getDefaultPrefix(graphqlModelId, ontologyId, storedContext);
    }

    @Override
    public List<Pair<String, String>> getDeclaredPrefixes(List<IRI> models, IRI storedContext) {
        return this.dao.getDeclaredPrefixes(models, storedContext);
    }

    @Override
    public Optional<IRI> getDefinedBy(IRI graphqlModelId, IRI storedContext) {
        return this.dao.getDefinedBy(graphqlModelId, storedContext);
    }

    @Override
    public void configureWith(Ontology ontology) {
        this.dao.configureWith(ontology);
        this.readOntologyMetadata(ontology);
    }

    @Override
    public void readOntologyMetadata(Ontology ontology) {
        IRI storedContext = ontology.getStoredContext();
        if (storedContext == null) {
            storedContext = ontology.getOntologyId();
        }
        Objects.requireNonNull(storedContext, "Cannot read ontology metadata as ontology graph context or ontology ID are required!");
        List<IRI> ontologyIds = this.dao.getOntologies(storedContext);
        ontologyIds.sort(Comparator.comparing(IRI::toString));
        ontology.setOntologyIds(ontologyIds);
        List<IRI> graphqlModelIds = this.dao.getGraphQlModels(storedContext);
        graphqlModelIds.sort(Comparator.comparing(IRI::toString));
        ontology.setGraphqlModelIds(graphqlModelIds);
        IRI ontologyId = null;
        IRI graphqlModelId = null;
        if (ontologyIds.size() == 1) {
            ontologyId = ontologyIds.getFirst();
        }
        if (graphqlModelIds.size() == 1) {
            graphqlModelId = graphqlModelIds.getFirst();
        }
        if (graphqlModelId != null && ontologyIds.contains(graphqlModelId)) {
            ontologyId = graphqlModelId;
        }
        if (ontologyId != null) {
            ontology.setOntologyId(ontologyId);
        }
        if (graphqlModelId != null) {
            ontology.setGraphqlModelId(graphqlModelId);
        }
    }

    @Override
    public Map<String, Object> readOntologyMetadata(IRI ontologyIri) {
        return this.dao.readOntologyMetadata(ontologyIri);
    }

    @Override
    public void close() {
        if (this.restrictionsMapping != null) {
            this.restrictionsMapping.clear();
            this.restrictionsMapping = null;
        }
        this.dao.close();
    }

    @Override
    public Set<IRI> findAlternativeConfigurationsOf(@Nullable IRI modelId, Set<IRI> iris) {
        if (iris.isEmpty()) {
            return new HashSet<IRI>(0);
        }
        return this.dao.findAlternativeConfigurationsOf(modelId, iris).getAsDistinctIri();
    }

    @Override
    public boolean isConfigurationEnabled(@Nullable IRI modelId, IRI configPredicate) {
        return this.dao.isConfigurationEnabled(modelId, configPredicate);
    }

    @Override
    public Optional<Value> getConfiguration(@Nullable IRI modelId, IRI configPredicate) {
        return this.dao.getConfiguration(modelId, configPredicate);
    }

    @Override
    public Set<IRI> getCustomDataTypes() {
        return this.dao.getCustomDataTypes().getAsDistinctIri();
    }

    @Override
    public Optional<String> getGraphQlName(IRI graphqlModelId) {
        List results = this.dao.getGraphQlName(graphqlModelId).getResults();
        if (results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((Value)results.getFirst()).stringValue());
    }

    @Override
    public List<IRI> getPublicReferencedOntologies(IRI graphqlModelId) {
        return this.dao.getPublicReferencedOntologies(graphqlModelId).getAsIri();
    }

    @Override
    public List<IRI> getImportedOntologies(Set<IRI> primaryOntologies) {
        LinkedHashSet<IRI> all = new LinkedHashSet<IRI>(primaryOntologies);
        all.addAll(this.dao.getImportedOntologies(primaryOntologies).getAsIri());
        return new ArrayList<IRI>(all);
    }

    @Override
    public Stream<Namespace> getNamespaces(Ontology ontology) {
        List<Namespace> namespaces = this.dao.getNamespaces(ontology);
        Set ontologyNamespaces = namespaces.stream().map(Namespace::getPrefix).collect(Collectors.toSet());
        return Stream.concat(this.queryDao.getSystemNamespaces().filter(namespace -> !ontologyNamespaces.contains(namespace.getPrefix())), namespaces.stream()).distinct();
    }

    @Override
    public void loadGraphQlModel(IRI modelId, Ontology ontology) {
        GraphQlSchema schema = this.dao.loadGraphQlModel(modelId);
        ontology.setGraphQlSchema(schema);
    }

    @Override
    public Set<IRI> findAllExplicitClasses(GraphQlSchema graphQlSchema, Ontology ontology) {
        Set classesIris = this.dao.findAllExplicitClasses().getAsDistinctIri().stream().sorted(Utils.iriComparator()).collect(Collectors.toCollection(LinkedHashSet::new));
        classesIris.removeIf(iri -> !this.getConfig().isValidClass((Value)iri));
        classesIris.removeAll(this.getConfig().getIgnoredTypes());
        classesIris.removeAll(this.getConfig().getIgnoredClasses());
        classesIris.removeAll(this.getConfig().getCustomDataTypes());
        classesIris.removeIf(this.getDeactivatedShapes()::contains);
        classesIris.removeIf(Utils::isDatatype);
        return classesIris;
    }

    @Override
    public boolean isDeactivated(Resource resource) {
        return this.getConfig().canIncludeDeactivatedShapes() || this.dao.isDeactivated(resource);
    }

    @Override
    public Set<IRI> getDeactivatedShapes() {
        if (this.getConfig().canIncludeDeactivatedShapes()) {
            return Set.of();
        }
        return this.dao.getDeactivatedShapes().stream().filter(IRI.class::isInstance).map(IRI.class::cast).collect(Collectors.toSet());
    }

    @Override
    public Stream<IRI> findReferencedShaclNodes(Set<IRI> iris) {
        return this.dao.findReferencedShaclNodes(iris).getAsIri().stream();
    }

    @Override
    public Stream<IRI> findReferencedShaclTypes(Set<IRI> iris) {
        return this.dao.findReferencedShaclTypes(iris).getAsIri().stream();
    }

    @Override
    public void readClassMetadata(Classes.Class target, Ontology ontology) {
        target.setGqlName(this.gqlTypeName((Resource)target.getIri()));
        this.dao.readClassMetadata((Resource)target.getIri(), target, ontology);
        target.sortParents();
    }

    @Override
    public void readAnonymousClassMetadata(Classes.AnonymousClass target, Ontology ontology) {
        target.setGqlName(this.gqlTypeName(target.getIdentifier()));
        this.dao.readClassMetadata(target.getIdentifier(), target, ontology);
        target.sortParents();
    }

    @Override
    public Optional<Boolean> isInterfaceType(Resource iri) {
        return this.dao.isInterfaceType(iri);
    }

    @Override
    public Optional<String> getLabel(Resource iri) {
        List<String> labels = this.dao.getLabel(iri).stream().map(Value::stringValue).filter(StringUtils::isNotBlank).distinct().sorted().toList();
        if (labels.isEmpty()) {
            return Optional.empty();
        }
        if (labels.size() > 1) {
            this.messages.add(Message.warning("label.ambiguous", this.namespaces.gqlName(iri.stringValue()), labels, labels.getFirst()));
        }
        return Optional.of(labels.getFirst());
    }

    @Override
    public Optional<String> getDescription(Resource iri) {
        List<Literal> labels = this.dao.getDescription(iri);
        if (labels.isEmpty()) {
            return Optional.empty();
        }
        String description = labels.stream().map(Value::stringValue).map(Utils.removeTrailingDots()).filter(StringUtils::isNotBlank).distinct().sorted().collect(Collectors.joining(". "));
        if (StringUtils.isNotBlank((CharSequence)description)) {
            return Optional.of(description);
        }
        return Optional.empty();
    }

    @Override
    public String gqlTypeName(Resource resource) {
        List<Literal> names = this.dao.gqlTypeName(resource);
        if (names.isEmpty()) {
            Set<IRI> targets;
            IRI iri;
            if (resource instanceof BNode) {
                throw new IllegalArgumentException("BNode cannot be used for GraphQL name: " + String.valueOf(resource));
            }
            if (resource instanceof IRI && this.dao.isShape(iri = (IRI)resource) && !(targets = this.dao.getTargetsForShape(iri)).isEmpty()) {
                IRI target = (IRI)targets.stream().min(Utils.iriComparator()).orElseThrow();
                return this.namespaces.modelSafeType(this.namespaces.gqlName(target.stringValue()), resource);
            }
            return this.namespaces.modelSafeType(this.namespaces.gqlName(resource.stringValue()), resource);
        }
        return this.namespaces.modelSafeType(this.namespaces.gqlName(names.getFirst().stringValue()), resource);
    }

    @Override
    public String gqlPropertyName(Resource iri) {
        List<Literal> names = this.dao.gqlPropertyName(iri);
        if (names.isEmpty()) {
            if (iri instanceof BNode) {
                return null;
            }
            return this.namespaces.modelSafeProperty(this.namespaces.gqlName(iri.stringValue()), iri);
        }
        return this.namespaces.modelSafeProperty(this.namespaces.gqlName(names.getFirst().stringValue()), iri);
    }

    @Override
    public Optional<IRI> getInverseOf(Resource resource) {
        Set<Value> list = this.dao.getInverseOf(resource);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        Value value = list.iterator().next();
        if (value instanceof IRI) {
            IRI iri = (IRI)value;
            return Optional.of(iri);
        }
        return Optional.empty();
    }

    @Override
    public List<PropertyInverseInfo> getPropertyInverseInfos(Resource resource) {
        return this.dao.getPropertyInverseInfo(resource);
    }

    @Override
    public Set<Resource> findAllExplicitProperties() {
        return (Set)this.dao.findAllExplicitProperties().getResultsAs(Resource.class, LinkedHashSet::new);
    }

    @Override
    public Map<String, Map<String, Role>> findRbacRoles(IRI ontologyId) {
        return this.dao.findRbacRoles(ontologyId);
    }

    @Override
    public void readPropertyName(Properties.Property property) {
        Resource resource = property.getIri();
        boolean isShaclProp = property.getShaclIri() != null || resource instanceof BNode || this.dao.isShaclProperty(property.getIri());
        property.setShaclProperty(isShaclProp);
        if (property.getName() == null && isShaclProp && resource instanceof IRI) {
            this.dao.resolveShaclPropertyDomain(resource).stream().filter(Value::isIRI).map(IRI.class::cast).map(domain -> this.namespaces.convertShaclPropertyName(resource, (Resource)domain)).filter(Objects::nonNull).findFirst().ifPresent(property::setName);
        }
        if (property.getName() == null && isShaclProp) {
            this.dao.readShaclPropertyPath(property, resource);
            if (!property.isComplexPath() && property.getRdfPropIri() != null) {
                property.setName(this.gqlPropertyName((Resource)property.getRdfPropIri()));
            }
        }
        if (property.getName() == null) {
            property.setName(this.gqlPropertyName(resource));
        }
        if (property.getShaclIri() == null) {
            property.setShaclIri((Resource)(isShaclProp ? resource : null));
        }
    }

    @Override
    public void readPropertyMetadata(Properties.Property property, Ontology ontology) {
        this.readPropertyName(property);
        Resource resource = property.getIri();
        property.setShaclProperty(property.getShaclIri() != null || resource instanceof BNode || this.dao.isShaclProperty(resource));
        if (property.isShaclProperty()) {
            this.readShaclPropertyMetadata(property, Objects.requireNonNullElse(property.getShaclIri(), resource), ontology);
        } else if (resource instanceof IRI) {
            IRI iri = (IRI)resource;
            property.setRdfProp(property.getShortIri());
            property.setRdfPropIri(iri);
            this.getLabel(Objects.requireNonNullElse(property.getShaclIri(), resource)).ifPresent(property::setLabel);
            this.getDescription(Objects.requireNonNullElse(property.getShaclIri(), resource)).ifPresent(property::setDescription);
        }
        if (property.getMax() == null) {
            Resource id = Objects.requireNonNullElse(property.getRdfPropIri(), resource);
            boolean isMultiValued = this.dao.isMultiValuedProperty(id);
            if (!Objects.equals(id, resource)) {
                isMultiValued &= this.dao.isMultiValuedProperty(resource);
            }
            if (isMultiValued) {
                property.setMax(this.config.getDefaultMaxCardinality());
            }
        }
        if (this.dao.isSymmetricProperty(resource)) {
            property.setSymmetric();
        }
    }

    @Override
    public void readShaclPropertyMetadata(Properties.Property property, Resource shaclId, Ontology ontology) {
        property.setShaclIri(Objects.requireNonNullElse(property.getShaclIri(), shaclId));
        property.setShaclProperty(true);
        this.dao.readShaclPropertyPath(property, shaclId);
        this.dao.gqlPropertyName(shaclId).stream().map(Value::stringValue).map(this.namespaces::modelSafeProperty).findFirst().or(() -> this.resolveShaclPropertyDomain(shaclId, ontology).map(domainIri -> this.tryFixShaclPropertyName(shaclId, (IRI)domainIri)).filter(Objects::nonNull).findFirst()).ifPresent(property::setName);
        ModelQueryDao.LangConfig langConfig = new ModelQueryDao.LangConfig();
        ModelQueryDao.PropTypeConfig typeConfig = new ModelQueryDao.PropTypeConfig();
        this.dao.readShaclPropertyMetadata(property, shaclId, ontology, typeConfig, langConfig);
        this.processPropertyTypeConfig(property, typeConfig);
        property.setLang(langConfig.asSomlLangConfig());
        if (this.getConfig().canReadShaclPropertyLabels()) {
            this.getLabel(shaclId).ifPresent(property::setLabel);
            this.getDescription(shaclId).ifPresent(property::setDescription);
        }
    }

    private String tryFixShaclPropertyName(Resource propResource, IRI domainIri) {
        if (!(propResource instanceof IRI)) {
            return null;
        }
        String propIriString = propResource.stringValue();
        String replace = propIriString.replace(domainIri.stringValue(), "");
        if (replace.isEmpty() || replace.length() == propIriString.length()) {
            String domainLocalName;
            String propLocalName = ((IRI)propResource).getLocalName();
            if (propLocalName.startsWith(domainLocalName = domainIri.getLocalName()) && propLocalName.length() > domainLocalName.length()) {
                replace = propLocalName.replaceFirst("^" + Pattern.quote(domainLocalName), "");
                if (replace.isEmpty() || replace.length() == propLocalName.length()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (!Character.isAlphabetic(replace.charAt(0))) {
            replace = replace.substring(1);
        }
        replace = this.namespaces.modelSafeProperty(replace);
        return replace;
    }

    private void processPropertyTypeConfig(Properties.Property property, ModelQueryDao.PropTypeConfig typeConfig) {
        if (typeConfig.isUnionDefinition() && typeConfig.orDef.getNodes().isEmpty() && typeConfig.orDef.getClasses().isEmpty() && typeConfig.orDef.getDataTypes().stream().allMatch(Utils::isDatatype)) {
            property.setRange(this.namespaces.getScalars().getOrCreateDataTypeUnion(typeConfig.orDef.getDataTypes().stream().map(IRI.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))));
            property.setKind("literal");
            return;
        }
        if (typeConfig.isMultiInheritanceDef()) {
            property.getAndDef().copyFrom(typeConfig.andDef);
            property.setKind("object");
        }
        if (typeConfig.isUnionDefinition() && this.config.canUseUnions()) {
            property.getOrDef().copyFrom(typeConfig.orDef);
            property.setKind("object");
            return;
        }
        if (property.getKind() == null) {
            LinkedHashSet foundTypes = new LinkedHashSet();
            typeConfig.getDatatype().ifPresent(type -> {
                foundTypes.add(type);
                property.setRange(Utils.getDataTypeForIri(type), (IRI)type);
                property.setKind(Utils.isIriBasedType(type) ? "object" : "literal");
            });
            typeConfig.getClazz().ifPresent(type -> {
                foundTypes.add(type);
                property.setRangeClass((IRI)type);
                property.setRange(this.gqlTypeName((Resource)type), (IRI)type);
                property.setKind("object");
            });
            typeConfig.getNode().ifPresent(type -> {
                foundTypes.add(type);
                property.setNodeRange((Resource)type);
                property.setKind("object");
            });
            if (foundTypes.size() > 1) {
                this.messages.add(Message.warning("property.range.ambiguous", property.getShortIri(), foundTypes, property.getRange()));
            }
        }
    }

    @Override
    public boolean isDataProperty(Resource iri) {
        return this.dao.isDataProperty(iri);
    }

    @Override
    public boolean isObjectProperty(Resource iri) {
        return this.dao.isObjectProperty(iri);
    }

    @Override
    public List<Value> findRangeClasses(Resource propIri) {
        return this.dao.findRangeClasses(propIri).stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<Value> findDomainClasses(Resource propIri, Ontology ontology) {
        return this.dao.findDomainClasses(propIri).stream().filter(ontology::isTypeAllowed).toList();
    }

    @Override
    public Stream<IRI> resolveShaclPropertyDomain(Resource propIri, Ontology ontology) {
        List<IRI> domains = this.dao.resolveShaclPropertyDomain(propIri).stream().filter(IRI.class::isInstance).map(IRI.class::cast).toList();
        List<IRI> notAllowed = domains.stream().filter(domain -> !ontology.isTypeAllowed((Value)domain)).toList();
        if (notAllowed.isEmpty()) {
            return domains.stream().filter(ontology::isTypeAllowed);
        }
        return Stream.concat(domains.stream().filter(ontology::isTypeAllowed), this.dao.getSubClasses(notAllowed).stream().filter(ontology::isTypeAllowed)).distinct();
    }

    @Override
    public List<OwlRestrictionsInfo> getOwlRestrictions(IRI classIri) {
        Map<IRI, Map<IRI, OwlRestrictionsInfo>> propertyToRestriction = this.collectOwlRestrictions();
        return new ArrayList<OwlRestrictionsInfo>(propertyToRestriction.getOrDefault(classIri, Map.of()).values());
    }

    @NotNull
    private Map<IRI, Map<IRI, OwlRestrictionsInfo>> collectOwlRestrictions() {
        if (this.restrictionsMapping != null) {
            return this.restrictionsMapping;
        }
        this.restrictionsMapping = this.dao.getOwlRestrictions();
        return this.restrictionsMapping;
    }

    @Override
    public Map<IRI, Set<IRI>> getTargetClassToShapes(Collection<IRI> iris) {
        return this.dao.getTargetClassToShapes(iris);
    }

    @Override
    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes() {
        return this.dao.getGraphQlSchemaShapes();
    }

    @Override
    public List<PrefixNamespaceResponse> getPossiblePrefixes(String repositoryId) {
        return this.dao.getPossiblePrefixes(repositoryId);
    }

    @Override
    public boolean isContext(IRI iri) {
        return this.dao.isContext(iri);
    }

    @Override
    public boolean isOntology(IRI iri) {
        return this.dao.isOntology(iri);
    }

    @Override
    public Optional<Value> readOntologyId(IRI modelId) {
        return this.dao.readOntologyId(modelId);
    }
}

