/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.persistent;

import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.Config;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.MultiTypeDef;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.Utils;
import com.ontotext.sparql.SinglePropertyResultHandler;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ModelQueryDao
extends Closeable {
    @NotNull
    public static String outputResource(Resource resource) {
        if (resource instanceof IRI) {
            return "<" + String.valueOf(resource) + ">";
        }
        if (resource instanceof BNode) {
            return resource.toString();
        }
        if (resource instanceof Triple) {
            return resource.stringValue();
        }
        throw new IllegalArgumentException("Unsupported resource format " + String.valueOf(resource));
    }

    public Map<String, Map<String, Role>> findRbacRoles(IRI var1);

    public Map<String, Map<IRI, Value>> findGenerationConfigs();

    public void updateStatistics(String var1);

    public void configure(Config var1, Namespaces var2);

    public void configureWith(Ontology var1);

    public SinglePropertyResultHandler findAlternativeConfigurationsOf(@Nullable IRI var1, Set<IRI> var2);

    public boolean isConfigurationEnabled(@Nullable IRI var1, IRI var2);

    public SinglePropertyResultHandler getCustomDataTypes();

    public SinglePropertyResultHandler getGraphQlName(IRI var1);

    public SinglePropertyResultHandler getPublicReferencedOntologies(IRI var1);

    public SinglePropertyResultHandler getImportedOntologies(Set<IRI> var1);

    public Stream<Namespace> getSystemNamespaces();

    public List<Namespace> getNamespaces(Ontology var1);

    public GraphQlSchema loadGraphQlModel(IRI var1);

    public SinglePropertyResultHandler findAllExplicitClasses();

    public Set<Resource> getDeactivatedShapes();

    public SinglePropertyResultHandler findReferencedShaclNodes(Set<IRI> var1);

    public SinglePropertyResultHandler findReferencedShaclTypes(Set<IRI> var1);

    public Map<Value, List<BindingSet>> getClassMetadata();

    public List<BindingSet> getClassMetadata(Resource var1);

    public Consumer<BindingSet> populateTypeMetadata(Classes.Class var1, Ontology var2);

    public Map<Value, Boolean> getInterfaceTypes();

    public Map<Value, List<Value>> getLabels();

    public Map<Value, Set<Value>> getDescriptions();

    public Map<Value, List<Value>> gqlTypeNames();

    public Map<Value, Set<Value>> gqlPropertyNames();

    public Map<Value, Set<Value>> getInverseOf();

    public SinglePropertyResultHandler getExplicitProperties();

    public Set<Resource> getShaclProperties();

    public Set<Value> getTypes(Resource var1);

    public Map<Value, Set<Value>> getPropertyTypes();

    public Map<Value, List<BindingSet>> readShaclPropertiesMetadata();

    public void readShaclPropertyPath(Properties.Property var1, Resource var2, Value var3);

    public List<PropertyInverseInfo> readShaclInverseRelations();

    public Map<Value, Value> getShaclPropertyPaths();

    public Consumer<BindingSet> populatePropertyShaclMetadata(Properties.Property var1, Ontology var2, LangConfig var3, PropTypeConfig var4);

    public Map<String, Object> readOntologyMetadata(IRI var1);

    public Set<Resource> getDataProperties();

    public Set<Resource> getObjectProperties();

    public Map<Value, List<Value>> findRangeClasses();

    public Map<Value, List<Value>> findDomainClasses();

    public Map<Value, List<Value>> resolveShaclPropertyDomains();

    public Map<Value, List<Value>> getSubClasses();

    @NotNull
    public Map<IRI, Map<IRI, OwlRestrictionsInfo>> getOwlRestrictions();

    public Map<IRI, Set<IRI>> getTargetClassToShapes(Collection<IRI> var1);

    public List<IRI> getOntologies(IRI var1);

    public List<IRI> getGraphQlModels(IRI var1);

    public Optional<Pair<Value, Value>> extractIriAndPrefixFromVann(IRI var1, IRI var2);

    public Optional<Value> extractIriAndPrefixFromSwc(IRI var1, IRI var2);

    public Optional<String> extractBaseIri(IRI var1, IRI var2, IRI var3);

    public Optional<Pair<String, String>> getDefaultPrefix(IRI var1, IRI var2, IRI var3);

    public List<Pair<String, String>> getDeclaredPrefixes(List<IRI> var1, IRI var2);

    public Optional<IRI> getDefinedBy(IRI var1, IRI var2);

    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes();

    public List<PrefixNamespaceResponse> getPossiblePrefixes(String var1);

    @Override
    public void close();

    public boolean isContext(IRI var1);

    public boolean isOntology(IRI var1);

    public Optional<Value> getConfiguration(IRI var1, IRI var2);

    public Optional<Value> readOntologyId(IRI var1);

    public static class OntologyMetadata {
        List<Literal> labels = new LinkedList<Literal>();
        List<Literal> creators = new LinkedList<Literal>();
        List<Literal> versions = new LinkedList<Literal>();
        List<Literal> created = new LinkedList<Literal>();
        List<Literal> updated = new LinkedList<Literal>();

        public void addLabel(Literal label) {
            this.labels.add(label);
        }

        public void addCreator(Literal creator) {
            this.creators.add(creator);
        }

        public void addVersion(Literal version) {
            this.versions.add(version);
        }

        public void addCreated(Literal created) {
            this.created.add(created);
        }

        public void addUpdated(Literal updated) {
            this.updated.add(updated);
        }

        Map<String, Object> formatMetadata() {
            String creator;
            LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
            String label = this.labels.stream().map(Value::stringValue).map(Utils.removeTrailingDots()).filter(StringUtils::isNotBlank).distinct().sorted().collect(Collectors.joining(". "));
            if (!label.isEmpty()) {
                metadata.put("label", label);
            }
            if (!(creator = this.creators.stream().map(Value::stringValue).map(Utils.removeTrailingDots()).filter(StringUtils::isNotBlank).distinct().sorted().collect(Collectors.joining(", "))).isEmpty()) {
                metadata.put("creator", creator);
            }
            this.versions.stream().map(Utils::formatVersion).findFirst().ifPresent(version -> metadata.put("versionInfo", version));
            this.created.stream().map(Utils::toLocalDateString).findFirst().ifPresent(value -> metadata.put("created", value));
            this.updated.stream().map(Utils::toLocalDateString).findFirst().ifPresent(value -> metadata.put("updated", value));
            return metadata;
        }

        public Consumer<BindingSet> createHandler() {
            return bindings -> {
                Utils.readLiteralValue("label", bindings, this::addLabel);
                Utils.readLiteralValue("creator", bindings, this::addCreator);
                Utils.readLiteralValue("version", bindings, this::addVersion);
                Utils.readLiteralValue("created", bindings, this::addCreated);
                Utils.readLiteralValue("updated", bindings, this::addUpdated);
            };
        }
    }

    public static class PropTypeConfig {
        MultiTypeDef orDef = new MultiTypeDef();
        MultiTypeDef andDef = new MultiTypeDef();
        IRI datatype;
        IRI clazz;
        Resource node;

        boolean isUnionDefinition() {
            return this.orDef.isValid();
        }

        boolean isMultiInheritanceDef() {
            return this.andDef.isValid() && this.andDef.getDataTypes() == null;
        }

        public Optional<IRI> getDatatype() {
            return Optional.ofNullable(this.datatype);
        }

        public Optional<IRI> getClazz() {
            return Optional.ofNullable(this.clazz);
        }

        public Optional<Resource> getNode() {
            return Optional.ofNullable(this.node);
        }

        public void setDatatype(IRI datatype) {
            this.datatype = datatype;
        }

        public void setClazz(IRI clazz) {
            this.clazz = clazz;
        }

        public void setNode(Resource node) {
            this.node = node;
        }
    }

    public static class LangConfig {
        List<String> languages = new LinkedList<String>();
        boolean unique;
        String fetch;

        public void addLanguage(String lang) {
            this.languages.add(lang);
        }

        public void setUnique(boolean unique) {
            this.unique = unique;
        }

        public void setFetch(String fetch) {
            this.fetch = fetch;
        }

        Object asSomlLangConfig() {
            LinkedHashMap<String, String> langConfig = new LinkedHashMap<String, String>();
            if (this.fetch != null) {
                langConfig.put("fetch", this.fetch);
            }
            if (this.unique) {
                this.languages.add("UNIQ");
            }
            if (!this.languages.isEmpty()) {
                langConfig.put("validate", String.join((CharSequence)",", this.languages));
            }
            if (langConfig.isEmpty()) {
                return null;
            }
            if (langConfig.size() == 1 && langConfig.containsKey("fetch")) {
                return this.fetch;
            }
            return langConfig;
        }
    }
}

