/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.memory;

import com.ontotext.platform.owl2soml.BaseDataAccess;
import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.Constants;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.MultiTypeDef;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.SomlOntology;
import com.ontotext.platform.owl2soml.Utils;
import com.ontotext.platform.owl2soml.memory.Data;
import com.ontotext.platform.owl2soml.memory.InMemoryOntology;
import com.ontotext.platform.owl2soml.memory.InMemoryShaclPathResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.EmptyModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.VANN;
import org.eclipse.rdf4j.model.vocabulary.VOID;
import org.jetbrains.annotations.Nullable;

public class InMemoryModelDataAccess
extends BaseDataAccess {
    private static final Data EMPTY_MODEL = new Data((Model)new EmptyModel((Model)new LinkedHashModel()));
    private final Data data;
    private Map<IRI, Data> modelMap = new LinkedHashMap<IRI, Data>();

    public InMemoryModelDataAccess() {
        this.data = new Data((Model)new LinkedHashModel());
    }

    @Override
    public void configureWith(Ontology ontology) {
        if (ontology instanceof InMemoryOntology) {
            InMemoryOntology memoryOntology = (InMemoryOntology)ontology;
            IRI context = vf.createIRI("http://example.com/", UUID.randomUUID().toString());
            this.modelMap.put(context, new Data(memoryOntology.getModel()));
            ontology.setStoredContext(context);
            this.data.addAll(memoryOntology.getModel());
            memoryOntology.detectOntologyDefinition();
        }
    }

    @Override
    public void readOntologyMetadata(Ontology ontology) {
        if (ontology instanceof InMemoryOntology) {
            InMemoryOntology memoryOntology = (InMemoryOntology)ontology;
            memoryOntology.detectOntologyDefinition();
        }
    }

    @Override
    public Map<String, Object> readOntologyMetadata(IRI ontologyIri) {
        LinkedHashMap<String, Object> soml = new LinkedHashMap<String, Object>();
        this.addJoinedPropToMap(soml, (Resource)ontologyIri, "label", this.getConfig().getLabelProps(), ". ", new Predicate[0]);
        this.addJoinedPropToMap(soml, (Resource)ontologyIri, "creator", this.getConfig().getCreator(), ", ", new Predicate[0]);
        this.data.getFirstStatement((Resource)ontologyIri, this.getConfig().getVersion()).ifPresent(statement -> soml.put("versionInfo", Utils.formatVersion(statement.getObject())));
        this.data.getFirstStatement((Resource)ontologyIri, this.getConfig().getCreated()).ifPresent(statement -> soml.put("created", Utils.toLocalDateString(statement.getObject())));
        this.data.getFirstStatement((Resource)ontologyIri, this.getConfig().getModified()).ifPresent(statement -> soml.put("updated", Utils.toLocalDateString(statement.getObject())));
        return soml;
    }

    @Override
    public Optional<Pair<Value, Value>> extractIriAndPrefixFromVann(IRI ontologyIri, IRI storeContext) {
        Optional<Value> uri = this.data.getFirstObject((Resource)ontologyIri, VANN.PREFERRED_NAMESPACE_URI);
        if (uri.isEmpty()) {
            return Optional.empty();
        }
        Optional<Value> pfx = this.data.getFirstObject((Resource)ontologyIri, VANN.PREFERRED_NAMESPACE_PREFIX);
        return pfx.map(value -> Pair.of((Object)value, (Object)((Value)uri.get())));
    }

    @Override
    public Set<IRI> findAlternativeConfigurationsOf(@Nullable IRI modelId, Set<IRI> iris) {
        LinkedHashSet<IRI> alternatives = new LinkedHashSet<IRI>();
        for (IRI iri : iris) {
            if (modelId == null || this.data.hasStatement((Resource)iri, RDFS.ISDEFINEDBY, (Value)modelId)) {
                this.data.streamStatements((Resource)iri, OWL.SAMEAS, null).filter(Utils.objectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getObject()));
                this.data.streamStatements(null, OWL.SAMEAS, (Value)iri).filter(Utils.subjectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getSubject()));
                this.data.streamStatements((Resource)iri, SomlOntology.SAME_AS, null).filter(Utils.objectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getObject()));
                this.data.streamStatements(null, SomlOntology.SAME_AS, (Value)iri).filter(Utils.subjectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getSubject()));
                continue;
            }
            this.data.streamStatements((Resource)iri, OWL.SAMEAS, null, new Resource[]{modelId}).filter(Utils.objectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getObject()));
            this.data.streamStatements(null, OWL.SAMEAS, (Value)iri, new Resource[]{modelId}).filter(Utils.subjectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getSubject()));
            this.data.streamStatements((Resource)iri, SomlOntology.SAME_AS, null, new Resource[]{modelId}).filter(Utils.objectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getObject()));
            this.data.streamStatements(null, SomlOntology.SAME_AS, (Value)iri, new Resource[]{modelId}).filter(Utils.subjectsAreIris()).forEach(statement -> alternatives.add((IRI)statement.getSubject()));
        }
        return alternatives;
    }

    @Override
    public boolean isConfigurationEnabled(@Nullable IRI modelId, IRI configPredicate) {
        return this.data.hasStatement((Resource)modelId, configPredicate, (Value)TRUE);
    }

    @Override
    public Optional<Value> getConfiguration(@Nullable IRI modelId, IRI configPredicate) {
        if (Objects.isNull(modelId)) {
            return this.data.streamStatements(null, configPredicate, null).filter(statement -> statement.getSubject() instanceof BNode).findFirst().map(Statement::getObject);
        }
        return this.data.getFirstObject((Resource)modelId, configPredicate);
    }

    @Override
    public Set<IRI> getCustomDataTypes() {
        Set<IRI> dataTypes = this.data.streamStatements(null, RDF.TYPE, (Value)Constants.SCHEMA_DATA_TYPE).filter(Utils.subjectsAreIris()).map(statement -> (IRI)statement.getSubject()).collect(Collectors.toSet());
        this.data.streamStatements(null, RDFS.SUBCLASSOF, null).filter(Utils.subjectsAreIris().and(Utils.objectsAreIris())).filter(statement -> this.data.hasStatement((Resource)((IRI)statement.getObject()), RDF.TYPE, (Value)Constants.SCHEMA_DATA_TYPE)).map(statement -> (IRI)statement.getSubject()).forEach(dataTypes::add);
        return dataTypes;
    }

    @Override
    public Optional<String> getGraphQlName(IRI iri) {
        return this.getConfig().getNames().stream().flatMap(predicate -> this.data.streamStatements((Resource)iri, (IRI)predicate, null).map(Statement::getObject).map(Value::stringValue)).findFirst();
    }

    @Override
    public List<IRI> getPublicReferencedOntologies(IRI graphqlModelId) {
        return Stream.concat(this.data.streamStatements((Resource)graphqlModelId, Constants.GRAPHQL_PUBLIC_CLASS, null), this.data.streamStatements((Resource)graphqlModelId, Constants.GRAPHQL_PUBLIC_SHAPE, null)).flatMap(Utils.objectAsIri()).flatMap(shape -> this.data.streamStatements((Resource)shape, RDFS.ISDEFINEDBY, null)).flatMap(Utils.objectAsIri()).distinct().toList();
    }

    @Override
    public List<IRI> getImportedOntologies(Set<IRI> primaryOntologies) {
        LinkedHashSet visited = new LinkedHashSet();
        return primaryOntologies.stream().flatMap(iri -> Stream.concat(Stream.of(iri), this.getImports((IRI)iri, visited))).distinct().toList();
    }

    private Stream<IRI> getImports(IRI id, Set<IRI> visited) {
        return this.data.streamStatements((Resource)id, OWL.IMPORTS, null).flatMap(Utils.objectAsIri()).filter(iri -> this.data.hasStatement((Resource)iri, RDF.TYPE, (Value)OWL.ONTOLOGY)).filter(iri -> !visited.contains(iri)).peek(visited::add).flatMap(iri -> Stream.concat(Stream.of(iri), this.getImports((IRI)iri, visited)));
    }

    @Override
    public Stream<Namespace> getNamespaces(Ontology ontology) {
        Stream<Object> ontologyNamespaces = Stream.empty();
        if (ontology instanceof InMemoryOntology) {
            InMemoryOntology memoryOntology = (InMemoryOntology)ontology;
            ontologyNamespaces = memoryOntology.getModel().getNamespaces().stream();
        }
        return Stream.concat(Stream.concat(Stream.of(ontology.getGraphqlModelId(), ontology.getOntologyId()), ontology.getOntologyImports().stream()).filter(Objects::nonNull).distinct().flatMap(iri -> this.data.streamStatements((Resource)iri, SHACL.DECLARE, null)).map(Statement::getObject).map(Resource.class::cast).map(declareId -> InMemoryModelDataAccess.readDeclaredPrefixDefinition(declareId, this.data, SimpleNamespace::new)).filter(Objects::nonNull), ontologyNamespaces).distinct();
    }

    private Set<IRI> getOntologyPrivateProperties(IRI modelId) {
        return this.getConfig().getPrivatePropertiesConfig().stream().flatMap(privateProp -> this.data.streamStatements((Resource)modelId, (IRI)privateProp, null).flatMap(Utils.objectAsIri())).collect(Collectors.toSet());
    }

    private Set<IRI> getOntologyProtectedProperties(IRI modelId) {
        return this.getConfig().getProtectedPropertiesConfig().stream().flatMap(protectedProp -> this.data.streamStatements((Resource)modelId, (IRI)protectedProp, null).flatMap(Utils.objectAsIri())).collect(Collectors.toSet());
    }

    @Override
    public void loadGraphQlModel(IRI modelId, Ontology ontology) {
        GraphQlSchema graphQlSchema = new GraphQlSchema();
        this.data.streamStatements((Resource)modelId, Constants.GRAPHQL_PUBLIC_CLASS, null).filter(Utils.objectsAreIris()).forEach(statement -> graphQlSchema.getPublicClasses().add((IRI)statement.getObject()));
        this.data.streamStatements((Resource)modelId, Constants.GRAPHQL_PUBLIC_SHAPE, null).filter(Utils.objectsAreIris()).forEach(statement -> graphQlSchema.getPublicShapes().add((IRI)statement.getObject()));
        this.data.streamStatements((Resource)modelId, Constants.GRAPHQL_PROTECTED_CLASS, null).filter(Utils.objectsAreIris()).forEach(statement -> graphQlSchema.getProtectedClasses().add((IRI)statement.getObject()));
        this.data.streamStatements((Resource)modelId, Constants.GRAPHQL_PROTECTED_SHAPE, null).filter(Utils.objectsAreIris()).forEach(statement -> graphQlSchema.getProtectedShapes().add((IRI)statement.getObject()));
        this.data.streamStatements((Resource)modelId, Constants.GRAPHQL_PRIVATE_SHAPE, null).filter(Utils.objectsAreIris()).forEach(statement -> graphQlSchema.getPrivateShapes().add((IRI)statement.getObject()));
        this.getOntologyPrivateProperties(modelId).forEach(graphQlSchema.getPrivateProperties()::add);
        this.getOntologyProtectedProperties(modelId).forEach(graphQlSchema.getProtectedProperties()::add);
        ontology.setGraphQlSchema(graphQlSchema);
        Ontology allowAllOntology = ontology.createAllowAllOntology();
        this.expandWithReferencedObjectsFromUpperHierarchy(allowAllOntology, new LinkedHashSet<IRI>(graphQlSchema.getPublicShapes()), graphQlSchema.getProtectedShapes());
        this.expandHierarchyDown(graphQlSchema.getPublicClasses(), graphQlSchema.getPublicShapes());
        this.expandWithReferencedObjectsFromUpperHierarchy(allowAllOntology, new LinkedHashSet<IRI>(graphQlSchema.getProtectedShapes()), graphQlSchema.getProtectedShapes());
        this.expandHierarchyDown(graphQlSchema.getProtectedClasses(), graphQlSchema.getProtectedShapes());
    }

    private void expandHierarchyDown(Set<IRI> toExpand, Set<IRI> expandTo) {
        for (IRI classIri : toExpand) {
            this.data.getSubClasses(classIri).forEach(expandTo::add);
        }
    }

    private void expandHierarchyUp(Set<IRI> classesIris, Set<IRI> toExpand, Set<IRI> expandTo) {
        for (IRI classIri : toExpand) {
            this.data.getSuperClasses(classIri).filter(iri -> this.data.hasStatement((Resource)iri, SHACL.PROPERTY, new Value[0])).forEach(subType -> {
                classesIris.add((IRI)subType);
                expandTo.add((IRI)subType);
            });
        }
    }

    private void expandWithReferencedObjectsFromUpperHierarchy(Ontology ontology, Set<IRI> toExpand, Set<IRI> expandTo) {
        Properties properties = new Properties(ontology, this.namespaces, this, this.messages);
        Stream.concat(toExpand.stream(), toExpand.stream().flatMap(this.data::getSuperClasses)).flatMap(iri -> this.data.streamStatements((Resource)iri, SHACL.PROPERTY, null).flatMap(Utils.objectAsIri()).map(properties::getOrCreateProp).filter(property -> !property.isExcluded()).filter(property -> {
            if (property.isPrivate()) {
                property.setHidden();
                return false;
            }
            if (property.isProtected()) {
                property.setAsProtected();
                return false;
            }
            return true;
        }).flatMap(prop -> Stream.concat(Optional.ofNullable(prop.getRangeClass()).stream(), prop.getOrDef().getClasses().stream()))).forEach(expandTo::add);
    }

    @Override
    public Set<IRI> findAllExplicitClasses(GraphQlSchema graphQlSchema, Ontology ontology) {
        LinkedHashSet<IRI> classesIris = new LinkedHashSet<IRI>();
        this.data.getAllStatementsForMultipleObjects(null, RDF.TYPE, this.getConfig().getClasses(), this.getConfig().subjectsAreValidClasses(), this.isNotPrivateClass(graphQlSchema)).stream().map(statement -> (IRI)statement.getSubject()).sorted(Utils.iriComparator()).forEach(classesIris::add);
        this.findDomainClasses(null, ontology).stream().filter(IRI.class::isInstance).map(IRI.class::cast).forEach(classesIris::add);
        this.findRangeClasses(null).stream().filter(IRI.class::isInstance).map(IRI.class::cast).forEach(classesIris::add);
        classesIris.removeAll(this.getConfig().getIgnoredClasses());
        classesIris.removeAll(this.getConfig().getCustomDataTypes());
        classesIris.removeIf(this.getDeactivatedShapes()::contains);
        classesIris.removeIf(Utils::isDatatype);
        return classesIris;
    }

    @Override
    public boolean isDeactivated(Resource resource) {
        return this.getConfig().canIncludeDeactivatedShapes() || !this.data.hasStatement(resource, SHACL.DEACTIVATED, (Value)TRUE);
    }

    @Override
    public Set<IRI> getDeactivatedShapes() {
        if (this.getConfig().canIncludeDeactivatedShapes()) {
            return Set.of();
        }
        return this.data.streamStatements(null, SHACL.DEACTIVATED, (Value)TRUE).filter(Utils.subjectsAreIris()).map(statement -> (IRI)statement.getSubject()).collect(Collectors.toSet());
    }

    @Override
    public Stream<IRI> findReferencedShaclNodes(Set<IRI> iris) {
        HashSet<IRI> visited = new HashSet<IRI>(iris);
        return iris.stream().flatMap(id -> this.findShaclNodesInternal((IRI)id, (Set<IRI>)visited));
    }

    private Stream<IRI> findShaclNodesInternal(IRI classesIri, Set<IRI> visited) {
        if (visited.contains(classesIri)) {
            return Stream.empty();
        }
        visited.add(classesIri);
        return this.data.streamStatements((Resource)classesIri, SHACL.NODE, null).flatMap(Utils.objectAsIri()).flatMap(id -> Stream.concat(Stream.of(id), this.findShaclNodesInternal((IRI)id, visited)));
    }

    @Override
    public Stream<IRI> findReferencedShaclTypes(Set<IRI> iris) {
        return Stream.empty();
    }

    @Override
    public void readClassMetadata(Classes.Class target, Ontology ontology) {
        this.readTypeMetadata((Resource)target.getIri(), target, ontology);
    }

    @Override
    public void readAnonymousClassMetadata(Classes.AnonymousClass target, Ontology ontology) {
        this.readTypeMetadata(target.getIdentifier(), target, ontology);
    }

    private void readTypeMetadata(Resource resource, Classes.Class target, Ontology ontology) {
        target.setGqlName(this.gqlTypeName(resource));
        this.data.getFirstObject(resource, Constants.GRAPHQL_URI_TEMPLATE).or(() -> this.data.getFirstObject(resource, SomlOntology.PATTERN)).map(Value::stringValue).ifPresent(target::setPattern);
        this.data.getFirstObject(resource, SomlOntology.SPARQL_FEDERATION_SERVICE).ifPresent(target::setSparqlFederatedService);
        Value value = target.getSparqlFederatedService();
        if (value instanceof BNode) {
            BNode bnode = (BNode)value;
            this.data.getFirstObjectAsLiteral((Resource)bnode, Constants.GRAPHQL_NAME).or(() -> this.data.getFirstObjectAsLiteral((Resource)bnode, SomlOntology.NAME_PROP)).or(() -> this.data.getFirstObjectAsLiteral((Resource)bnode, SomlOntology.ENDPOINT_NAME)).map(Value::stringValue).ifPresent(target::setServiceName);
            this.data.getFirstObjectAsIri((Resource)bnode, VOID.SPARQL_ENDPOINT).or(() -> this.data.getFirstObjectAsIri((Resource)bnode, SomlOntology.SPARQL_ENDPOINT)).ifPresent(target::setSparqlFederatedService);
        }
        this.data.getFirstObjectAsLiteral(resource, VANN.PREFERRED_NAMESPACE_PREFIX).map(Value::stringValue).or(() -> this.data.getFirstObjectAsLiteral(resource, VANN.PREFERRED_NAMESPACE_URI).flatMap(value -> this.namespaces.getNamespace(value.stringValue()))).ifPresent(target::setPrefix);
        this.data.getFirstObjectAsIri(resource, VANN.PREFERRED_NAMESPACE_URI).map(Value::stringValue).ifPresent(target::setPreferredNamespace);
        target.setShaclShape(this.data.hasStatement(resource, RDF.TYPE, (Value)SHACL.NODE_SHAPE));
        this.getShaclTarget(resource).ifPresent(target::setShaclTarget);
        Stream targetStatements = target.resolveTarget().map(shalcTarget -> Stream.concat(this.data.streamStatements((Resource)shalcTarget, RDFS.SUBCLASSOF, null), this.data.streamStatements((Resource)shalcTarget, SHACL.NODE, null))).orElse(Stream.empty());
        target.setParentIris(Stream.concat(Stream.concat(this.data.streamStatements(resource, RDFS.SUBCLASSOF, null), this.data.streamStatements(resource, SHACL.NODE, null)), targetStatements).filter(this.getConfig().objectsAreValidClasses()).flatMap(Utils.objectAsIri()).filter(ontology::isTypeAllowed).sorted(Comparator.comparing(val -> this.namespaces.shortIri(val.toString()))).toList());
        this.getShapeUnionTypes(resource).ifPresent(target::setUnionOf);
        this.data.getFirstObject(resource, SomlOntology.NAME_PROP).ifPresent(target::setTypeName);
    }

    private Optional<IRI> getShaclTarget(Resource iri) {
        return Stream.concat(this.data.streamStatements(iri, SHACL.TARGET_CLASS, null), this.data.streamStatements(iri, Constants.DASH_APPLICABLE_TO_CLASS, null)).flatMap(Utils.objectAsIri()).min(Utils.iriComparator());
    }

    private Optional<List<Value>> getShapeUnionTypes(Resource id) {
        if (this.data.hasStatement(id, RDF.TYPE, (Value)SHACL.NODE_SHAPE)) {
            return this.data.getFirstObject(id, SHACL.OR).map(this.data::expandList);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> isInterfaceType(Resource iri) {
        return this.getConfig().getIsInterface().stream().map(predicate -> this.data.getFirstObjectAsLiteral(iri, (IRI)predicate).orElse(null)).filter(Objects::nonNull).map(Literal::booleanValue).findFirst();
    }

    @Override
    public Optional<String> getLabel(Resource iri) {
        List<String> labels = this.data.streamOfFilteredObjects(iri, (Collection<IRI>)this.getConfig().getLabelProps(), (Value)null, Utils.objectsAreEnStrings()).sorted().toList();
        if (labels.isEmpty()) {
            return Optional.empty();
        }
        if (labels.size() > 1) {
            this.messages.add(Message.warning("label.ambiguous", this.namespaces.gqlName(iri.stringValue()), labels, labels.get(0)));
        }
        return Optional.of(labels.get(0));
    }

    @Override
    public Optional<String> getDescription(Resource iri) {
        String joined = this.data.streamOfFilteredObjects(iri, (Collection<IRI>)this.getConfig().getDescriptionProps(), (Value)null, Utils.objectsAreEnStrings()).map(Utils.removeTrailingDots()).distinct().sorted().collect(Collectors.joining(". "));
        if (joined.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(joined);
    }

    @Override
    public String gqlTypeName(Resource resource) {
        ArrayList<Resource> iris = new ArrayList<Resource>(3);
        iris.add(resource);
        Stream.concat(Stream.concat(this.data.streamStatements(null, SHACL.TARGET_CLASS, (Value)resource), this.data.streamStatements(null, Constants.DASH_APPLICABLE_TO_CLASS, (Value)resource)).map(Statement::getSubject), Stream.concat(this.data.streamStatements(resource, SHACL.TARGET_CLASS, null), this.data.streamStatements(resource, Constants.DASH_APPLICABLE_TO_CLASS, null)).flatMap(Utils.objectAsIri())).sorted(Comparator.comparing(Value::stringValue)).forEach(iris::add);
        return this.namespaces.modelSafeType(this.getConfig().getNames().stream().flatMap(predicate -> iris.stream().flatMap(anIri -> this.data.streamStatements((Resource)anIri, (IRI)predicate, null).map(Statement::getObject).map(Value::stringValue))).map(this.namespaces::gqlName).findFirst().orElseGet(() -> {
            if (resource instanceof BNode) {
                throw new IllegalArgumentException("BNode cannot be used for GraphQL name: " + String.valueOf(resource));
            }
            String iriString = resource.stringValue();
            if (resource instanceof IRI) {
                IRI iri = (IRI)resource;
                iriString = this.getShaclTarget((Resource)iri).orElse(iri).stringValue();
            }
            return this.namespaces.gqlName(iriString);
        }), resource);
    }

    @Override
    public String gqlPropertyName(Resource iri) {
        ArrayList<Resource> iris = new ArrayList<Resource>(3);
        iris.add(iri);
        if (this.data.hasStatement((Resource)null, SHACL.PROPERTY, (Value)iri)) {
            this.data.streamStatements(iri, SHACL.PATH, null).flatMap(Utils.objectAsIri()).forEach(iris::add);
        }
        return this.namespaces.modelSafeProperty(this.getConfig().getNames().stream().flatMap(predicate -> iris.stream().flatMap(anIri -> this.data.streamStatements((Resource)anIri, (IRI)predicate, null).map(Statement::getObject).map(Value::stringValue))).map(this.namespaces::gqlName).findFirst().orElseGet(() -> {
            if (iri instanceof BNode) {
                return null;
            }
            return this.namespaces.gqlName(iri.stringValue());
        }), iri);
    }

    @Override
    public Optional<IRI> getInverseOf(Resource resource) {
        return this.data.getFirstStatement(resource, Arrays.asList(OWL.INVERSEOF, Constants.SCHEMA_INVERSE_OF, SomlOntology.INVERSE_OF), Utils.objectsAreIris()).map(st -> (IRI)st.getObject());
    }

    @Override
    public List<PropertyInverseInfo> getPropertyInverseInfos(Resource resource) {
        return List.of();
    }

    @Override
    public void materializeInverseRelations(Collection<Properties.Property> properties) {
        for (Properties.Property property : properties) {
            this.getInverseOf(property.getIri()).ifPresent(inverse -> this.materializeInverseRelations(property.getIri(), (Resource)inverse));
        }
    }

    @Override
    public void materializeInverseRelations(Resource property, Resource inverse) {
        this.data.add(inverse, SomlOntology.INVERSE_OF, (Value)property);
        this.data.getFirstObjectAsIri(property, RDFS.RANGE).ifPresent(range -> this.data.add(inverse, RDFS.DOMAIN, (Value)range));
        this.data.getFirstObjectAsIri(property, RDFS.DOMAIN).ifPresent(domain -> this.data.add(inverse, RDFS.RANGE, (Value)domain));
    }

    @Override
    public Set<Resource> findAllExplicitProperties() {
        LinkedHashSet<Resource> properties = new LinkedHashSet<Resource>();
        for (IRI propClass : this.getConfig().getPropertyClasses()) {
            this.data.streamStatements(null, RDF.TYPE, (Value)propClass).filter(Utils.subjectsAreIris()).forEach(statement -> properties.add(statement.getSubject()));
        }
        this.data.streamStatements(null, SHACL.PROPERTY, null).map(Statement::getObject).filter(Resource.class::isInstance).map(Resource.class::cast).forEach(properties::add);
        properties.removeIf(this.getConfig().isExcludedProp());
        properties.removeIf(prop -> !this.isDeactivated((Resource)prop));
        return properties;
    }

    @Override
    public Map<String, Map<String, Role>> findRbacRoles(IRI ontologyId) {
        return new LinkedHashMap<String, Map<String, Role>>();
    }

    @Override
    public void readPropertyName(Properties.Property property) {
        Resource iri = property.getIri();
        property.setShaclIri((Resource)(this.data.hasStatement((Resource)null, SHACL.PROPERTY, (Value)iri) ? iri : null));
        property.setName(this.gqlPropertyName(iri));
    }

    @Override
    public void readPropertyMetadata(Properties.Property property, Ontology ontology) {
        this.readPropertyName(property);
        Resource resource = property.getIri();
        property.setShaclProperty(property.getShaclIri() != null || resource instanceof BNode || this.data.hasStatement(resource, RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE));
        if (property.isShaclProperty()) {
            this.readShaclPropertyMetadata(property, Objects.requireNonNullElse(property.getShaclIri(), resource), ontology);
        } else if (resource instanceof IRI) {
            IRI iri = (IRI)resource;
            property.setRdfProp(property.getShortIri());
            property.setRdfPropIri(iri);
            this.getLabel(Objects.requireNonNullElse(property.getShaclIri(), resource)).ifPresent(property::setLabel);
            this.getDescription(Objects.requireNonNullElse(property.getShaclIri(), resource)).ifPresent(property::setDescription);
        }
        if (property.getMax() == null) {
            boolean isMultiValued;
            Resource id = Objects.requireNonNullElse(property.getRdfPropIri(), resource);
            boolean bl = isMultiValued = !this.data.hasStatement(id, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            if (!Objects.equals(id, resource)) {
                isMultiValued &= !this.data.hasStatement(resource, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            }
            if (isMultiValued) {
                property.setMax(this.config.getDefaultMaxCardinality());
            }
        }
        if (this.data.hasStatement(resource, RDF.TYPE, (Value)OWL.SYMMETRICPROPERTY)) {
            property.setSymmetric();
        }
    }

    @Override
    public void readShaclPropertyMetadata(Properties.Property property, Resource shaclId, Ontology ontology) {
        property.setShaclIri(Objects.requireNonNullElse(property.getShaclIri(), shaclId));
        new InMemoryShaclPathResolver(this.data, this.namespaces).resolve(property, shaclId);
        this.getConfig().getNames().stream().flatMap(predicate -> this.data.streamStatements(shaclId, (IRI)predicate, null).map(Statement::getObject).map(Value::stringValue)).map(this.namespaces::gqlName).map(this.namespaces::modelSafeProperty).findFirst().ifPresent(property::setName);
        this.data.getFirstObject(shaclId, SomlOntology.IS_TYPE_NAME, Utils.objectsAreLiterals()).map(Literal.class::cast).ifPresent(value -> property.setIsTypeName(value.booleanValue()));
        this.data.getFirstObject(shaclId, SHACL.NAME, Utils.objectsAreEnStrings().or(Utils.objectsAreLiterals())).map(Literal.class::cast).ifPresent(value -> property.setLabel(value.getLabel()));
        this.data.getFirstObject(shaclId, SHACL.DESCRIPTION, Utils.objectsAreEnStrings().or(Utils.objectsAreLiterals())).map(Literal.class::cast).ifPresent(value -> property.setDescription(value.getLabel()));
        this.data.getFirstObject(shaclId, SHACL.MAX_COUNT, Utils.objectsAreNumbers()).map(Literal.class::cast).ifPresent(value -> property.overrideMax(value.decimalValue().toBigInteger().intValue()));
        this.data.getFirstObject(shaclId, SHACL.MIN_COUNT, Utils.objectsAreNumbers()).map(Literal.class::cast).ifPresent(value -> property.overrideMin(value.decimalValue().toBigInteger().intValue()));
        this.data.getFirstObject(shaclId, SHACL.MIN_LENGTH, Utils.objectsAreNumbers()).map(Literal.class::cast).ifPresent(value -> property.setMinLength(value.decimalValue().toBigInteger().intValue()));
        this.data.getFirstObject(shaclId, SHACL.MAX_LENGTH, Utils.objectsAreNumbers()).map(Literal.class::cast).ifPresent(value -> property.setMaxLength(value.decimalValue().toBigInteger().intValue()));
        this.data.getFirstObjectAsLiteral(shaclId, SHACL.MIN_EXCLUSIVE).ifPresent(value -> property.setMinExclusive(value.stringValue()));
        this.data.getFirstObjectAsLiteral(shaclId, SHACL.MAX_EXCLUSIVE).ifPresent(value -> property.setMaxExclusive(value.stringValue()));
        this.data.getFirstObjectAsLiteral(shaclId, SHACL.MIN_INCLUSIVE).ifPresent(value -> property.setMinInclusive(value.stringValue()));
        this.data.getFirstObjectAsLiteral(shaclId, SHACL.MAX_INCLUSIVE).ifPresent(value -> property.setMaxInclusive(value.stringValue()));
        this.data.getFirstObject(shaclId, SHACL.IN).map(this.data::expandList).filter(list -> !list.isEmpty()).ifPresent(values -> values.stream().map(Value::stringValue).forEach(property::addValuesIn));
        this.data.getFirstObject(shaclId, DASH.hasValueIn).map(this.data::expandList).filter(list -> !list.isEmpty()).ifPresent(values -> {
            values.stream().map(Value::stringValue).forEach(property::addValuesIn);
            property.setValuesListExclusive(Boolean.TRUE);
        });
        this.data.getFirstObjectAsLiteral(shaclId, SHACL.PATTERN).ifPresent(value -> property.setPattern(value.stringValue()));
        this.data.getFirstObjectAsLiteral(shaclId, SHACL.FLAGS).ifPresent(value -> property.setFlags(value.stringValue()));
        this.data.getFirstObjectAsIri(shaclId, SHACL.EQUALS).ifPresent(value -> property.setEquals(this.namespaces.shortIri(value.stringValue())));
        this.data.getFirstObject(shaclId, SHACL.DEFAULT_VALUE).or(() -> this.data.getFirstObject(shaclId, SomlOntology.GEN)).ifPresent(value -> property.setDefaultValue(value.stringValue()));
        this.data.getFirstObject(shaclId, SHACL.LANGUAGE_IN).ifPresent(languagesStart -> {
            List languages = this.data.expandList((Value)languagesStart).stream().map(Value::stringValue).collect(Collectors.toList());
            if (this.data.hasStatement(shaclId, SHACL.UNIQUE_LANG, (Value)TRUE)) {
                languages.add("UNIQ");
            }
            LinkedHashMap<String, String> langConfig = new LinkedHashMap<String, String>();
            this.data.getFirstStatement(shaclId, this.getConfig().getLanguage()).map(Statement::getObject).map(Value::stringValue).ifPresent(langVal -> langConfig.put("fetch", (String)langVal));
            langConfig.put("validate", String.join((CharSequence)",", languages));
            property.setLang(langConfig);
        });
        if (ontology.isProtectedProperty(property)) {
            property.setKind("object");
            property.setRange("iri");
        } else {
            this.data.getFirstObjectAsIri(shaclId, SHACL.NODE_KIND_PROP).ifPresent(kindValue -> {
                if (SHACL.IRI.equals(kindValue) || SHACL.BLANK_NODE_OR_IRI.equals(kindValue) || SHACL.BLANK_NODE.equals(kindValue)) {
                    property.setKind("object");
                    property.setRange("iri");
                } else {
                    property.setKind("literal");
                }
            });
            this.resolveShaclPropertyRange(property, shaclId, ontology);
        }
        this.data.getFirstObject(shaclId, SHACL.ORDER, Utils.objectsAreNumbers()).map(Literal.class::cast).ifPresent(value -> property.setOrder(value.decimalValue().doubleValue()));
        if (this.getConfig().canReadShaclPropertyLabels()) {
            this.getLabel(shaclId).ifPresent(property::setLabel);
            this.getDescription(shaclId).ifPresent(property::setDescription);
        }
    }

    private void resolveShaclPropertyRange(Properties.Property property, Resource shaclId, Ontology ontology) {
        this.collectMultiTypeDefinitions(shaclId, SHACL.OR, property, property.getOrDef());
        if (property.getOrDef().isValid() && property.getOrDef().getNodes().isEmpty() && property.getOrDef().getClasses().isEmpty() && property.getOrDef().getDataTypes().stream().allMatch(Utils::isDatatype)) {
            property.setRange(this.namespaces.getScalars().getOrCreateDataTypeUnion(new LinkedHashSet<IRI>(property.getOrDef().getDataTypes())));
            property.setKind("literal");
            return;
        }
        this.collectMultiTypeDefinitions(shaclId, SHACL.AND, property, property.getAndDef());
        if (property.getAndDef().isValid() && property.getAndDef().getDataTypes().isEmpty()) {
            property.setKind("object");
        }
        if (property.getKind() == null) {
            LinkedHashSet foundTypes = new LinkedHashSet();
            this.data.getFirstObjectAsIri(shaclId, SHACL.DATATYPE).ifPresent(type -> {
                foundTypes.add(type);
                property.setRange(Utils.getDataTypeForIri(type));
                property.setKind(Utils.isIriBasedType(type) ? "object" : "literal");
            });
            this.data.getFirstObjectAsIri(shaclId, SHACL.CLASS).ifPresent(type -> {
                foundTypes.add(type);
                property.setRangeClass((IRI)type);
                property.setRange(this.gqlTypeName((Resource)type), (IRI)type);
                property.setKind("object");
            });
            this.data.getFirstObjectAsIri(shaclId, SHACL.NODE).ifPresent(type -> {
                if (ontology.isTypeAllowed((Value)type)) {
                    foundTypes.add(type);
                    property.setNodeRange((Resource)type);
                    property.setRange(this.gqlTypeName((Resource)type), (IRI)type);
                } else {
                    property.setRange("iri");
                }
                property.setKind("object");
            });
            if (foundTypes.size() > 1) {
                this.messages.add(Message.warning("property.range.ambiguous", property.getShortIri(), foundTypes, property.getRange()));
            }
        }
    }

    private void collectMultiTypeDefinitions(Resource shaclId, IRI or, Properties.Property property, MultiTypeDef typeDef) {
        this.data.streamStatements(shaclId, or, null).map(Statement::getObject).map(Resource.class::cast).flatMap(this.handleDashPredicates(property)).forEach(orBegin -> this.data.expandList((Value)orBegin).forEach(nestedPropShape -> {
            this.data.getFirstObjectAsIri((Resource)nestedPropShape, SHACL.DATATYPE).ifPresent(typeDef::addDataType);
            this.data.getFirstObjectAsIri((Resource)nestedPropShape, SHACL.CLASS).ifPresent(typeDef::addClass);
            this.data.getFirstObjectAsIri((Resource)nestedPropShape, SHACL.NODE).ifPresent(typeDef::addNode);
        }));
    }

    @Override
    public boolean isDataProperty(Resource iri) {
        Optional<IRI> shaclPath = this.data.getFirstObjectAsIri(iri, SHACL.PATH);
        return Stream.concat(this.getConfig().getDataPropertyClasses().stream(), this.getConfig().getCustomDataTypes().stream()).anyMatch(dataType -> this.data.hasStatement(iri, RDF.TYPE, (Value)dataType) || shaclPath.filter(path -> this.data.hasStatement((Resource)path, RDF.TYPE, (Value)dataType)).isPresent());
    }

    @Override
    public boolean isObjectProperty(Resource iri) {
        Optional<IRI> shaclPath = this.data.getFirstObjectAsIri(iri, SHACL.PATH);
        return this.getConfig().getObjectPropertyClasses().stream().anyMatch(objType -> this.data.hasStatement(iri, RDF.TYPE, (Value)objType) || shaclPath.filter(path -> this.data.hasStatement((Resource)path, RDF.TYPE, (Value)objType)).isPresent());
    }

    @Override
    public List<Value> findRangeClasses(Resource propIri) {
        List<Value> rangeClasses = this.data.getAllStatementsForMultiplePredicated(propIri, Arrays.asList(RDFS.RANGE, Constants.SCHEMA_RANGE_INCLUDES, SomlOntology.RANGE), null).stream().map(Statement::getObject).distinct().sorted(Utils.iriComparator()).toList();
        return this.data.expandOverUnionOf(rangeClasses);
    }

    @Override
    public List<Value> findDomainClasses(Resource propIri, Ontology ontology) {
        return this.data.getAllStatementsForMultiplePredicated(propIri, Arrays.asList(RDFS.DOMAIN, Constants.SCHEMA_DOMAIN_INCLUDES), null, Utils.objectsAreIris()).stream().map(Statement::getObject).filter(ontology::isTypeAllowed).toList();
    }

    @Override
    public Stream<IRI> resolveShaclPropertyDomain(Resource propIri, Ontology ontology) {
        return Stream.concat(this.data.streamStatements(null, SHACL.PROPERTY, (Value)propIri).filter(Utils.subjectsAreIris()).map(Statement::getSubject).filter(ontology::isTypeAllowed).map(IRI.class::cast), this.data.streamStatements(null, SHACL.PROPERTY, (Value)propIri).filter(Utils.subjectsAreIris()).map(Statement::getSubject).map(IRI.class::cast).filter(domain -> !ontology.isTypeAllowed((Value)domain)).flatMap(domain -> this.data.getSubClasses((IRI)domain).filter(ontology::isTypeAllowed))).distinct();
    }

    @Override
    public List<OwlRestrictionsInfo> getOwlRestrictions(IRI classIri) {
        Set<Resource> subClassOfSet = this.getListOfOwlRestriction(classIri);
        LinkedHashMap propertyToRestriction = new LinkedHashMap();
        for (Resource subClassOf : subClassOfSet) {
            this.data.getFirstObjectAsIri(subClassOf, OWL.ONPROPERTY).ifPresent(property -> propertyToRestriction.computeIfAbsent(property, key -> new LinkedHashSet()).add(subClassOf));
        }
        ArrayList<OwlRestrictionsInfo> restrictions = new ArrayList<OwlRestrictionsInfo>();
        for (Map.Entry entry : propertyToRestriction.entrySet()) {
            IRI onProperty = (IRI)entry.getKey();
            OwlRestrictionsInfo info = new OwlRestrictionsInfo(classIri, onProperty);
            this.processClassRestrictionPropertyTriple(info, (Set)entry.getValue());
            restrictions.add(info);
        }
        return restrictions;
    }

    @Override
    public Map<IRI, Set<IRI>> getTargetClassToShapes(Collection<IRI> iris) {
        LinkedHashMap<IRI, Set<IRI>> map = new LinkedHashMap<IRI, Set<IRI>>();
        if (iris.isEmpty()) {
            Stream.concat(this.data.streamStatements(null, SHACL.TARGET_CLASS, null), this.data.streamStatements(null, Constants.DASH_APPLICABLE_TO_CLASS, null)).filter(Utils.objectsAreIris()).forEach(statement -> map.computeIfAbsent((IRI)statement.getObject(), id -> new LinkedHashSet()).add((IRI)statement.getSubject()));
        } else {
            for (IRI iri : iris) {
                Stream.concat(this.data.streamStatements((Resource)iri, SHACL.TARGET_CLASS, null), this.data.streamStatements((Resource)iri, Constants.DASH_APPLICABLE_TO_CLASS, null)).filter(Utils.objectsAreIris()).forEach(statement -> map.computeIfAbsent((IRI)statement.getObject(), id -> new LinkedHashSet()).add((IRI)statement.getSubject()));
            }
        }
        return map;
    }

    @Override
    public Optional<Value> extractIriAndPrefixFromSwc(IRI ontologyIri, IRI storedContext) {
        return this.modelMap.getOrDefault(storedContext, EMPTY_MODEL).getFirstObject((Resource)ontologyIri, Constants.SWC_IDENTIFIER);
    }

    @Override
    public Optional<String> extractBaseIri(IRI ontologyIri, IRI graphqlModelId, IRI storedContext) {
        Data model = this.modelMap.getOrDefault(storedContext, EMPTY_MODEL);
        Function<IRI, Value> resolver = id -> model.getFirstObject((Resource)id, Constants.SWC_BASE_URL).or(() -> model.getFirstObject((Resource)id, SomlOntology.BASE_IRI)).orElse(null);
        return Stream.of(ontologyIri, graphqlModelId).filter(Objects::nonNull).map(resolver).filter(Objects::nonNull).map(Value::stringValue).findFirst().or(() -> model.getNamespace("").map(Namespace::getName));
    }

    @Override
    public Optional<Pair<String, String>> getDefaultPrefix(IRI graphqlModelId, IRI ontologyId, IRI storedContext) {
        Data model = this.modelMap.getOrDefault(storedContext, EMPTY_MODEL);
        return Stream.of(graphqlModelId, ontologyId).filter(Objects::nonNull).distinct().map(iri -> model.getFirstObject((Resource)iri, Constants.GRAPHQL_DEFAULT_PREFIX).map(Resource.class::cast).orElse(null)).filter(Objects::nonNull).map(defaultPrefixNode -> InMemoryModelDataAccess.readDeclaredPrefixDefinition(defaultPrefixNode, model, Pair::of)).filter(Objects::nonNull).findFirst();
    }

    @Nullable
    private static <E> E readDeclaredPrefixDefinition(Resource defaultPrefixNode, Data model, BiFunction<String, String, E> responseBuilder) {
        String prefix = model.getFirstObject(defaultPrefixNode, SHACL.PREFIX_PROP).map(Value::stringValue).orElse(null);
        String namespace = model.getFirstObject(defaultPrefixNode, SHACL.NAMESPACE_PROP).map(Value::stringValue).orElse(null);
        if (prefix == null || namespace == null) {
            return null;
        }
        return responseBuilder.apply(prefix, namespace);
    }

    @Override
    public List<Pair<String, String>> getDeclaredPrefixes(List<IRI> models, IRI storedContext) {
        Data model = this.modelMap.getOrDefault(storedContext, EMPTY_MODEL);
        return models.stream().distinct().flatMap(iri -> model.streamStatements((Resource)iri, SHACL.DECLARE, null)).map(Statement::getObject).map(Resource.class::cast).map(declareId -> InMemoryModelDataAccess.readDeclaredPrefixDefinition(declareId, this.data, Pair::of)).filter(Objects::nonNull).toList();
    }

    @Override
    public Optional<IRI> getDefinedBy(IRI graphqlModelId, IRI storedContext) {
        return this.modelMap.getOrDefault(storedContext, EMPTY_MODEL).getFirstObjectAsIri((Resource)graphqlModelId, RDFS.ISDEFINEDBY);
    }

    @Override
    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes() {
        return List.of();
    }

    @Override
    public List<PrefixNamespaceResponse> getPossiblePrefixes(String repositoryId) {
        return List.of();
    }

    @Override
    public boolean isContext(IRI iri) {
        return this.modelMap.containsKey(iri);
    }

    @Override
    public boolean isOntology(IRI iri) {
        return this.data.hasStatement((Resource)iri, RDF.TYPE, (Value)OWL.ONTOLOGY);
    }

    @Override
    public Optional<Value> readOntologyId(IRI modelId) {
        return this.data.getFirstObject((Resource)modelId, SomlOntology.ONTOLOGY_IRI).or(() -> this.data.getFirstObject((Resource)modelId, RDFS.ISDEFINEDBY));
    }

    private void processClassRestrictionPropertyTriple(OwlRestrictionsInfo info, Set<Resource> restrictions) {
        restrictions.stream().flatMap(restriction -> this.data.streamStatements((Resource)restriction, OWL.SOMEVALUESFROM, null)).findFirst().ifPresent(statement -> info.setAtLeastOneValueRequired(true));
        info.setPossibleClassRanges(restrictions.stream().flatMap(restriction -> this.data.streamStatements((Resource)restriction, OWL.ONCLASS, null)).filter(Utils.objectsAreIris()).flatMap(Utils.objectAsIri()).toList());
        info.setPossibleDatatypeRanges(restrictions.stream().flatMap(restriction -> this.data.streamStatements((Resource)restriction, OWL.ONDATARANGE, null)).filter(Utils.objectsAreIris()).flatMap(Utils.objectAsIri()).toList());
        restrictions.stream().filter(restriction -> this.data.hasStatement((Resource)restriction, (Collection<IRI>)List.of(OWL.ONCLASS, OWL.ONDATARANGE), new Value[0])).forEach(restriction -> this.setOwlQualifiedCardinality(info, (Resource)restriction));
        List<IRI> ranges = restrictions.stream().flatMap(restriction -> this.data.getAllStatementsForMultiplePredicated((Resource)restriction, (Collection<IRI>)List.of(OWL.SOMEVALUESFROM, OWL.ALLVALUESFROM), null, Utils.objectsAreIris()).stream()).flatMap(Utils.objectAsIri()).distinct().toList();
        info.setPossibleRanges(ranges);
        this.setCardinalityBasedOnOwlRestrictions(info, restrictions);
    }

    private void setOwlQualifiedCardinality(OwlRestrictionsInfo info, Resource restriction) {
        this.data.getFirstObject(restriction, OWL.MINQUALIFIEDCARDINALITY).flatMap(this.parseAsInteger()).ifPresent(info::setMinCardinality);
        this.data.getFirstObject(restriction, OWL.MAXQUALIFIEDCARDINALITY).flatMap(this.parseAsInteger()).ifPresent(info::setMaxCardinality);
        this.data.getFirstObject(restriction, OWL.QUALIFIEDCARDINALITY).flatMap(this.parseAsInteger()).ifPresent(cardinality -> {
            info.setMinCardinality((Integer)cardinality);
            info.setMaxCardinality((Integer)cardinality);
        });
    }

    private void setCardinalityBasedOnOwlRestrictions(OwlRestrictionsInfo info, Set<Resource> restrictions) {
        restrictions.stream().flatMap(restriction -> this.data.streamStatements((Resource)restriction, OWL.CARDINALITY, null)).flatMap(Utils.objectAsLiteral()).map(this.parseAsInteger()).flatMap(Optional::stream).forEach(cardinality -> {
            info.setMinCardinality((Integer)cardinality);
            info.setMaxCardinality((Integer)cardinality);
        });
        restrictions.stream().flatMap(restriction -> this.data.streamStatements((Resource)restriction, OWL.MINCARDINALITY, null)).flatMap(Utils.objectAsLiteral()).map(this.parseAsInteger()).flatMap(Optional::stream).forEach(info::setMinCardinality);
        restrictions.stream().flatMap(restriction -> this.data.streamStatements((Resource)restriction, OWL.MAXCARDINALITY, null)).flatMap(Utils.objectAsLiteral()).map(this.parseAsInteger()).flatMap(Optional::stream).forEach(info::setMaxCardinality);
    }

    private Function<Value, Optional<Integer>> parseAsInteger() {
        return value -> {
            Optional<Object> optional;
            if (value instanceof Literal) {
                Literal literal = (Literal)value;
                optional = this.tryToParseAs(Literal::intValue).apply(literal);
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    private <T> Function<Literal, Optional<T>> tryToParseAs(Function<Literal, T> extractValue) {
        return literal -> {
            try {
                return Optional.of(extractValue.apply((Literal)literal));
            }
            catch (NumberFormatException ex) {
                return Optional.empty();
            }
        };
    }

    private Set<Resource> getListOfOwlRestriction(IRI classIri) {
        Set<Resource> subClassOfSet = this.data.streamStatements((Resource)classIri, RDFS.SUBCLASSOF, null).flatMap(Utils.objectAsResource()).flatMap(iri -> Stream.concat(Stream.of(iri), this.data.streamStatements((Resource)iri, OWL.UNIONOF, null).flatMap(Utils.objectAsResource()).flatMap(listId -> this.data.expandList((Value)listId).stream().filter(Resource.class::isInstance).map(Resource.class::cast)))).collect(Collectors.toSet());
        subClassOfSet.removeIf(iri -> !this.data.hasStatement((Resource)iri, RDF.TYPE, (Value)OWL.RESTRICTION));
        return subClassOfSet;
    }

    private void addJoinedPropToMap(Map<String, Object> map, Resource subject, String propName, Set<IRI> predicates, String delimiter, Predicate<Statement> ... filters) {
        String joined = this.data.streamOfFilteredObjects(subject, predicates, null, filters).map(Utils.removeTrailingDots()).distinct().sorted().collect(Collectors.joining(delimiter));
        if (!joined.isEmpty()) {
            map.put(propName, joined);
        }
    }

    private Function<Resource, Stream<Resource>> handleDashPredicates(Properties.Property property) {
        return resource -> {
            if (resource instanceof IRI) {
                if (resource.equals((Object)Constants.DASH_DATE_OR_DATE_TIME)) {
                    property.setKind("literal");
                    property.setRange("dateOrDateTime");
                    return Stream.empty();
                }
                if (resource.equals((Object)Constants.DASH_STRING_OR_LANG_STRING)) {
                    property.setKind("literal");
                    property.setRange("stringOrLangString");
                    return Stream.empty();
                }
                this.messages.add(Message.warning("property.datatype.unsupported", property.getShortIri(), this.namespaces.shortIri(resource.stringValue())));
            }
            return Stream.of(resource);
        };
    }

    private Predicate<Statement> isNotPrivateClass(GraphQlSchema graphQlSchema) {
        return statement -> statement.getSubject() instanceof IRI && !graphQlSchema.getPrivateShapes().contains(statement.getSubject());
    }

    @Override
    public void close() {
        this.data.close();
    }
}

