/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml.memory;

import com.ontotext.platform.owl2soml.Utils;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;

public class Data
implements Closeable {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private Model model;

    Data(Model model) {
        this.model = model;
    }

    Optional<Namespace> getNamespace(String prefix) {
        return this.model.getNamespace(prefix);
    }

    Optional<Value> getFirstObject(Resource subject, IRI predicate) {
        return this.model.filter(subject, predicate, null, new Resource[0]).stream().map(Statement::getObject).findFirst();
    }

    Optional<Value> getFirstObject(Resource subject, IRI predicate, Predicate<Statement> filters) {
        return this.model.filter(subject, predicate, null, new Resource[0]).stream().filter(filters).map(Statement::getObject).findFirst();
    }

    Optional<IRI> getFirstObjectAsIri(Resource subject, IRI predicate) {
        return this.model.filter(subject, predicate, null, new Resource[0]).stream().filter(Utils.objectsAreIris()).map(Statement::getObject).map(IRI.class::cast).findFirst();
    }

    Optional<Literal> getFirstObjectAsLiteral(Resource subject, IRI predicate) {
        return this.model.filter(subject, predicate, null, new Resource[0]).stream().filter(Utils.objectsAreLiterals()).map(Statement::getObject).map(Literal.class::cast).findFirst();
    }

    Optional<Statement> getFirstStatement(Resource subject, Collection<IRI> predicates) {
        return predicates.stream().flatMap(pred -> this.model.filter(subject, pred, null, new Resource[0]).stream()).findFirst();
    }

    Optional<Statement> getFirstStatement(Resource subject, Collection<IRI> predicates, Predicate<Statement> filters) {
        return predicates.stream().flatMap(pred -> this.filterStream((Stream<Statement>)this.model.filter(subject, pred, null, new Resource[0]).stream(), filters)).findFirst();
    }

    Stream<Statement> streamStatements(Resource subject, IRI predicate, Value object) {
        return this.model.filter(subject, predicate, object, new Resource[0]).stream();
    }

    Stream<Statement> streamStatements(Resource subject, IRI predicate, Value object, Resource ... contexts) {
        return this.model.filter(subject, predicate, object, contexts).stream();
    }

    Collection<Statement> getAllStatementsForMultiplePredicated(Resource subject, Collection<IRI> predicates, IRI object) {
        return predicates.stream().flatMap(predicate -> this.model.filter(subject, predicate, (Value)object, new Resource[0]).stream()).distinct().toList();
    }

    Collection<Statement> getAllStatementsForMultiplePredicated(Resource subject, Collection<IRI> predicates, IRI object, Predicate<Statement> filters) {
        return predicates.stream().flatMap(predicate -> this.filterStream((Stream<Statement>)this.model.filter(subject, predicate, (Value)object, new Resource[0]).stream(), filters)).distinct().toList();
    }

    Collection<Statement> getAllStatementsForMultipleObjects(Resource subject, IRI predicate, Collection<IRI> objects, Predicate<Statement> ... filters) {
        return objects.stream().flatMap(object -> this.filterStream((Stream<Statement>)this.model.filter(subject, predicate, (Value)object, new Resource[0]).stream(), filters)).distinct().toList();
    }

    boolean hasStatement(Resource subject, IRI predicate, Value objects) {
        return this.model.filter(subject, predicate, objects, new Resource[0]).stream().findAny().isPresent();
    }

    boolean hasStatement(Resource subject, IRI predicate, Value ... objects) {
        return this.hasStatement(subject, List.of(predicate), objects);
    }

    boolean hasStatement(Resource subject, Collection<IRI> predicates, Value ... objects) {
        if (objects == null || objects.length == 0) {
            return this.streamOfFilteredObjects(subject, predicates, null).findFirst().isPresent();
        }
        return Arrays.stream(objects).flatMap(object -> this.streamOfFilteredObjects(subject, predicates, (Value)object)).findFirst().isPresent();
    }

    private Stream<Statement> streamOfFilteredObjects(Resource subject, Collection<IRI> predicates, Value object) {
        return predicates.stream().flatMap(s -> this.model.filter(subject, s, object, new Resource[0]).stream());
    }

    Stream<String> streamOfFilteredObjects(Resource subject, Collection<IRI> predicates, Value object, Predicate<Statement> filters) {
        Stream<Statement> stream = predicates.stream().flatMap(s -> this.model.filter(subject, s, object, new Resource[0]).stream());
        stream = this.filterStream(stream, filters);
        return stream.map(Statement::getObject).map(Value::stringValue);
    }

    Stream<String> streamOfFilteredObjects(Resource subject, Collection<IRI> predicates, Value object, Predicate<Statement> ... filters) {
        Stream<Statement> stream = predicates.stream().flatMap(s -> this.model.filter(subject, s, object, new Resource[0]).stream());
        stream = this.filterStream(stream, filters);
        return stream.map(Statement::getObject).map(Value::stringValue);
    }

    Stream<Statement> filterStream(Stream<Statement> stream, Predicate<Statement> filters) {
        return stream.filter(filters);
    }

    Stream<Statement> filterStream(Stream<Statement> stream, Predicate<Statement> ... filters) {
        for (Predicate<Statement> filter : filters) {
            stream = stream.filter(filter);
        }
        return stream;
    }

    List<Value> expandOverUnionOf(List<Value> subjects) {
        subjects = subjects.stream().flatMap(sub -> this.expandList((Value)sub).stream()).collect(Collectors.toList());
        LinkedList<Value> unionClasses = new LinkedList<Value>();
        for (Value value : subjects) {
            if (!(value instanceof Resource)) continue;
            Resource resource = (Resource)value;
            this.streamStatements(resource, OWL.UNIONOF, null).map(Statement::getObject).forEach(unionClasses::add);
        }
        if (unionClasses.isEmpty()) {
            return subjects;
        }
        LinkedList<Object> combined = new LinkedList<Object>(subjects);
        combined.addAll(this.expandOverUnionOf(unionClasses));
        return combined;
    }

    List<Value> expandList(Value value) {
        return Utils.expandList(value, this::getFirstObject);
    }

    public Stream<IRI> getSubClasses(IRI classIri) {
        return this.getSubClassesInternal(classIri, new HashSet<IRI>());
    }

    private Stream<IRI> getSubClassesInternal(IRI classIri, Set<IRI> found) {
        if (found.contains(classIri)) {
            return Stream.empty();
        }
        found.add(classIri);
        return Stream.concat(this.streamStatements(null, RDFS.SUBCLASSOF, (Value)classIri), this.streamStatements(null, SHACL.NODE, (Value)classIri)).map(Statement::getSubject).map(IRI.class::cast).filter(id -> !found.contains(id)).flatMap(id -> Stream.concat(Stream.of(id), this.getSubClassesInternal((IRI)id, found)));
    }

    Stream<IRI> getSuperClasses(IRI classIri) {
        return this.getSuperClassesInternal(classIri, new HashSet<IRI>()).flatMap(this::expandOverRdfsSeeAlso);
    }

    private Stream<IRI> getSuperClassesInternal(IRI classIri, Set<IRI> found) {
        if (found.contains(classIri)) {
            return Stream.empty();
        }
        found.add(classIri);
        return Stream.concat(this.streamStatements((Resource)classIri, RDFS.SUBCLASSOF, null), this.streamStatements((Resource)classIri, SHACL.NODE, null)).flatMap(Utils.objectAsIri()).filter(id -> !found.contains(id)).flatMap(id -> Stream.concat(Stream.of(id), this.getSuperClassesInternal((IRI)id, found)));
    }

    private Stream<IRI> expandOverRdfsSeeAlso(IRI iri) {
        return Stream.concat(Stream.of(iri), this.streamStatements((Resource)iri, RDFS.SEEALSO, null).flatMap(Utils.objectAsIri()));
    }

    void addAll(Model ontology) {
        this.model.addAll((Collection)ontology);
    }

    void add(Resource subject, IRI predicate, Value object) {
        this.model.add((Object)vf.createStatement(subject, predicate, object));
    }

    @Override
    public void close() {
        this.model.clear();
    }
}

