/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.RoleAction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.rdf4j.model.IRI;

public class Permissions {
    private static final String DESCRIPTION = "description";
    private static final String ACTIONS = "actions";
    private static final String NOT_ACTIONS = "notActions";
    private static final String ROLES = "roles";
    private final String endpointId;
    private final Ontology ontology;
    private final DataAccess dataAccess;
    private final List<Message> messages;
    private Map<String, Role> rbacRoles;

    public Permissions(String endpointId, Ontology ontology, DataAccess dataAccess, List<Message> messages) {
        this.endpointId = endpointId;
        this.ontology = ontology;
        this.dataAccess = dataAccess;
        this.messages = messages;
    }

    public void collect() {
        Boolean readRbacRules = this.dataAccess.getConfig().getReadRbacRules();
        this.rbacRoles = Boolean.FALSE.equals(readRbacRules) ? Map.of() : this.readRbacRules();
    }

    private Map<String, Role> readRbacRules() {
        IRI modelId = this.ontology.graphqlModelId;
        Map<String, Map<String, Role>> map = this.dataAccess.findRbacRoles(modelId);
        Map<String, Role> schemaRoles = null;
        if (Objects.nonNull(modelId)) {
            schemaRoles = map.get(modelId.stringValue());
        }
        if ((Objects.isNull(schemaRoles) || schemaRoles.isEmpty()) && Objects.nonNull(schemaRoles = map.get("unbound")) && !schemaRoles.isEmpty()) {
            this.messages.add(Message.warning("unbounded.rbac.rules.applied", this.endpointId));
        }
        if (Objects.isNull(schemaRoles)) {
            schemaRoles = Map.of();
        }
        return schemaRoles;
    }

    public Object toSomlPermissions() {
        LinkedHashMap result = new LinkedHashMap();
        this.rbacRoles.forEach((name, role) -> {
            List<RoleAction> notActions;
            List<RoleAction> actions;
            Map roleMap = result.computeIfAbsent(name, k -> new LinkedHashMap());
            String description = role.getDescription();
            if (Objects.nonNull(description)) {
                roleMap.put(DESCRIPTION, description);
            }
            if (!(actions = role.getActions()).isEmpty()) {
                TreeSet actionsSet = new TreeSet();
                actions.forEach(action -> actionsSet.addAll(action.getSomlRepresentation()));
                roleMap.put(ACTIONS, actionsSet.stream().toList());
            }
            if (!(notActions = role.getNotActions()).isEmpty()) {
                TreeSet notActionsSet = new TreeSet();
                notActions.forEach(notAction -> notActionsSet.addAll(notAction.getSomlRepresentation()));
                roleMap.put(NOT_ACTIONS, notActionsSet.stream().toList());
            }
        });
        return Map.of(ROLES, result);
    }

    public Map<String, Role> getRbacRoles() {
        return this.rbacRoles;
    }
}

