/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.Prefixes;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.platform.owl2soml.AmbiguousGraphQlSchemaException;
import com.ontotext.platform.owl2soml.ConversionException;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.InputOntology;
import com.ontotext.platform.owl2soml.InvalidArgumentException;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OntologyMetadata;
import com.ontotext.platform.owl2soml.memory.InMemoryOntology;
import com.ontotext.platform.owl2soml.persistent.OntologyReference;
import com.ontotext.platform.owl2soml.persistent.ResourceOntologyReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

class OntologySet {
    public static final SimpleValueFactory VF = SimpleValueFactory.getInstance();
    private final Map<String, String> explicitPrefixes = new TreeMap<String, String>();
    private String id;
    private final boolean useDefaultPrefix;
    private final List<Ontology> ontologies;
    private final DataAccess dataAccess;
    private final List<Message> messages;

    OntologySet(String id, boolean useDefaultPrefix, List<InputOntology> ontologies, DataAccess dataAccess, List<Message> messages) {
        this.id = id;
        this.useDefaultPrefix = useDefaultPrefix;
        this.dataAccess = dataAccess;
        this.messages = messages;
        this.ontologies = ontologies.stream().map(this::createOntology).sorted().toList();
    }

    Map<String, String> getExplicitPrefixes() {
        return this.explicitPrefixes;
    }

    String getId() {
        return this.id;
    }

    Ontology loadOntologies(Namespaces namespaces) throws ConversionException {
        this.doLoad();
        this.linkImports();
        this.loadPrefixes(namespaces);
        SpecialPrefixes specialPrefixes = namespaces.getSpecialPrefixes();
        Ontology ontology = this.resolvePrimaryOntology(specialPrefixes);
        this.extractOntologyMetadata(ontology, namespaces);
        this.resolveShapesIri(specialPrefixes, namespaces);
        namespaces.expandPrefixes();
        this.explicitPrefixes.put((String)specialPrefixes.getVocabPrefix().orElseThrow(ConversionException.failedTo("resolve vocab_prefix")), (String)specialPrefixes.getVocabIri().orElseThrow(ConversionException.failedTo("resolve vocab_iri")));
        this.resolveIdIfNotSet(ontology, namespaces.getPrefixes(), specialPrefixes);
        this.dataAccess.loadModelConfigurations(ontology);
        return ontology;
    }

    private void resolveShapesIri(SpecialPrefixes specialPrefixes, Namespaces namespaces) {
        namespaces.getNamespace("vocsh").ifPresent(namespace -> specialPrefixes.put("shape_iri", namespace));
    }

    private void linkImports() {
        this.ontologies.forEach(ontology -> ontology.setRelatedOntologies(this.ontologies));
    }

    private void doLoad() {
        for (Ontology ontology : this.ontologies) {
            this.dataAccess.configureWith(ontology);
        }
        this.dataAccess.loadConfigurations();
    }

    private void loadPrefixes(Namespaces namespaces) {
        for (Ontology ontology : this.ontologies) {
            ontology.getNamespaces().forEach(namespace -> {
                if (namespace.getPrefix().isEmpty()) {
                    return;
                }
                String current = this.explicitPrefixes.putIfAbsent(namespace.getPrefix(), namespace.getName());
                if (current != null && !current.equals(namespace.getName())) {
                    Message warning = Message.warning("ambiguous.namespace", namespace.getPrefix(), current, namespace.getName());
                    ontology.getMessages().add(warning);
                }
            });
        }
        namespaces.loadNamespaces(this.explicitPrefixes);
    }

    @NotNull
    private Ontology resolvePrimaryOntology(SpecialPrefixes specialPrefixes) throws ConversionException {
        if (this.id == null) {
            return this.pickOntology();
        }
        Literal idLiteral = VF.createLiteral(this.id);
        IRI idIri = this.tryConvertIdToIri(specialPrefixes);
        Optional<Ontology> matchedOntology = this.findOntologyByName(idLiteral).or(() -> this.findOntologyByIri(idIri));
        if (matchedOntology.isPresent()) {
            return matchedOntology.get().useFirstOntology();
        }
        return this.pickOntology();
    }

    private Optional<Ontology> findOntologyByName(Literal idLiteral) {
        Optional<Ontology> found = this.ontologies.stream().filter(ontology -> ontology.match(idLiteral)).findFirst().map(ontology -> ontology.selectGraphqlModel(idLiteral));
        if (found.isPresent()) {
            this.id = OntologySet.prepareForSomlId(this.id);
        }
        return found;
    }

    private Optional<Ontology> findOntologyByIri(IRI iri) {
        if (iri == null) {
            return Optional.empty();
        }
        Optional<Ontology> found = this.ontologies.stream().filter(ontology -> ontology.getGraphqlModelIds().contains(iri) || ontology.getOntologyIds().contains(iri)).findFirst().map(ontology -> ontology.selectOntology(iri));
        found.ifPresent(ontology -> {
            this.id = ontology.getOntologyName().orElseGet(() -> OntologySet.prepareForSomlId(iri.getLocalName()));
        });
        return found;
    }

    @NotNull
    private Ontology pickOntology() throws ConversionException {
        Optional<Ontology> pickedOntology;
        long graphqlModels = this.ontologies.stream().mapToLong(ontology -> ontology.getGraphqlModelIds().size()).sum();
        if (graphqlModels > 1L) {
            throw this.ambiguousGraphqlSchemas();
        }
        if (graphqlModels == 1L && (pickedOntology = this.ontologies.stream().filter(Ontology::hasGraphQlSchema).findFirst().or(() -> this.ontologies.stream().findFirst())).isPresent()) {
            return pickedOntology.get().useFirstOntology();
        }
        pickedOntology = this.ontologies.stream().filter(Ontology::hasSingleOwlDefinition).findFirst().or(() -> this.ontologies.stream().filter(Ontology::hasOwlDefinition).findFirst());
        if (pickedOntology.isPresent()) {
            return pickedOntology.get().useFirstOntology();
        }
        if (!this.ontologies.isEmpty()) {
            return this.ontologies.getFirst().useFirstOntology();
        }
        throw this.idNotMatched();
    }

    private IRI tryConvertIdToIri(SpecialPrefixes specialPrefixes) {
        String prefix;
        SimpleValueFactory vf = VF;
        if (this.id.startsWith("http")) {
            return vf.createIRI(this.id);
        }
        int index = this.id.indexOf(":");
        if (index > 0 && this.explicitPrefixes.containsKey(prefix = this.id.substring(0, index))) {
            return vf.createIRI(this.explicitPrefixes.get(prefix) + this.id.substring(index));
        }
        return specialPrefixes.getVocabIri().map(arg_0 -> this.lambda$tryConvertIdToIri$13((ValueFactory)vf, arg_0)).or(() -> this.lambda$tryConvertIdToIri$15(specialPrefixes, (ValueFactory)vf)).or(() -> this.lambda$tryConvertIdToIri$17(specialPrefixes, (ValueFactory)vf)).orElseGet(() -> this.lambda$tryConvertIdToIri$18((ValueFactory)vf));
    }

    private AmbiguousGraphQlSchemaException ambiguousGraphqlSchemas() {
        Map<IRI, String> collect = this.ontologies.stream().flatMap(ontology -> ontology.resolveGraphQlIdentities().entrySet().stream()).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new AmbiguousGraphQlSchemaException(collect);
    }

    private InvalidArgumentException idNotMatched() {
        return new InvalidArgumentException(ErrorMessages.get((String)"ontologies.graphql.idNotMatched", (Object[])new Object[]{this.id}));
    }

    private Optional<String> getGraphQlSchemaName(Ontology ontology) {
        if (ontology.hasGraphQlSchema()) {
            return ontology.getOntologyName().map(OntologySet::prepareForSomlId).or(() -> Optional.of(OntologySet.prepareForSomlId(ontology.getGraphqlModelId().getLocalName())));
        }
        return Optional.empty();
    }

    private Optional<String> getPrefixForOntology(Prefixes prefixes, Ontology ontology) {
        if (ontology.getOntologyId() == null) {
            return Optional.empty();
        }
        return prefixes.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(ontology.getOntologyId().stringValue())).map(Map.Entry::getKey).findFirst();
    }

    private static Optional<String> schemaIriToId(Ontology ontology) {
        if (ontology.getOntologyId() != null) {
            return Optional.of(OntologySet.prepareForSomlId(ontology.getOntologyId().getLocalName()));
        }
        return Optional.empty();
    }

    private static String prepareForSomlId(String id) {
        return id.replaceAll("[^\\w-]+", "_");
    }

    private void extractOntologyMetadata(Ontology ontology, Namespaces namespaces) throws ConversionException {
        if (this.useDefaultPrefix || ontology.isEmpty() && namespaces.getSpecialPrefixes().isEmpty() && ontology.getGraphQlSchema().getDefaultPrefix() == null) {
            namespaces.setRandomVocabularyPrefix(this.id);
        } else {
            try {
                OntologyMetadata ontologyMetadata = ontology.readMetadata();
                ontologyMetadata.extract(namespaces);
            }
            catch (ConversionException.NoOntologyInformationException | ConversionException.NoVocabularyPrefixException ex) {
                this.messages.add(Message.warning(ex.getMessage()));
                namespaces.setRandomVocabularyPrefix(this.id);
            }
        }
    }

    private void resolveIdIfNotSet(Ontology ontology, Prefixes prefixes, SpecialPrefixes specialPrefixes) {
        this.id = this.id == null ? specialPrefixes.getVocabPrefix().or(() -> this.getGraphQlSchemaName(ontology)).or(() -> this.getPrefixForOntology(prefixes, ontology)).or(() -> OntologySet.schemaIriToId(ontology)).orElse("example") : this.id.replace(" ", "");
    }

    Ontology createOntology(InputOntology inputOntology) {
        if (inputOntology.getOntologyBody() != null) {
            return new InMemoryOntology(inputOntology.getOntologyBody(), this.dataAccess, this.messages);
        }
        if (inputOntology.getOntologyId() != null) {
            return new OntologyReference(inputOntology.getOntologyId(), this.dataAccess, this.messages);
        }
        if (inputOntology.getResourceName() != null && inputOntology.getInputStream() != null) {
            return new ResourceOntologyReference(inputOntology.getResourceName(), inputOntology.getInputStream(), this.dataAccess, this.messages);
        }
        throw new InvalidArgumentException("Either input Model or model Id should be provided");
    }

    private /* synthetic */ IRI lambda$tryConvertIdToIri$18(ValueFactory vf) {
        try {
            return vf.createIRI(this.id);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private /* synthetic */ Optional lambda$tryConvertIdToIri$17(SpecialPrefixes specialPrefixes, ValueFactory vf) {
        return specialPrefixes.getBaseIri().map(base -> vf.createIRI(base + this.id));
    }

    private /* synthetic */ Optional lambda$tryConvertIdToIri$15(SpecialPrefixes specialPrefixes, ValueFactory vf) {
        return specialPrefixes.getVocabPrefix().map(this.explicitPrefixes::get).map(namespace -> vf.createIRI(namespace + this.id));
    }

    private /* synthetic */ IRI lambda$tryConvertIdToIri$13(ValueFactory vf, String vocab) {
        return vf.createIRI(vocab + this.id);
    }
}

