/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.platform.owl2soml.ConversionException;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OntologyMetadata;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.jetbrains.annotations.NotNull;

public class OntologyMetadataExtractor
implements OntologyMetadata {
    protected final Ontology ontology;
    protected final DataAccess dataAccess;

    public OntologyMetadataExtractor(Ontology ontology) {
        this.ontology = ontology;
        this.dataAccess = ontology.getDataAccess();
    }

    @Override
    public void extract(Namespaces namespaces) throws ConversionException {
        this.extractOwlOntologyFromMainOntology(namespaces.getSpecialPrefixes());
        this.extractBaseUrl(namespaces.getSpecialPrefixes());
        this.extractVocabAndBaseIri(namespaces);
    }

    protected void extractOwlOntologyFromMainOntology(SpecialPrefixes specialPrefixes) {
        IRI iri;
        IRI ontologyIri = this.ontology.getOntologyId();
        if (ontologyIri instanceof IRI && (this.dataAccess.isOntology(iri = ontologyIri) || !this.dataAccess.isContext(iri))) {
            specialPrefixes.put("ontology_iri", ontologyIri.stringValue());
            return;
        }
        IRI graphqlModelId = this.ontology.getGraphqlModelId();
        if (graphqlModelId != null) {
            this.dataAccess.readOntologyId(graphqlModelId).ifPresent(id -> specialPrefixes.put("ontology_iri", id.stringValue()));
        }
    }

    protected void extractBaseUrl(SpecialPrefixes specialPrefixes) {
        if (this.ontology == null) {
            return;
        }
        this.dataAccess.extractBaseIri(this.ontology.getOntologyId(), this.ontology.getGraphqlModelId(), this.ontology.getStoredContext()).ifPresent(baseIri -> specialPrefixes.put("base_iri", baseIri));
    }

    protected void extractVocabAndBaseIri(Namespaces namespaces) throws ConversionException {
        if (this.extractIriFromExplicitPrefix(namespaces)) {
            return;
        }
        if (this.extractIriAndPrefixFromGraphqlAndShacl(namespaces)) {
            return;
        }
        if (this.ontology.getOntologyId() == null && this.ontology.getOntologyIds().isEmpty()) {
            throw new ConversionException.NoOntologyInformationException();
        }
        if (this.checkModelForOntologyInfo(this.ontology.getOntologyId(), namespaces)) {
            return;
        }
        for (IRI ontologyId : this.ontology.getOntologyIds()) {
            if (!this.checkModelForOntologyInfo(ontologyId, namespaces)) continue;
            return;
        }
        for (IRI ontologyId : this.ontology.getOntologyImports()) {
            if (!this.checkModelForOntologyInfo(ontologyId, namespaces)) continue;
            return;
        }
        throw new ConversionException.NoVocabularyPrefixException(this.ontology.getOntologyId().stringValue(), namespaces.getPrefixes().entrySet().stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator())));
    }

    protected boolean extractIriFromExplicitPrefix(Namespaces namespaces) throws ConversionException {
        Optional vocabPrefix = namespaces.getSpecialPrefixes().getVocabPrefix();
        if (vocabPrefix.isPresent()) {
            String vocPfx = (String)vocabPrefix.get();
            String vocIri = (String)namespaces.getPrefixes().get((Object)vocPfx);
            if (vocIri == null) {
                throw new ConversionException("voc.explicit.missingIri", vocPfx);
            }
            namespaces.setVocabularyPrefix(vocPfx, vocIri);
            return true;
        }
        return false;
    }

    protected boolean extractIriAndPrefixFromGraphqlAndShacl(Namespaces namespaces) {
        SpecialPrefixes specialPrefixes;
        Prefixes prefixes = namespaces.getPrefixes();
        GraphQlSchema graphQlSchema = this.getGraphQlSchema(namespaces);
        String defaultPrefix = null;
        if (graphQlSchema.getDefaultPrefix() != null) {
            defaultPrefix = graphQlSchema.getDefaultPrefix().stringValue();
            if (graphQlSchema.getDefaultNamespace() != null) {
                String namespace = graphQlSchema.getDefaultNamespace().stringValue();
                if (!namespace.equals(prefixes.getOrDefault((Object)defaultPrefix, (Object)namespace))) {
                    Message warning = Message.warning("ontology.graphql.conflict", defaultPrefix, namespace, defaultPrefix, prefixes.get((Object)defaultPrefix));
                    this.ontology.getMessages().add(warning);
                }
                prefixes.put(defaultPrefix, namespace);
                namespaces.setVocabularyPrefix(defaultPrefix, namespace);
            }
        }
        if (!namespaces.isVocabularySet()) {
            this.dataAccess.getDefaultPrefix(this.ontology.getGraphqlModelId(), this.ontology.getOntologyId(), this.ontology.getStoredContext()).ifPresent(defaultNamespace -> namespaces.setVocabularyPrefix((String)defaultNamespace.getKey(), (String)defaultNamespace.getValue()));
        }
        List<IRI> models = Stream.concat(Stream.of(this.ontology.getGraphqlModelId(), this.ontology.getOntologyId()), this.ontology.getOntologyImports().stream()).filter(Objects::nonNull).distinct().toList();
        List<Pair<String, String>> declaredPrefixes = this.dataAccess.getDeclaredPrefixes(models, this.ontology.getStoredContext());
        for (Pair<String, String> pair : declaredPrefixes) {
            String prefix = (String)pair.getKey();
            String namespace = (String)pair.getValue();
            if (!namespace.equals(prefixes.getOrDefault((Object)prefix, (Object)namespace))) {
                Message warning = Message.warning("ontology.shacl.conflict", prefix, namespace, prefix, prefixes.get((Object)prefix));
                this.ontology.getMessages().add(warning);
            }
            prefixes.put(prefix, namespace);
        }
        if (!namespaces.isVocabularySet() && defaultPrefix != null && !namespaces.setVocabularyPrefix(defaultPrefix)) {
            this.ontology.getMessages().add(Message.warning("voc.explicit.missingIri", defaultPrefix));
        }
        return (specialPrefixes = namespaces.getSpecialPrefixes()).getVocabPrefix().isPresent() || specialPrefixes.getVocabIri().isPresent();
    }

    @NotNull
    protected GraphQlSchema getGraphQlSchema(Namespaces namespaces) {
        return this.ontology.getGraphQlSchema();
    }

    protected boolean checkModelForOntologyInfo(IRI ontologyIri, Namespaces namespaces) throws ConversionException {
        if (this.extractIriAndPrefixFromSwc(ontologyIri, namespaces)) {
            return true;
        }
        if (this.extractIriAndPrefixFromVann(ontologyIri, namespaces)) {
            return true;
        }
        return this.extractIriAndPrefixFromExistingPrefixes((Resource)ontologyIri, namespaces);
    }

    protected boolean extractIriAndPrefixFromSwc(IRI ontologyIri, Namespaces namespaces) {
        Optional<Value> statement = this.dataAccess.extractIriAndPrefixFromSwc(ontologyIri, this.ontology.getStoredContext());
        if (statement.isPresent()) {
            String vocPfx = statement.get().stringValue();
            String vocIri = ontologyIri.stringValue() + "/";
            namespaces.setVocabularyPrefix(vocPfx, vocIri);
            return true;
        }
        return false;
    }

    protected boolean extractIriAndPrefixFromVann(IRI ontologyIri, Namespaces namespaces) throws ConversionException {
        Optional<Pair<Value, Value>> pair = this.dataAccess.extractIriAndPrefixFromVann(ontologyIri, this.ontology.getStoredContext());
        if (pair.isEmpty()) {
            return false;
        }
        Pair<Value, Value> prefixNameSpace = pair.get();
        namespaces.setVocabularyPrefix(((Value)prefixNameSpace.getKey()).stringValue(), ((Value)prefixNameSpace.getValue()).stringValue());
        SpecialPrefixes specialPrefixes = namespaces.getSpecialPrefixes();
        String vocPfx = (String)specialPrefixes.getVocabPrefix().orElseThrow(ConversionException.failedTo("resolve vocab_prefix"));
        String vocIri = (String)specialPrefixes.getVocabIri().orElseThrow(ConversionException.failedTo("resolve vocab_iri"));
        Prefixes prefixes = namespaces.getPrefixes();
        if (!vocIri.equals(prefixes.getOrDefault((Object)vocPfx, (Object)vocIri))) {
            throw new ConversionException("ontology.vann.conflict", vocPfx, vocIri, vocPfx, prefixes.get((Object)vocPfx));
        }
        prefixes.putIfAbsent(vocPfx, vocIri);
        return true;
    }

    private boolean extractIriAndPrefixFromExistingPrefixes(Resource ontologyIri, Namespaces namespaces) {
        Predicate<String> matchesOntology = Pattern.compile("^" + ontologyIri.stringValue() + "[#/]?").asPredicate();
        Prefixes prefixes = namespaces.getPrefixes();
        prefixes.entrySet().stream().filter(entry -> matchesOntology.test((String)entry.getValue())).findFirst().ifPresent(ns -> namespaces.setVocabularyPrefix((String)ns.getKey(), (String)ns.getValue()));
        if (namespaces.isVocabularySet()) {
            return true;
        }
        try {
            String shortIri = prefixes.toShortIri(ontologyIri.stringValue());
            String[] split = shortIri.split(":");
            if (split.length == 2) {
                namespaces.setVocabularyPrefix(split[0], (String)prefixes.get((Object)split[0]));
            }
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
        return namespaces.isVocabularySet();
    }
}

