/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.jetbrains.annotations.NotNull;

public class Classes {
    public static final String INTERFACE_SUFFIX = "Interface";
    private final Ontology ontology;
    private final Namespaces namespaces;
    private final DataAccess dataAccess;
    private final List<Message> messages;
    private final Map<IRI, Class> classesByIri = new LinkedHashMap<IRI, Class>();
    private Map<String, Class> classesByName = new TreeMap<String, Class>();

    Classes(Ontology ontology, Namespaces namespaces, DataAccess dataAccess, List<Message> messages) {
        this.ontology = ontology;
        this.namespaces = namespaces;
        this.dataAccess = dataAccess;
        this.messages = messages;
    }

    void collect() {
        this.findExplicitClassesInModel();
        this.createSuperClasses();
        Map<String, List<Class>> groupedByName = this.classesByIri.values().stream().collect(Collectors.groupingBy(Class::getName));
        HashSet invalidShapes = new HashSet();
        this.classesByName = groupedByName.values().stream().map(list -> this.mergeClassesWithSameNames((List<Class>)list, invalidShapes)).collect(Collectors.toMap(Class::getName, Function.identity(), (v1, v2) -> v1, TreeMap::new));
        this.classesByName.keySet().removeAll(invalidShapes);
    }

    private Class mergeClassesWithSameNames(List<Class> classes, Set<String> invalidShapes) {
        if (classes.size() == 1) {
            return classes.getFirst();
        }
        List<Class> types = classes.stream().filter(Predicate.not(Class::isShaclShape)).toList();
        List<Class> shapes = classes.stream().filter(Class::isShaclShape).toList();
        if (types.isEmpty() && shapes.isEmpty()) {
            throw new IllegalArgumentException("Unsupported types: " + String.valueOf(classes));
        }
        Class primary = types.isEmpty() ? shapes.getFirst() : types.getFirst();
        types.stream().flatMap(type -> {
            if (type.getTypes().isEmpty()) {
                return Stream.of(type.getShortIri());
            }
            return type.getTypes().stream();
        }).forEach(primary::setType);
        shapes.forEach(shape -> primary.shapes.putIfAbsent(shape.getIri(), (Class)shape));
        primary.shapes.values().stream().map(Class::getName).filter(Predicate.not(Predicate.isEqual(primary.getName()))).forEach(invalidShapes::add);
        return primary;
    }

    Collection<Class> values() {
        return new ArrayList<Class>(this.classesByName.values());
    }

    Class get(String name) {
        if (name == null) {
            return null;
        }
        return this.classesByName.get(name);
    }

    Class get(IRI iri) {
        if (iri == null) {
            return null;
        }
        return this.classesByIri.get(iri);
    }

    String getTypeName(IRI type) {
        return this.contains(type) ? this.get(type).getName() : this.namespaces.gqlName(type.stringValue());
    }

    Class add(IRI iri) {
        Class clazz = new Class(iri);
        this.classesByIri.put(iri, clazz);
        this.classesByName.put(clazz.getName(), clazz);
        return clazz;
    }

    boolean contains(IRI iri) {
        return this.classesByIri.containsKey(iri);
    }

    boolean containsByName(String name) {
        return this.classesByName.containsKey(name);
    }

    public boolean isValidClass(IRI typeIri) {
        return this.contains(typeIri) && !this.dataAccess.getConfig().getCustomDataTypes().contains(typeIri);
    }

    Stream<Properties.Property> getUsedProperties() {
        return this.getApplicableClassesForSerialization().stream().filter(this::isTypeAllowed).flatMap(clazz -> clazz.resolveProperties().values().stream());
    }

    Map<String, Object> toSomlObjects() {
        TreeMap<String, Object> somlObjects = new TreeMap<String, Object>();
        for (Class clazz : this.getApplicableClassesForSerialization()) {
            if (!this.isTypeAllowed(clazz)) continue;
            somlObjects.put(clazz.getName(), clazz.toSomlObject());
        }
        return somlObjects;
    }

    @NotNull
    private List<Class> getApplicableClassesForSerialization() {
        LinkedList<Class> classesCopy = new LinkedList<Class>(this.classesByName.values());
        classesCopy.removeIf(type -> this.ontology.getGraphQlSchema().getPrivateShapes().contains(type.getIri()));
        if (!this.ontology.getGraphQlSchema().getProtectedShapes().isEmpty()) {
            classesCopy.stream().filter(type -> this.ontology.getGraphQlSchema().getProtectedShapes().contains(type.getIri()) || this.ontology.getGraphQlSchema().getProtectedClasses().contains(type.getIri())).forEach(Class::setProtected);
            ArrayList<Class> copy = new ArrayList<Class>(classesCopy);
            classesCopy.removeIf(type -> !this.isProtectedClassReferenced((Class)type, (Collection<Class>)copy));
        }
        return classesCopy;
    }

    private boolean isProtectedClassReferenced(Class clazz, Collection<Class> classesCopy) {
        if (clazz.isPublic() || clazz.isProtected()) {
            return true;
        }
        Set referencedInTypes = classesCopy.stream().filter(type -> type != clazz).filter(type -> type.hasTypeReferenceOf(clazz.getName())).collect(Collectors.toSet());
        if (referencedInTypes.isEmpty()) {
            return false;
        }
        if (referencedInTypes.stream().anyMatch(type -> type.isPublic() || type.isProtected())) {
            return true;
        }
        return referencedInTypes.stream().anyMatch(reference -> this.isProtectedClassReferenced((Class)reference, referencedInTypes));
    }

    List<Class> getAllowedClasses() {
        return this.classesByName.values().stream().filter(this::isTypeAllowed).toList();
    }

    private void findExplicitClassesInModel() {
        GraphQlSchema graphQlSchema = this.ontology.getGraphQlSchema();
        boolean hasTypeDefinitions = !graphQlSchema.isEmpty();
        Set<Object> classesIris = new LinkedHashSet();
        if (!hasTypeDefinitions) {
            classesIris = this.dataAccess.findAllExplicitClasses(graphQlSchema, this.ontology);
        } else {
            Set relatedPublicShapes = this.dataAccess.findReferencedShaclNodes(graphQlSchema.getPublicShapes()).collect(Collectors.toSet());
            Set relatedProtectedShapes = this.dataAccess.findReferencedShaclNodes(graphQlSchema.getProtectedShapes()).collect(Collectors.toSet());
            Set publicShapes = this.dataAccess.findReferencedShaclNodes(graphQlSchema.getPublicClasses()).collect(Collectors.toSet());
            Set protectedShapes = this.dataAccess.findReferencedShaclNodes(graphQlSchema.getProtectedClasses()).collect(Collectors.toSet());
            Set relatedPublicTypes = this.dataAccess.findReferencedShaclTypes(graphQlSchema.getPublicShapes()).collect(Collectors.toSet());
            Set relatedProtectedTypes = this.dataAccess.findReferencedShaclTypes(graphQlSchema.getProtectedShapes()).collect(Collectors.toSet());
            graphQlSchema.getPublicShapes().addAll(relatedPublicShapes);
            graphQlSchema.getPublicShapes().addAll(publicShapes);
            graphQlSchema.getProtectedShapes().addAll(relatedProtectedShapes);
            graphQlSchema.getProtectedShapes().addAll(protectedShapes);
            graphQlSchema.getPublicClasses().addAll(relatedPublicTypes);
            graphQlSchema.getProtectedClasses().addAll(relatedProtectedTypes);
            classesIris.addAll(graphQlSchema.getPublicShapes());
            classesIris.addAll(graphQlSchema.getPublicClasses());
            classesIris.addAll(graphQlSchema.getProtectedShapes());
            classesIris.addAll(graphQlSchema.getProtectedClasses());
            classesIris.removeIf(iri -> graphQlSchema.getPrivateShapes().contains(iri));
            classesIris.removeIf(graphQlSchema.getPrivateShapes()::contains);
            classesIris.removeIf(this.dataAccess.getDeactivatedShapes()::contains);
        }
        this.classesByIri.putAll(classesIris.stream().collect(Collectors.toMap(iri -> iri, x$0 -> new Class((IRI)x$0))));
        Map<IRI, Set<IRI>> classToShapes = this.dataAccess.getTargetClassToShapes(classesIris);
        classToShapes.forEach((clazz, shapes) -> {
            Class type = this.getOrCreteClass((IRI)clazz);
            shapes.forEach(iri -> type.addShape(this.getOrCreteClass((IRI)iri)));
        });
    }

    private void createSuperClasses() {
        Map<Class, List<IRI>> classesWithParents = this.createChildParentsMap();
        while (!classesWithParents.isEmpty()) {
            Map<Class, List<IRI>> mostSignificantClasses = this.extractMostSignificantClasses(classesWithParents);
            for (Map.Entry<Class, List<IRI>> classParentsPair : mostSignificantClasses.entrySet()) {
                for (IRI parentId : classParentsPair.getValue()) {
                    Class subClass = classParentsPair.getKey();
                    if (this.dataAccess.isDeactivated((Resource)subClass.getIri())) continue;
                    subClass.addParent(this.resolveParentClass(parentId));
                }
            }
        }
    }

    private Map<Class, List<IRI>> extractMostSignificantClasses(Map<Class, List<IRI>> clasesWithParents) {
        Set children = clasesWithParents.keySet().stream().map(Class::getIri).collect(Collectors.toSet());
        HashMap<Class, List<IRI>> mostSignificant = new HashMap<Class, List<IRI>>();
        for (Map.Entry<Class, List<IRI>> pair : clasesWithParents.entrySet()) {
            if (!pair.getValue().stream().noneMatch(children::contains)) continue;
            mostSignificant.put(pair.getKey(), pair.getValue());
        }
        if (mostSignificant.isEmpty()) {
            mostSignificant.putAll(clasesWithParents);
            clasesWithParents.clear();
            return clasesWithParents;
        }
        mostSignificant.keySet().forEach(clasesWithParents::remove);
        return mostSignificant;
    }

    private Map<Class, List<IRI>> createChildParentsMap() {
        return this.classesByIri.values().stream().filter(concreteClass -> this.isTypeAllowed((Value)concreteClass.getIri())).filter(Class::hasParents).sorted(Comparator.comparing(Class::getShortIri)).collect(Collectors.toMap(Function.identity(), type -> new LinkedList<IRI>(type.getParentIris()), (iris, iris2) -> iris, LinkedHashMap::new));
    }

    private Class resolveParentClass(IRI parentId) {
        Class parent;
        Optional<Boolean> isInterfaceType = this.dataAccess.isInterfaceType((Resource)parentId);
        if (this.dataAccess.getConfig().getForceInterfaceTypes().booleanValue() && isInterfaceType.filter(Predicate.isEqual(Boolean.FALSE)).isEmpty() || !this.dataAccess.getConfig().getForceInterfaceTypes().booleanValue() && isInterfaceType.filter(Predicate.isEqual(Boolean.TRUE)).isPresent()) {
            parent = this.classesByIri.get(parentId);
            parent.setAbstract();
            this.createAbstractClassObject(parent);
            this.createConcreteClassObjects(parent);
        } else {
            IRI chosenParentInterfaceIri = this.namespaces.iri(this.dataAccess.gqlTypeName((Resource)parentId) + INTERFACE_SUFFIX);
            if (this.ontology.getGraphQlSchema().getPublicShapes().contains(parentId)) {
                this.ontology.getGraphQlSchema().getPublicShapes().add(chosenParentInterfaceIri);
            }
            if (this.ontology.getGraphQlSchema().getProtectedShapes().contains(parentId)) {
                this.ontology.getGraphQlSchema().getProtectedShapes().add(chosenParentInterfaceIri);
            }
            if (!this.classesByIri.containsKey(chosenParentInterfaceIri)) {
                this.createSuperClass(parentId, chosenParentInterfaceIri);
            }
            parent = this.classesByIri.get(chosenParentInterfaceIri);
        }
        return parent;
    }

    private void createSuperClass(IRI concreteClassIri, IRI classInterfaceIri) {
        Class concreteClass = this.classesByIri.computeIfAbsent(concreteClassIri, x$0 -> new Class((IRI)x$0));
        Class classInterface = new Class(classInterfaceIri);
        classInterface.setAbstract();
        classInterface.setDescription("Abstract superclass of " + this.dataAccess.gqlTypeName((Resource)concreteClassIri));
        concreteClass.getParents().forEach(classInterface::addParent);
        this.classesByIri.put(classInterface.getIri(), classInterface);
        concreteClass.overrideParents(classInterface);
        concreteClass.setSuperClass(classInterface);
        classInterface.setChildClass(concreteClass);
    }

    void extractAdditionalClassData() {
        for (Class classVal : this.values()) {
            if (classVal.isAbstract()) {
                this.createAbstractClassObject(classVal);
                continue;
            }
            this.createConcreteClassObjects(classVal);
        }
    }

    private void createConcreteClassObjects(Class clazz) {
        Optional<IRI> target = clazz.resolveTarget();
        if (target.isPresent()) {
            Class targetClass = this.get(target.get());
            if (targetClass != null && targetClass != clazz) {
                targetClass.setHidden();
            }
            clazz.setType(this.namespaces.shortIri(target.get().stringValue()));
        } else {
            clazz.setType(clazz.getShortIri());
        }
        this.dataAccess.getLabel((Resource)clazz.getIri()).ifPresent(clazz::setLabel);
        this.dataAccess.getDescription((Resource)clazz.getIri()).ifPresent(clazz::setDescription);
    }

    protected void createAbstractClassObject(Class clazz) {
        clazz.setKind("abstract");
    }

    Class getOrCreteClass(IRI classIri) {
        Class clazz = this.get(classIri);
        if (clazz == null) {
            clazz = this.add(classIri);
            this.createConcreteClassObjects(clazz);
        }
        return clazz;
    }

    public Optional<Class> getOrCreateMultiType(List<Class> ranges) {
        List<Class> parentClasses = this.validateAndSortTypes(ranges);
        if (parentClasses.isEmpty()) {
            return Optional.empty();
        }
        if (parentClasses.size() == 1) {
            return Optional.ofNullable(parentClasses.get(0));
        }
        String childName = parentClasses.stream().map(Class::getName).map(name -> Stream.of(name.split("[\\W]+")).filter(StringUtils::isNotBlank).map(StringUtils::capitalize).collect(Collectors.joining())).collect(Collectors.joining("And"));
        if (this.classesByName.containsKey(childName)) {
            return Optional.of(this.classesByName.get(childName));
        }
        List<Class> possibleMatches = this.classesByIri.values().stream().filter(type -> {
            List<Class> parents = type.getParents();
            return parents.size() == parentClasses.size() && new HashSet<Class>(parents).containsAll(parentClasses);
        }).toList();
        if (possibleMatches.isEmpty()) {
            Class child = new Class(this.namespaces.iri(this.namespaces.getVocabIri() + childName));
            parentClasses.forEach(child::addParent);
            child.gqlName = childName;
            this.classesByName.put(child.getName(), child);
            this.classesByIri.put(child.getIri(), child);
            if (parentClasses.stream().allMatch(Class::isPublic)) {
                this.ontology.getGraphQlSchema().getPublicShapes().add(child.getIri());
            } else {
                this.ontology.getGraphQlSchema().getProtectedShapes().add(child.getIri());
            }
            return Optional.of(child);
        }
        if (possibleMatches.size() == 1) {
            return Optional.of(possibleMatches.get(0));
        }
        this.messages.add(Message.warning("property.and.reference.ambiguous", possibleMatches, parentClasses, possibleMatches.get(0)));
        return Optional.of(possibleMatches.get(0));
    }

    public Optional<Class> getOrCreateUnionOf(List<Class> ranges) {
        List<Class> unionMemberClasses = this.validateAndSortTypes(ranges);
        if (unionMemberClasses.isEmpty()) {
            return Optional.empty();
        }
        if (unionMemberClasses.size() == 1) {
            return Optional.ofNullable(unionMemberClasses.getFirst());
        }
        String unionName = unionMemberClasses.stream().map(Class::getName).map(name -> Stream.of(name.split("[\\W]+")).filter(StringUtils::isNotBlank).map(StringUtils::capitalize).collect(Collectors.joining())).collect(Collectors.joining("Or"));
        if (this.classesByName.containsKey(unionName)) {
            return Optional.of(this.classesByName.get(unionName));
        }
        Class union = new Class(this.namespaces.iri(this.namespaces.getVocabIri() + unionName));
        union.unionOf = unionMemberClasses;
        union.kind = "union";
        union.gqlName = unionName;
        this.classesByName.put(union.getName(), union);
        this.classesByIri.put(union.getIri(), union);
        if (unionMemberClasses.stream().allMatch(Class::isPublic)) {
            this.ontology.getGraphQlSchema().getPublicShapes().add(union.getIri());
        } else {
            this.ontology.getGraphQlSchema().getProtectedShapes().add(union.getIri());
        }
        return Optional.of(union);
    }

    @NotNull
    private List<Class> validateAndSortTypes(List<Class> ranges) {
        return ranges.stream().filter(this::isTypeAllowed).sorted(Comparator.comparing(Class::getName)).toList();
    }

    boolean isTypeCompatibleWith(@NotNull Class type, String range) {
        if (range == null || "iri".equals(range) || "string".equals(range)) {
            return false;
        }
        if (type.getName().equals(range)) {
            return true;
        }
        if (type.isUnion() && type.getUnionOf().stream().anyMatch(member -> this.isTypeCompatibleWith((Class)member, range))) {
            return true;
        }
        return type.hasParent(range);
    }

    public AnonymousClass readAnonymousClass(Resource nodeIri) {
        AnonymousClass node = new AnonymousClass(this, nodeIri);
        this.dataAccess.readAnonymousClassMetadata(node, this.ontology);
        return node;
    }

    public void renameAllClasses(Function<Class, String> renameFunction) {
        LinkedHashMap copy = new LinkedHashMap();
        this.classesByName.forEach((name, type) -> {
            String newName = (String)renameFunction.apply((Class)type);
            if (!Objects.equals(name, newName)) {
                type.setGqlName(newName);
                copy.put(newName, type);
            } else {
                copy.put(name, type);
            }
        });
        this.classesByName.clear();
        this.classesByName.putAll(copy);
        this.classesByIri.values().forEach(type -> {
            String newName;
            String name = type.getName();
            if (!Objects.equals(name, newName = (String)renameFunction.apply((Class)type))) {
                type.setGqlName(newName);
            }
        });
    }

    boolean isTypeAllowed(Class type) {
        return this.isTypeAllowed((Value)type.getIri());
    }

    boolean isTypeAllowed(Value type) {
        return this.ontology.isTypeAllowed(type);
    }

    boolean isPrivate(Value value) {
        return this.ontology.isPrivate(value);
    }

    public class Class {
        private IRI iri;
        private String shortIri;
        private String gqlName;
        private String pattern;
        private String prefix;
        private String preferredNamespace;
        private boolean isAbstract = false;
        private List<Class> parents;
        private Class superClass;
        private Class childClass;
        private Map<String, Properties.Property> properties;
        private Boolean shaclShape;
        private IRI shaclTarget;
        private String kind;
        private Object type;
        private Object typeName;
        private String label;
        private String description;
        private String access;
        private Set<IRI> parentIris;
        private List<Class> unionOf;
        private Map<IRI, Class> shapes = new LinkedHashMap<IRI, Class>();
        private Set<Class> children = new LinkedHashSet<Class>();
        private Value sparqlFederatedService;
        private String serviceName;

        Class(IRI iri) {
            this.iri = iri;
            if (iri != null) {
                this.shortIri = Classes.this.namespaces.shortIri(iri.stringValue());
            }
            Classes.this.dataAccess.readClassMetadata(this, Classes.this.ontology);
        }

        private Class() {
            this.iri = null;
            this.shortIri = null;
        }

        public void setUnionOf(List<Value> unionList) {
            this.unionOf = unionList.stream().filter(Classes.this::isTypeAllowed).map(IRI.class::cast).map(Classes.this::getOrCreteClass).collect(Collectors.toList());
        }

        public void addUnionMember(Value unionMember) {
            if (this.unionOf == null) {
                this.unionOf = new ArrayList<Class>();
            }
            if (Classes.this.isTypeAllowed(unionMember)) {
                this.unionOf.add(Classes.this.getOrCreteClass((IRI)unionMember));
            }
        }

        Map<String, Object> toSomlObject() {
            Map<String, Properties.Property> allProps;
            LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
            if (this.unionOf != null) {
                Utils.putIfNotNull(object, "access", this.access);
                object.put("kind", "union");
                object.put("unionOf", this.unionOf.stream().map(Class::getName).toList());
                Utils.putIfNotNull(object, "label", this.label);
                Utils.putIfNotNull(object, "descr", this.description);
                return object;
            }
            if (this.parents != null) {
                List<Class> parentTypes = this.removeCovariantParents();
                if (parentTypes.size() == 1) {
                    object.put("inherits", parentTypes.get(0).getName());
                } else {
                    object.put("inherits", parentTypes.stream().map(Class::getName).sorted().toList());
                }
            }
            Utils.putIfNotNull(object, "access", this.access);
            Utils.putIfNotNull(object, "kind", this.kind);
            if (this.type instanceof String) {
                Utils.putIfNotNull(object, "type", this.type);
            } else if (this.type instanceof Set) {
                Utils.putIfNotNull(object, "type", new ArrayList((Set)this.type));
            }
            Utils.putIfNotNull(object, "label", this.label);
            Utils.putIfNotNull(object, "descr", this.description);
            Utils.putIfNotNull(object, "pattern", this.pattern);
            Utils.putIfNotNull(object, "prefix", this.prefix);
            Utils.putIfNotNull(object, "name", this.typeName);
            Utils.putIfNotNull(object, "sparqlFederatedService", this.getServiceName());
            if (StringUtils.isNotBlank((CharSequence)this.prefix) && StringUtils.isNotBlank((CharSequence)this.preferredNamespace) && Classes.this.namespaces.getPrefix(this.prefix).filter(Predicate.not(Predicate.isEqual(this.preferredNamespace))).isPresent() && !StringUtils.isNotBlank((CharSequence)this.pattern)) {
                Utils.putIfNotNull(object, "pattern", this.preferredNamespace + "${uuid()}");
            }
            if ((allProps = this.resolveProperties()) != null && !allProps.isEmpty()) {
                Map<String, Object> props = this.buildSomlProperties(allProps);
                object.put("props", props);
            }
            return object;
        }

        @NotNull
        private Map<String, Object> buildSomlProperties(Map<String, Properties.Property> allProps) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            boolean removeInvalidRanges = Boolean.TRUE.equals(Classes.this.dataAccess.getConfig().getRemoveUnknownRanges());
            allProps.values().stream().sorted().forEach(property -> {
                Class rangeClass;
                Class clazz = rangeClass = Objects.isNull(property.getRange()) ? null : Classes.this.classesByName.get(property.getRange());
                if (removeInvalidRanges && property.isObjectPropertyKind() && (Objects.isNull(rangeClass) || Classes.this.isPrivate((Value)rangeClass.getIri()))) {
                    String range = property.getRange();
                    property.setRange("iri");
                    props.put(property.getName(), property.somlObject());
                    property.setRange(range);
                } else {
                    props.put(property.getName(), property.somlObject());
                }
            });
            return props;
        }

        private List<Class> removeCovariantParents() {
            if (this.parents.size() <= 1) {
                return this.parents;
            }
            LinkedHashSet<Class> copy = new LinkedHashSet<Class>(this.parents);
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                Class next = (Class)it.next();
                if (!copy.stream().filter(clazz -> !clazz.getParents().isEmpty()).anyMatch(clazz -> clazz.getParents().stream().map(Class::getName).anyMatch(Predicate.isEqual(next.getName())))) continue;
                it.remove();
            }
            if (copy.isEmpty()) {
                throw new IllegalStateException("A type is a parent for itself: " + String.valueOf(this.parents));
            }
            return new ArrayList<Class>(copy);
        }

        Map<String, Properties.Property> resolveProperties() {
            if (this.shapes.isEmpty()) {
                return this.properties == null ? Map.of() : this.properties;
            }
            if (this.properties == null || this.properties.isEmpty()) {
                return this.shapes.values().stream().flatMap(clazz -> clazz.getProperties().stream()).collect(Collectors.toMap(Properties.Property::getName, Function.identity(), Properties::merge, LinkedHashMap::new));
            }
            return Stream.concat(this.properties.values().stream(), this.shapes.values().stream().flatMap(clazz -> clazz.getProperties().stream())).collect(Collectors.toMap(Properties.Property::getName, Function.identity(), Properties::merge, LinkedHashMap::new));
        }

        Map<IRI, Properties.Property> resolvePropertiesByIri() {
            if (this.shapes.isEmpty()) {
                return this.properties == null ? Map.of() : (Map)this.properties.values().stream().collect(Collectors.toMap(Properties.Property::getRdfPropIri, Function.identity(), Properties::merge, LinkedHashMap::new));
            }
            if (this.properties == null || this.properties.isEmpty()) {
                return this.shapes.values().stream().flatMap(clazz -> clazz.getProperties().stream()).collect(Collectors.toMap(Properties.Property::getRdfPropIri, Function.identity(), Properties::merge, LinkedHashMap::new));
            }
            return Stream.concat(this.properties.values().stream(), this.shapes.values().stream().flatMap(clazz -> clazz.getProperties().stream())).collect(Collectors.toMap(Properties.Property::getRdfPropIri, Function.identity(), Properties::merge, LinkedHashMap::new));
        }

        void renameAllProperties(Function<Properties.Property, String> nameFunction) {
            if (this.properties != null) {
                LinkedHashMap copy = new LinkedHashMap();
                this.properties.forEach((key, prop) -> {
                    String newName = (String)nameFunction.apply((Properties.Property)prop);
                    if (!Objects.equals(key, newName)) {
                        prop.setName(newName);
                        copy.put(newName, prop);
                    } else {
                        copy.put(key, prop);
                    }
                });
                this.properties.clear();
                this.properties.putAll(copy);
            }
            this.shapes.values().stream().filter(currentShape -> !currentShape.equals(this)).forEach(shape -> shape.renameAllProperties(nameFunction));
        }

        public IRI getIri() {
            return this.iri;
        }

        public String getShortIri() {
            return this.shortIri;
        }

        public String getName() {
            return this.gqlName;
        }

        public void setGqlName(String gqlName) {
            this.gqlName = gqlName;
        }

        @NotNull
        public List<Class> getParents() {
            if (this.parents == null) {
                return List.of();
            }
            return this.parents;
        }

        public boolean isRoot() {
            return this.parents == null && this.superClass == null;
        }

        boolean hasParent(IRI parentId) {
            if (this.parents != null) {
                return this.parents.stream().anyMatch(par -> par.getIri().equals((Object)parentId) || par.hasParent(parentId));
            }
            if (this.superClass != null) {
                return this.superClass.getIri().equals((Object)parentId) || this.superClass.hasParent(parentId);
            }
            return false;
        }

        boolean hasParent(String parentName) {
            if (this.parents != null) {
                return this.parents.stream().anyMatch(par -> par.getName().equals(parentName) || par.hasParent(parentName));
            }
            if (this.superClass != null) {
                return this.superClass.getName().equals(parentName) || this.superClass.hasParent(parentName);
            }
            return false;
        }

        void addParent(Class parent) {
            if (this.parents == null) {
                this.parents = new ArrayList<Class>();
            }
            if (parent != null) {
                this.parents.add(parent);
                parent.children.add(this);
            }
        }

        void removeParent(Class parent) {
            if (this.parents == null || parent == null) {
                return;
            }
            this.parents.remove(parent);
            if (this.parents.isEmpty()) {
                this.parents = null;
            }
            parent.children.remove(this);
        }

        void overrideParents(Class parent) {
            if (this.parents != null) {
                this.parents.forEach(p -> p.children.remove(this));
                this.parents.clear();
            }
            this.addParent(parent);
        }

        Class getSuperClass() {
            return this.superClass;
        }

        void setSuperClass(Class superClass) {
            this.superClass = superClass;
            if (superClass != null && this.shapes != null && !this.shapes.isEmpty()) {
                this.shapes.values().stream().filter(shape -> shape != this).forEach(shape -> shape.setSuperClass(superClass));
            }
        }

        public void setChildClass(Class childClass) {
            this.childClass = childClass;
        }

        public Class getChildClass() {
            return this.childClass;
        }

        boolean isAbstract() {
            return this.isAbstract;
        }

        void setAbstract() {
            this.isAbstract = true;
        }

        void addProperty(Properties.Property property) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Properties.Property>();
            }
            this.properties.put(property.getName(), property.addDomain(this));
        }

        Properties.Property getOrAddProperty(IRI propIri, Function<IRI, Properties.Property> supplier) {
            String propName;
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Properties.Property>();
            }
            if ((propName = Classes.this.dataAccess.gqlPropertyName((Resource)propIri)) == null) {
                Properties.Property property = supplier.apply(this.getIri());
                propName = property.getName();
            }
            return this.properties.computeIfAbsent(propName, key -> ((Properties.Property)supplier.apply(this.getIri())).addDomain(this));
        }

        Collection<Properties.Property> getProperties() {
            return this.properties != null ? this.properties.values() : Collections.emptyList();
        }

        boolean containsPropertyByName(String name) {
            if (this.isUnion()) {
                return this.getUnionOf().stream().anyMatch(member -> member.containsPropertyByName(name));
            }
            return this.resolveProperties().containsKey(name);
        }

        boolean hasTypeReferenceOf(String refName) {
            boolean hasDirectReference = this.resolveProperties().values().stream().filter(property -> !Classes.this.ontology.isProtectedProperty(property.getIri()) && !Classes.this.ontology.isProtectedProperty(property.getShaclIri())).anyMatch(property -> refName.equals(property.getRange()) || refName.equals(property.getPrimary().getRange()));
            if (hasDirectReference) {
                return true;
            }
            if (this.getSuperClass() != null && this.getSuperClass().hasTypeReferenceOf(refName)) {
                return true;
            }
            return this.parents != null && this.parents.stream().anyMatch(par -> par.hasTypeReferenceOf(refName));
        }

        boolean isShaclShape() {
            if (this.childClass != null) {
                return this.childClass.isShaclShape();
            }
            return Boolean.TRUE.equals(this.shaclShape);
        }

        public void setShaclShape(Boolean shaclShape) {
            this.shaclShape = shaclShape;
        }

        String getKind() {
            return this.kind;
        }

        void setKind(String kind) {
            this.kind = kind;
        }

        String getType() {
            Object object = this.type;
            if (object instanceof String) {
                String str = (String)object;
                return str;
            }
            if (this.type instanceof TreeSet) {
                return (String)((TreeSet)this.type).first();
            }
            return null;
        }

        Set<String> getTypes() {
            Object object = this.type;
            if (object instanceof String) {
                String str = (String)object;
                return Set.of(str);
            }
            if (this.type instanceof Set) {
                return (Set)this.type;
            }
            return Set.of();
        }

        void setType(String type) {
            if (this.type == null) {
                this.type = type;
            } else {
                String current;
                Object object = this.type;
                if (object instanceof String && !(current = (String)object).equals(type)) {
                    TreeSet<String> set = new TreeSet<String>();
                    set.add(current);
                    set.add(type);
                    this.type = set;
                } else if (this.type instanceof Set) {
                    ((Set)this.type).add(type);
                }
            }
        }

        public void setTypeName(Object typeName) {
            this.typeName = typeName;
        }

        public Object getTypeName() {
            return this.typeName;
        }

        String getLabel() {
            return this.label;
        }

        void setLabel(String label) {
            this.label = label;
        }

        String getDescription() {
            return this.description;
        }

        void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            return this.gqlName;
        }

        public Optional<IRI> resolveTarget() {
            return Optional.ofNullable(this.shaclTarget);
        }

        public void setShaclTarget(IRI shaclTarget) {
            this.shaclTarget = shaclTarget;
        }

        boolean hasParents() {
            return !this.getParentIris().isEmpty();
        }

        Set<IRI> getParentIris() {
            if (this.parentIris == null) {
                return Set.of();
            }
            return this.parentIris;
        }

        public void setParentIris(Collection<IRI> parents) {
            this.parentIris = new LinkedHashSet<IRI>(parents);
        }

        public void addParentIri(IRI parent) {
            if (this.getIri() != null && this.getIri().equals((Object)parent)) {
                return;
            }
            if (this.parentIris == null) {
                this.parentIris = new LinkedHashSet<IRI>();
            }
            this.parentIris.add(parent);
        }

        Stream<Class> getRoot() {
            if (this.parents != null) {
                return this.parents.stream().flatMap(Class::getRoot);
            }
            if (this.superClass != null) {
                return this.superClass.getRoot();
            }
            return Stream.of(this);
        }

        void setProtected() {
            this.access = "none";
        }

        public String getPrefix() {
            return this.prefix;
        }

        Optional<String> getPreferredNamespace() {
            if (this.prefix == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.preferredNamespace);
        }

        public void setPreferredNamespace(String preferredNamespace) {
            this.preferredNamespace = preferredNamespace;
        }

        public boolean isPublic() {
            return this.access == null;
        }

        public boolean isProtected() {
            return "none".equals(this.access);
        }

        public void setHidden() {
            Classes.this.ontology.getGraphQlSchema().getPrivateShapes().add(this.getIri());
        }

        public boolean isUnion() {
            return this.unionOf != null && !this.unionOf.isEmpty();
        }

        public List<Class> getUnionOf() {
            return this.unionOf;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        void addShape(Class shape) {
            this.shapes.put(shape.getIri(), shape);
            if (shape.shaclTarget != null && !shape.shaclTarget.equals((Object)this.getIri())) {
                throw new IllegalStateException("Found different targets for shape " + String.valueOf(shape.getIri()) + " extected: " + String.valueOf(this.getIri()) + " actual: " + String.valueOf(shape.shaclTarget));
            }
            shape.setShaclTarget(this.getIri());
        }

        public boolean hasShape(IRI iri) {
            return this.shapes.containsKey(iri);
        }

        public void sortParents() {
            if (this.parents != null && !this.parents.isEmpty()) {
                this.parents.sort(Comparator.comparing(val -> Classes.this.namespaces.shortIri(val.toString())));
            }
        }

        public Set<Class> getChildren() {
            return this.children;
        }

        public Collection<Class> getShapes() {
            return this.shapes.values();
        }

        public Set<IRI> getShapeIris() {
            return this.shapes.keySet();
        }

        public Value getSparqlFederatedService() {
            if (this.sparqlFederatedService == null && !this.shapes.isEmpty()) {
                return this.shapes.values().stream().filter(shape -> shape != this).map(Class::getSparqlFederatedService).filter(Objects::nonNull).findFirst().orElse(null);
            }
            return this.sparqlFederatedService;
        }

        public void setSparqlFederatedService(Value sparqlFederatedService) {
            this.sparqlFederatedService = sparqlFederatedService;
        }

        public String getServiceName() {
            if (this.serviceName == null && !this.shapes.isEmpty()) {
                return this.shapes.values().stream().filter(shape -> shape != this).map(Class::getServiceName).filter(Objects::nonNull).findFirst().orElse(null);
            }
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }
    }

    public class AnonymousClass
    extends Class {
        private final Resource identifier;

        AnonymousClass(Classes this$0, Resource identifier) {
            this.identifier = identifier;
            this$0.dataAccess.readClassMetadata(this, this$0.ontology);
        }

        public Resource getIdentifier() {
            return this.identifier;
        }
    }
}

