/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.ontotext.graphdb.jdbc.GraphDBSchemaFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;

public class RepositoryManagerModelProperties
extends Properties {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final LocalRepositoryManager repositoryManager;
    private final Predicate<String> accessChecker;
    private String flavor;

    public RepositoryManagerModelProperties(LocalRepositoryManager repositoryManager, Predicate<String> accessChecker) {
        this.repositoryManager = repositoryManager;
        this.accessChecker = accessChecker;
        this.put("repositoryManager", repositoryManager);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return Collections.enumeration(Sets.union(Collections.singleton("model"), this.keySet()));
    }

    @Override
    public Set<String> stringPropertyNames() {
        return Sets.union(Collections.singleton("model"), super.stringPropertyNames());
    }

    @Override
    public String getProperty(String key) {
        if ("model".equals(key)) {
            return this.generateModel();
        }
        return super.getProperty(key);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Sets.union(Collections.singleton(new AbstractMap.SimpleImmutableEntry<String, String>("model", this.generateModel())), super.entrySet());
    }

    @VisibleForTesting
    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    private String generateModel() {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put("version", "1.0");
        ArrayList<Map<String, Object>> schemas = new ArrayList<Map<String, Object>>();
        model.put("schemas", schemas);
        try {
            for (String repositoryId : this.repositoryManager.getRepositoryIDs()) {
                if (!this.accessChecker.test(repositoryId)) continue;
                schemas.add(this.repoToSchema(repositoryId));
            }
            return "inline:" + this.objectMapper.writeValueAsString(model);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private Map<String, Object> repoToSchema(String repoId) {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("name", repoId.toUpperCase());
        schema.put("type", "custom");
        schema.put("factory", GraphDBSchemaFactory.class.getName());
        LinkedHashMap<String, String> operand = new LinkedHashMap<String, String>();
        schema.put("operand", operand);
        operand.put("repository", repoId);
        if (this.flavor != null) {
            operand.put("flavor", this.flavor);
        }
        return schema;
    }
}

