/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.google.common.collect.ImmutableMap;
import com.ontotext.graphdb.jdbc.GraphDBTable;
import com.ontotext.graphdb.jdbc.GraphDBWritableTable;
import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.graphdb.statistics.models.Jdbc;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.eclipse.rdf4j.repository.Repository;

class GraphDBSchema
extends AbstractSchema {
    private final Repository repository;
    private final GraphDBTable.Flavor flavor;
    private Map<String, Table> tableMap;

    GraphDBSchema(Repository repository, GraphDBTable.Flavor flavor) {
        Objects.requireNonNull(repository, "Repository must be specified");
        this.repository = repository;
        this.flavor = flavor;
        if (repository instanceof MonitorRepository) {
            StatisticsListener statisticListener = ((MonitorRepository)repository).getOwlimSail().getStatistics();
            statisticListener.setJdbcStatisticsUpdater(this::updateJdbcData);
        }
    }

    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            try {
                this.tableMap = this.createTableMap();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.tableMap;
    }

    private Map<String, Table> createTableMap() throws Exception {
        File directoryFile = new File(this.repository.getDataDir(), "sql");
        Source baseSource = Sources.of((File)directoryFile);
        File[] files = directoryFile.listFiles((dir, name) -> name.endsWith(".rq"));
        if (files == null) {
            files = new File[]{};
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File file : files) {
            Source source = Sources.of((File)file);
            Source sourceSansRq = source.trimOrNull(".rq");
            if (sourceSansRq == null) continue;
            Table table = this.createTable(source);
            String tableName = sourceSansRq.relative(baseSource).path().toUpperCase();
            builder.put((Object)tableName, (Object)table);
        }
        return builder.build();
    }

    private Table createTable(Source source) throws Exception {
        switch (this.flavor) {
            case WRITABLE: {
                return new GraphDBWritableTable(source, null, this.repository);
            }
            case READABLE: {
                return new GraphDBTable(source, null, this.repository);
            }
        }
        throw new IllegalStateException("Unknown flavor " + String.valueOf((Object)this.flavor));
    }

    private void updateJdbcData(StatisticsListener statistics) {
        Jdbc jdbcData = statistics.getRepositoryStatistics().getOperations().getJdbc();
        if (!this.getTableMap().isEmpty()) {
            jdbcData.setViews((long)this.getTableMap().size());
            int totalColumns = this.getTableMap().values().stream().filter(GraphDBTable.class::isInstance).map(GraphDBTable.class::cast).mapToInt(graphDBTable -> graphDBTable.getMetadata().getColumns().size()).sum();
            jdbcData.setColumns((long)totalColumns);
        }
    }
}

