/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public enum GraphDBFieldType {
    STRING(String.class, "string", XSD.STRING, 1000, -1, true),
    IRI(String.class, "iri", XSD.STRING, 500, -1, false),
    CHAR(Primitive.CHAR, XSD.STRING),
    BOOLEAN(Primitive.BOOLEAN, XSD.BOOLEAN),
    BYTE(Primitive.BYTE, XSD.BYTE),
    SHORT(Primitive.SHORT, XSD.SHORT),
    INT(Primitive.INT, XSD.INT),
    LONG(Primitive.LONG, XSD.LONG),
    FLOAT(Primitive.FLOAT, XSD.FLOAT),
    DOUBLE(Primitive.DOUBLE, XSD.DOUBLE),
    DECIMAL(BigDecimal.class, "decimal", XSD.DECIMAL, 19, 0, false),
    DATE(Date.class, "date", XSD.DATE),
    TIME(Time.class, "time", XSD.TIME),
    TIMESTAMP(Timestamp.class, "timestamp", XSD.DATETIME);

    private final Class<?> clazz;
    private final String simpleName;
    private final IRI defaultSparqlType;
    private final boolean hasLanguageTag;
    private final int precision;
    private final int scale;
    private static final Map<String, GraphDBFieldType> MAP;

    private GraphDBFieldType(Primitive primitive, IRI defaultSparqlType) {
        this(primitive.boxClass, primitive.primitiveName, defaultSparqlType);
    }

    private GraphDBFieldType(Class<?> clazz, String simpleName, IRI defaultSparqlType) {
        this(clazz, simpleName, defaultSparqlType, -1, -1, false);
    }

    private GraphDBFieldType(Class<?> clazz, String simpleName, IRI defaultSparqlType, int precision, int scale, boolean hasLanguageTag) {
        this.clazz = clazz;
        this.simpleName = simpleName;
        this.defaultSparqlType = defaultSparqlType;
        this.precision = precision;
        this.scale = scale;
        this.hasLanguageTag = hasLanguageTag;
    }

    public RelDataType toType(JavaTypeFactory typeFactory, boolean nullable, int precision, int scale) {
        RelDataType javaType = typeFactory.createJavaType(this.clazz);
        SqlTypeName sqlTypeName = javaType.getSqlTypeName();
        if (precision == -1) {
            precision = this.precision;
        }
        if (scale == -1) {
            scale = this.scale;
        }
        RelDataType sqlType = precision > -1 ? (scale > -1 ? typeFactory.createSqlType(sqlTypeName, precision, scale) : typeFactory.createSqlType(sqlTypeName, precision)) : typeFactory.createSqlType(sqlTypeName);
        return typeFactory.createTypeWithNullability(sqlType, nullable);
    }

    public static GraphDBFieldType of(String typeString) {
        return MAP.get(typeString);
    }

    public boolean hasPrecision() {
        return this.precision != -1;
    }

    public boolean hasScale() {
        return this.scale != -1;
    }

    public boolean hasLanguageTag() {
        return this.hasLanguageTag;
    }

    public boolean hasSparqlType() {
        return !this.simpleName.equals("iri");
    }

    public IRI getDefaultSparqlType() {
        return this.defaultSparqlType;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    static {
        MAP = new HashMap<String, GraphDBFieldType>();
        for (GraphDBFieldType value : GraphDBFieldType.values()) {
            MAP.put(value.simpleName, value);
        }
    }
}

