/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.externalsync;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.graphdb.Config;
import jakarta.inject.Named;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class ConnectorsManager {
    private static final String ENTITY_CHANGE_SKIP_PROPERTY = "graphdb.workbench.show-entity-change";
    @Autowired
    private SemanticDataManagement dataManagement;
    private final boolean showEntityChange;
    private Log logger = LogFactory.getLog(ConnectorsManager.class);

    public ConnectorsManager() {
        this.showEntityChange = Config.getPropertyAsBoolean((String)ENTITY_CHANGE_SKIP_PROPERTY, (boolean)false);
    }

    public Map<String, String> getConnectorTypeAndPrefix() throws GraphDBWorkbenchException {
        String query = "select ?name ?prefix { ?prefix <http://www.ontotext.com/connectors#discover> ?name }";
        return (Map)new SemanticRepository.WithConnection<Map<String, String>>(this.dataManagement.getCurrentRepositoryOrThrow()){

            protected Map<String, String> doInConnection() throws RepositoryException {
                ArrayList<AbstractMap.SimpleEntry<String, String>> connectorTypes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                HashMap<String, Integer> order = new HashMap<String, Integer>();
                try {
                    TupleQueryResult result = this.prepareAndEvaluate("select ?name ?prefix { ?prefix <http://www.ontotext.com/connectors#discover> ?name }");
                    while (result.hasNext()) {
                        BindingSet bindingSet = (BindingSet)result.next();
                        String name = bindingSet.getBinding("name").getValue().stringValue();
                        if (!ConnectorsManager.this.isShowEntityChange() && name.equals("Entity-Change")) continue;
                        String prefix = bindingSet.getBinding("prefix").getValue().toString();
                        connectorTypes.add(new AbstractMap.SimpleEntry<String, String>(name, prefix));
                        Map<String, Object> metadata = ConnectorsManager.this.getConnectorMetadata(prefix);
                        order.put(name, (Integer)metadata.get("order"));
                    }
                    return connectorTypes.stream().sorted(Comparator.comparingInt(a -> (Integer)order.get(a.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
            }
        }.run();
    }

    public List<String> getConnectorsNames(String prefix) throws GraphDBWorkbenchException {
        if (!StringUtils.isEmpty((CharSequence)prefix)) {
            final String query = "PREFIX prefix: <" + prefix + ">SELECT ?uri ?name WHERE {?uri prefix:listConnectors ?name}";
            SemanticRepository semanticRepository = this.dataManagement.getCurrentRepositoryOrThrow();
            Objects.requireNonNull(semanticRepository);
            return (List)new SemanticRepository.WithConnection<List<String>>(this, semanticRepository){

                protected List<String> doInConnection() throws RepositoryException {
                    ArrayList<String> connectorNames = new ArrayList<String>();
                    try {
                        TupleQueryResult result = this.prepareAndEvaluate(query);
                        while (result.hasNext()) {
                            BindingSet bindingSet = (BindingSet)result.next();
                            String name = bindingSet.getBinding("name").getValue().stringValue();
                            connectorNames.add(name);
                        }
                        return connectorNames;
                    }
                    catch (MalformedQueryException | QueryEvaluationException e) {
                        throw new RepositoryException(e);
                    }
                }
            }.run();
        }
        return new ArrayList<String>();
    }

    public List<JSONObject> getConnectorFields(final String prefix) throws GraphDBWorkbenchException {
        if (!StringUtils.isEmpty((CharSequence)prefix)) {
            final String query = "select ?options where {<" + prefix + "> <http://www.ontotext.com/connectors#options> ?options .}";
            SemanticRepository semanticRepository = this.dataManagement.getCurrentRepositoryOrThrow();
            Objects.requireNonNull(semanticRepository);
            return (List)new SemanticRepository.WithConnection<List<JSONObject>>(semanticRepository){

                protected List<JSONObject> doInConnection() throws RepositoryException {
                    try {
                        TupleQueryResult result = this.prepareAndEvaluate(query);
                        if (result.hasNext()) {
                            String optString = ((BindingSet)result.next()).getBinding("options").getValue().toString();
                            return (JSONArray)new JSONParser().parse(StringUtils.strip((String)optString, (String)"\""));
                        }
                        ConnectorsManager.this.logger.warn((Object)("Connectors discovery did not find connector options for " + prefix));
                    }
                    catch (MalformedQueryException | QueryEvaluationException | ParseException e) {
                        throw new RepositoryException(e);
                    }
                    return new LinkedList<JSONObject>();
                }
            }.run();
        }
        return new LinkedList<JSONObject>();
    }

    public JSONObject getConnectorFieldValues(final String prefix, String name) throws GraphDBWorkbenchException {
        String namePrefix = prefix.replace("#", "/instance#");
        final String query = "PREFIX prefix: <" + prefix + ">SELECT ?options WHERE {<" + namePrefix + name + "> prefix:listOptionValues ?options}";
        SemanticRepository semanticRepository = this.dataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (JSONObject)new SemanticRepository.WithConnection<JSONObject>(semanticRepository){

            protected JSONObject doInConnection() throws RepositoryException {
                try {
                    TupleQueryResult result = this.prepareAndEvaluate(query);
                    if (result.hasNext()) {
                        return (JSONObject)new JSONParser().parse(((BindingSet)result.next()).getBinding("options").getValue().stringValue());
                    }
                    ConnectorsManager.this.logger.warn((Object)("Connectors discovery did not find connector options for " + prefix));
                }
                catch (MalformedQueryException | QueryEvaluationException | ParseException e) {
                    throw new RepositoryException(e);
                }
                return new JSONObject();
            }
        }.run();
    }

    public Map<String, Object> getConnectorMetadata(String connectorPrefix) throws GraphDBWorkbenchException {
        String pluginName;
        int order = 100;
        String connectorName = switch (connectorPrefix) {
            case "http://www.ontotext.com/connectors/lucene#" -> {
                order = 40;
                pluginName = "lucene-connector";
                yield "Lucene";
            }
            case "http://www.ontotext.com/connectors/solr#" -> {
                order = 30;
                pluginName = "solr-connector";
                yield "Solr";
            }
            case "http://www.ontotext.com/connectors/elasticsearch#" -> {
                order = 10;
                pluginName = "elasticsearch-connector";
                yield "Elasticsearch";
            }
            case "http://www.ontotext.com/connectors/opensearch#" -> {
                order = 20;
                pluginName = "opensearch-connector";
                yield "OpenSearch";
            }
            case "http://www.ontotext.com/connectors/kafka#" -> {
                order = 50;
                pluginName = "kafka-connector";
                yield "Kafka";
            }
            case "http://www.ontotext.com/connectors/retrieval#" -> {
                order = 80;
                pluginName = "chatgpt-retrieval-connector";
                yield "ChatGPT Retrieval";
            }
            case "http://www.ontotext.com/connectors/entity-change#" -> {
                pluginName = "entity-change";
                yield "Entity-Change";
            }
            default -> {
                pluginName = "unknown-connector";
                yield "Unknown;";
            }
        };
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("pluginName", pluginName);
        result.put("connectorName", connectorName);
        result.put("order", order);
        return result;
    }

    public Map<String, Object> getConnectorSupport(String connectorPrefix) throws GraphDBWorkbenchException {
        Map<String, Object> metadata = this.getConnectorMetadata(connectorPrefix);
        final String query = String.format("ask { ?p <http://www.ontotext.com/owlim/system#listplugins> ?s .  filter(str(?p) = \"%s\" && ?s) }", metadata.get("pluginName"));
        SemanticRepository semanticRepository = this.dataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        boolean hasSupport = (Boolean)new SemanticRepository.WithConnection<Boolean>(this, semanticRepository){

            protected Boolean doInConnection() throws RepositoryException {
                return this.prepareAndEvaluateBoolean(query);
            }
        }.run();
        metadata.put("hasSupport", hasSupport);
        return metadata;
    }

    @VisibleForTesting
    boolean isShowEntityChange() {
        return this.showEntityChange;
    }
}

