/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.factplusplusad.BotEquivalenceEvaluator;
import uk.ac.manchester.cs.factplusplusad.SigAccessor;
import uk.ac.manchester.cs.factplusplusad.Signature;

class TopEquivalenceEvaluator
extends SigAccessor
implements OWLObjectVisitor {
    BotEquivalenceEvaluator botEval;
    boolean isTopEq = false;

    TopEquivalenceEvaluator(Signature s) {
        super(s);
    }

    boolean isBotEquivalent(OWLObject expr) {
        return this.botEval.isBotEquivalent(expr);
    }

    private boolean isBotDistinct(OWLObject c) {
        if (this.isTopEquivalent(c)) {
            return true;
        }
        return c instanceof OWLDatatype;
    }

    private boolean isCardLargerThan(OWLObject c, int n) {
        OWLDatatype dt;
        if (n == 0) {
            return this.isBotDistinct(c);
        }
        if (c instanceof OWLDataRange && this.isTopEquivalent(c)) {
            return true;
        }
        return c instanceof OWLDatatype && (OWL2Datatype.XSD_STRING.matches((OWLEntity)(dt = ((OWLDatatype)c).asOWLDatatype())) || OWL2Datatype.XSD_DATE_TIME.matches((OWLEntity)dt) || OWL2Datatype.XSD_DATE_TIME_STAMP.matches((OWLEntity)dt));
    }

    private boolean isMinTopEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return n == 0 || this.isTopEquivalent((OWLObject)r) && this.isCardLargerThan((OWLObject)c, n - 1);
    }

    private boolean isMaxTopEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return this.isBotEquivalent((OWLObject)r) || this.isBotEquivalent((OWLObject)c);
    }

    void setBotEval(BotEquivalenceEvaluator eval) {
        this.botEval = eval;
    }

    public boolean isTopEquivalent(OWLObject expr) {
        if (expr.isTopEntity()) {
            return true;
        }
        if (expr.isBottomEntity()) {
            return false;
        }
        expr.accept((OWLObjectVisitor)this);
        return this.isTopEq;
    }

    public void visit(OWLClass expr) {
        this.isTopEq = this.topCLocal() && this.nc((OWLEntity)expr);
    }

    public void visit(OWLObjectComplementOf expr) {
        this.isTopEq = this.isBotEquivalent((OWLObject)expr.getOperand());
    }

    public void visit(OWLObjectIntersectionOf expr) {
        this.isTopEq = !expr.operands().anyMatch(p -> !this.isTopEquivalent((OWLObject)p));
    }

    public void visit(OWLObjectUnionOf expr) {
        this.isTopEq = expr.operands().anyMatch(this::isTopEquivalent);
    }

    public void visit(OWLObjectOneOf expr) {
        this.isTopEq = false;
    }

    public void visit(OWLObjectHasSelf expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectHasValue expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectSomeValuesFrom expr) {
        this.isTopEq = this.isMinTopEquivalent(1, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectAllValuesFrom expr) {
        this.isTopEq = this.isTopEquivalent(expr.getFiller()) || this.isBotEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectMinCardinality expr) {
        this.isTopEq = this.isMinTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectMaxCardinality expr) {
        this.isTopEq = this.isMaxTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectExactCardinality expr) {
        int n = expr.getCardinality();
        this.isTopEq = this.isMinTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller()) && this.isMaxTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataHasValue expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLDataSomeValuesFrom expr) {
        this.isTopEq = this.isMinTopEquivalent(1, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataAllValuesFrom expr) {
        this.isTopEq = this.isTopEquivalent(expr.getFiller()) || this.isBotEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLDataMinCardinality expr) {
        this.isTopEq = this.isMinTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataMaxCardinality expr) {
        this.isTopEq = this.isMaxTopEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataExactCardinality expr) {
        int n = expr.getCardinality();
        this.isTopEq = this.isMinTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller()) && this.isMaxTopEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectProperty expr) {
        this.isTopEq = this.topRLocal() && this.nc((OWLEntity)expr);
    }

    public void visit(OWLObjectInverseOf expr) {
        this.isTopEq = this.isTopEquivalent((OWLObject)expr.getInverse());
    }

    public void visit(OWLSubPropertyChainOfAxiom expr) {
        this.isTopEq = false;
        for (OWLObjectPropertyExpression p : expr.getPropertyChain()) {
            if (this.isTopEquivalent((OWLObject)p)) continue;
            return;
        }
        this.isTopEq = true;
    }

    public void visit(OWLDataProperty expr) {
        this.isTopEq = this.topRLocal() && this.nc((OWLEntity)expr);
    }

    public void visit(OWLDatatype node) {
        this.isTopEq = node.isTopDatatype();
    }

    public void visit(OWLLiteral node) {
        this.isTopEq = false;
    }

    public void visit(OWLDataComplementOf node) {
        this.isTopEq = this.isBotEquivalent((OWLObject)node.getDataRange());
    }

    public void visit(OWLDatatypeRestriction node) {
        this.isTopEq = node.isTopDatatype();
    }

    public void visit(OWLDataOneOf node) {
        this.isTopEq = false;
    }

    public void visit(OWLDataIntersectionOf expr) {
        this.isTopEq = expr.operands().anyMatch(p -> !this.isTopEquivalent((OWLObject)p));
    }

    public void visit(OWLDataUnionOf expr) {
        this.isTopEq = expr.operands().anyMatch(this::isTopEquivalent);
    }
}

