/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class DefinitionTracker
implements OWLOntologyChangeListener {
    private final Map<OWLEntity, AtomicInteger> referenceCounts = new HashMap<OWLEntity, AtomicInteger>();
    private final OWLOntology ontology;
    private final Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();

    public DefinitionTracker(OWLOntology ontology) {
        this.ontology = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        ontology.importsClosure().flatMap(HasAxioms::axioms).forEach(this::addAxiom);
        ontology.getOWLOntologyManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    private void addAxiom(OWLAxiom axiom) {
        if (this.axioms.add(axiom)) {
            axiom.signature().forEach(e -> this.referenceCounts.computeIfAbsent((OWLEntity)e, x -> new AtomicInteger(0)).incrementAndGet());
        }
    }

    private void removeAxiom(OWLAxiom axiom) {
        if (this.axioms.remove(axiom)) {
            axiom.signature().forEach(e -> {
                AtomicInteger count = this.referenceCounts.get(e);
                if (count != null && count.decrementAndGet() == 0) {
                    this.referenceCounts.remove(e);
                }
            });
        }
    }

    public boolean isDefined(OWLEntity entity) {
        return ((OWLEntity)OWLAPIPreconditions.checkNotNull((Object)entity, (String)"entity cannot be null")).isBuiltIn() || this.referenceCounts.containsKey(entity);
    }

    public boolean isDefined(OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        return !classExpression.signature().anyMatch(e -> !this.isDefined((OWLEntity)e));
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !OWLAPIStreamUtils.contains((Stream)this.ontology.importsClosure(), (Object)oWLOntologyChange.getOntology())) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange.isAddAxiom()) {
                this.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange.isRemoveAxiom()) {
                this.removeAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + String.valueOf(oWLOntologyChange));
        }
    }
}

