/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDBConnectorAdminHandler
extends CoreAdminHandler {
    static final String CORE_FROM = "coreFrom";
    protected static Logger log = LoggerFactory.getLogger(GraphDBConnectorAdminHandler.class);

    public GraphDBConnectorAdminHandler() {
    }

    public GraphDBConnectorAdminHandler(CoreContainer coreContainer) {
        super(coreContainer);
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String action = req.getParams().get("action");
        if ("create".equalsIgnoreCase(action)) {
            String coreFrom = req.getParams().get(CORE_FROM);
            String name = req.getParams().get("name");
            if (name != null && coreFrom != null) {
                Path instanceDir = this.coreContainer.getCoreRootDirectory().resolve(name);
                CoreDescriptor otherCore = this.coreContainer.getCoreDescriptor(coreFrom);
                if (otherCore != null) {
                    Path srcDir = otherCore.getInstanceDir();
                    try {
                        FileUtils.copyDirectory((File)srcDir.toFile(), (File)instanceDir.toFile(), pathname -> !pathname.getName().endsWith("core.properties") && !pathname.getName().equals("data"));
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not copy srcDir : " + srcDir + " to : " + instanceDir + ".", (Throwable)e);
                    }
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core " + coreFrom + " does not exist.");
                }
            }
        }
        super.handleRequestBody(req, rsp);
    }
}

