/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.security;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.security.TlsContext;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.jsse.JSSEUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String GRAPHDB_RAFT_SECURITY_MODE = "graphdb.raft.security.mode";
    public static final String GRAPHDB_RAFT_SECURITY_OPENSSL_CERT_CHAIN = "graphdb.raft.security.certificateChainFile";
    public static final String GRAPHDB_RAFT_SECURITY_OPENSSL_CERT_FILE = "graphdb.raft.security.certificateFile";
    public static final String GRAPHDB_RAFT_SECURITY_OPENSSL_PRIVATE_KEY = "graphdb.raft.security.certificateKeyFile";
    public static final String GRAPHDB_RAFT_SECURITY_PRIVATE_KEY_PASSWORD = "graphdb.raft.security.certificateKeyPassword";
    public static final String GRAPHDB_RAFT_SECURITY_CERTIFICATE_REVOCATION_LIST_FILE = "graphdb.raft.security.certificateRevocationListFile";
    public static final String GRAPHDB_RAFT_SECURITY_CERTIFICATE_VERIFICATION = "graphdb.raft.security.certificateVerification";
    public static final String GRAPHDB_RAFT_SECURITY_JSSE_ALGORITHM = "graphdb.raft.security.algorithm";
    public static final String GRAPHDB_RAFT_SECURITY_JSSE_KEY_ALIAS = "graphdb.raft.security.keyAlias";
    public static final String GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE = "graphdb.raft.security.keystoreFile";
    public static final String GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE_PASS = "graphdb.raft.security.keystorePass";
    public static final String GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE_PROVIDER = "graphdb.raft.security.keystoreProvider";
    public static final String GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE_TYPE = "graphdb.raft.security.keystoreType";
    public static final String GRAPHDB_RAFT_SECURITY_TRUST_STORE = "graphdb.raft.security.truststoreFile";
    public static final String GRAPHDB_RAFT_SECURITY_TRUST_STORE_PASS = "graphdb.raft.security.truststorePass";
    public static final String GRAPHDB_RAFT_SECURITY_TRUST_STORE_PROVIDER = "graphdb.raft.security.truststoreProvider";
    public static final String GRAPHDB_RAFT_SECURITY_TRUST_STORE_TYPE = "graphdb.raft.security.truststoreType";
    public static final String GRAPHDB_RAFT_SECURITY_ROOT_CERTS = "graphdb.raft.security.rootCerts";
    public static final String MDC_HEADERS_KEY = "headers";
    public static final SecurityConfig INSTANCE = new SecurityConfig();
    private SecurityMode mode = SecurityMode.parse(Config.getProperty((String)"graphdb.raft.security.mode"));
    private final String truststoreFile;
    private final String truststoreProvider;
    private final String truststoreType;
    private final String keyManagerAlgorithm;
    private final String certificateKeyAlias;
    private final String certificateKeystoreFile;
    private final String certificateKeystoreProvider;
    private final String certificateKeystoreType;
    private final String certChainPath;
    private final String certFile;
    private final String privateKeyPath;
    private final String certificateRevocationListFile = Config.getProperty((String)"graphdb.raft.security.certificateRevocationListFile", (String)Config.getProperty((String)"graphdb.connector.certificateRevocationListFile", (String)Config.getProperty((String)"graphdb.connector.SSLCARevocationFile")));
    private final String certificateVerification = Config.getProperty((String)"graphdb.raft.security.certificateVerification", (String)Config.getProperty((String)"graphdb.connector.certificateVerification", (String)Config.getProperty((String)"graphdb.connector.clientAuth")));
    private final String rootCertsPath;
    private TlsContext tlsContext;
    private X509Certificate[] certificate;

    @VisibleForTesting
    public SecurityConfig() {
        this.certChainPath = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_OPENSSL_CERT_CHAIN, (String)Config.getProperty((String)"graphdb.connector.certificateChainFile"));
        this.certFile = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_OPENSSL_CERT_FILE, (String)Config.getProperty((String)"graphdb.connector.certificateFile", (String)Config.getProperty((String)"graphdb.connector.SSLCertificateFile", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateFile"))));
        this.privateKeyPath = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_OPENSSL_PRIVATE_KEY, (String)Config.getProperty((String)"graphdb.connector.certificateKeyFile", (String)Config.getProperty((String)"graphdb.connector.SSLCertificateKeyFile", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeyFile"))));
        this.keyManagerAlgorithm = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_JSSE_ALGORITHM, (String)Config.getProperty((String)"graphdb.connector.algorithm"));
        this.certificateKeyAlias = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_JSSE_KEY_ALIAS, (String)Config.getProperty((String)"graphdb.connector.keyAlias", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeyAlias")));
        this.certificateKeystoreFile = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE, (String)Config.getProperty((String)"graphdb.connector.keystoreFile", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeystoreFile")));
        this.certificateKeystoreProvider = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE_PROVIDER, (String)Config.getProperty((String)"graphdb.connector.keystoreProvider", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeystoreProvider")));
        this.certificateKeystoreType = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE_TYPE, (String)Config.getProperty((String)"graphdb.connector.keystoreType", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeystoreType")));
        this.truststoreFile = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_TRUST_STORE, (String)Config.getProperty((String)"graphdb.connector.truststoreFile"));
        this.truststoreProvider = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_TRUST_STORE_PROVIDER, (String)Config.getProperty((String)"graphdb.connector.truststoreProvider"));
        this.truststoreType = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_TRUST_STORE_TYPE, (String)Config.getProperty((String)"graphdb.connector.truststoreType"));
        this.rootCertsPath = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_ROOT_CERTS);
    }

    public boolean isSecurityEnabled() {
        return this.mode == SecurityMode.TLS || this.mode == SecurityMode.DEFAULT && (TlsContext.getDefaultRpcTlsContext().isConfigured() || this.isJsseConfigured() || this.isOpenSslConfigured());
    }

    private boolean isOpenSslConfigured() {
        return this.certChainPath != null && this.privateKeyPath != null;
    }

    private boolean isJsseConfigured() {
        return this.certificateKeystoreFile != null || this.certificateKeyAlias != null;
    }

    private boolean isCertConfigured() {
        return this.certFile != null && this.privateKeyPath != null;
    }

    public SecurityMode getSecurityMode() {
        return this.mode;
    }

    public File getCertChainFile() {
        if (this.certChainPath == null) {
            return null;
        }
        return new File(this.certChainPath);
    }

    public File getPrivateKeyFile() {
        if (this.privateKeyPath == null) {
            return null;
        }
        return new File(this.privateKeyPath);
    }

    public String getPrivateKeyPassword() {
        return StringUtils.trimToNull((String)Config.getProperty((String)GRAPHDB_RAFT_SECURITY_PRIVATE_KEY_PASSWORD, (String)Config.getProperty((String)"graphdb.connector.keyPass", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeyPassword", (String)Config.getProperty((String)"graphdb.connector.certificateKeyPassword", (String)Config.getProperty((String)"graphdb.connector.SSLPassword", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeyPassword")))))));
    }

    public File getRootCertsFile() {
        if (this.rootCertsPath == null) {
            return null;
        }
        return new File(this.rootCertsPath);
    }

    @Nullable
    public X509Certificate getCertificate() {
        if (this.certificate == null) {
            String certificateAlias;
            X509KeyManager x509KeyManager;
            X509Certificate[] certificateChain;
            KeyManager[] keyManagers = (KeyManager[])ObjectUtils.getIfNull((Object)this.getTlsContext().getKeyManagers(), () -> ((TlsContext)TlsContext.getDefaultRpcTlsContext()).getKeyManagers());
            if (keyManagers != null && keyManagers.length > 0 && (certificateChain = (x509KeyManager = (X509KeyManager)keyManagers[0]).getCertificateChain(certificateAlias = Objects.toString(this.certificateKeyAlias, "tomcat"))) != null && certificateChain.length > 0) {
                this.certificate = certificateChain;
            }
            if (this.certificate == null) {
                this.certificate = new X509Certificate[1];
            }
        }
        return this.certificate[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized TlsContext getTlsContext() {
        if (this.tlsContext == null) {
            try {
                SSLHostConfigCertificate hostConfig = this.configureSslHostConfig();
                boolean configured = false;
                if (this.isJsseConfigured()) {
                    LOGGER.debug("Configuring cluster security using JSSE");
                    configured = true;
                    hostConfig.setCertificateKeyAlias(this.certificateKeyAlias);
                    hostConfig.setCertificateKeystoreFile(this.certificateKeystoreFile);
                    String certificateKeystorePassword = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_JSSE_KEYSTORE_PASS, (String)Config.getProperty((String)"graphdb.connector.keystorePass", (String)Config.getProperty((String)"graphdb.connector.ssl.certificateKeystorePassword")));
                    if (certificateKeystorePassword != null) {
                        hostConfig.setCertificateKeystorePassword(certificateKeystorePassword);
                    }
                    if (this.certificateKeystoreType != null) {
                        hostConfig.setCertificateKeystoreType(this.certificateKeystoreType);
                    }
                    if (this.certificateKeystoreProvider != null) {
                        hostConfig.setCertificateKeystoreProvider(this.certificateKeystoreProvider);
                    }
                }
                if (this.isOpenSslConfigured()) {
                    LOGGER.debug("Configuring cluster security using OpenSSL");
                    configured = true;
                    hostConfig.setCertificateChainFile(this.certChainPath);
                    hostConfig.setCertificateKeyFile(this.privateKeyPath);
                    hostConfig.setCertificateFile(this.certFile);
                }
                if (this.isCertConfigured()) {
                    LOGGER.debug("Configured cluster security using a certificate without chain path");
                    configured = true;
                    hostConfig.setCertificateFile(this.certFile);
                    hostConfig.setCertificateKeyFile(this.privateKeyPath);
                }
                if (configured) {
                    JSSEUtil jsseUtil = new JSSEUtil(hostConfig);
                    this.tlsContext = new TlsContext(jsseUtil.getKeyManagers(), jsseUtil.getTrustManagers());
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Could not load custom TLS settings due to", (Throwable)ex);
            }
            finally {
                if (this.tlsContext == null) {
                    LOGGER.debug("No valid cluster security configuration");
                    this.tlsContext = new TlsContext(null, null);
                }
            }
        }
        return this.tlsContext;
    }

    @NotNull
    private SSLHostConfigCertificate configureSslHostConfig() {
        String truststorePassword;
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        if (this.truststoreFile != null) {
            sslHostConfig.setTruststoreFile(this.truststoreFile);
        }
        if ((truststorePassword = Config.getProperty((String)GRAPHDB_RAFT_SECURITY_TRUST_STORE_PASS, (String)Config.getProperty((String)"graphdb.connector.truststorePass"))) != null) {
            sslHostConfig.setTruststorePassword(truststorePassword);
        }
        if (this.truststoreProvider != null) {
            sslHostConfig.setTruststoreProvider(this.truststoreProvider);
        }
        if (this.truststoreType != null) {
            sslHostConfig.setTruststoreType(this.truststoreType);
        }
        if (this.keyManagerAlgorithm != null) {
            sslHostConfig.setKeyManagerAlgorithm(this.keyManagerAlgorithm);
        }
        if (this.certificateRevocationListFile != null) {
            sslHostConfig.setCertificateRevocationListFile(this.certificateRevocationListFile);
        }
        if (this.certificateVerification != null) {
            sslHostConfig.setCertificateVerification(this.certificateVerification);
        }
        SSLHostConfigCertificate hostConfig = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        sslHostConfig.addCertificate(hostConfig);
        String privateKeyPassword = this.getPrivateKeyPassword();
        if (privateKeyPassword != null) {
            hostConfig.setCertificateKeyPassword(privateKeyPassword);
        }
        return hostConfig;
    }

    public static enum SecurityMode {
        DEFAULT,
        NONE,
        TLS;


        static SecurityMode parse(String value) {
            if (StringUtils.isEmpty((CharSequence)value) || "false".equalsIgnoreCase(value)) {
                return DEFAULT;
            }
            return SecurityMode.valueOf(value.toUpperCase());
        }
    }
}

