/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.security;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.graphdb.raft.security.SecurityUtil;
import com.ontotext.graphdb.security.TokenManager;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.CompositeCallCredentials;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class RequestSignerInterceptor
implements ClientInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestSignerInterceptor.class);
    private final TokenManager tokenManager;
    private final String recipientAddress;

    public RequestSignerInterceptor(String recipientAddress) {
        this.tokenManager = TokenManager.getInstance();
        this.recipientAddress = recipientAddress;
    }

    @VisibleForTesting
    public RequestSignerInterceptor(TokenManager tokenManager, String recipientAddress) {
        this.tokenManager = tokenManager;
        this.recipientAddress = recipientAddress;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        CallCredentials credentials = callOptions.getCredentials();
        credentials = credentials == null ? new SignedCallCredentials(this.tokenManager, auth, this.recipientAddress) : new CompositeCallCredentials(credentials, (CallCredentials)new SignedCallCredentials(this.tokenManager, auth, this.recipientAddress));
        return next.newCall(method, callOptions.withCallCredentials(credentials));
    }

    private static class SignedCallCredentials
    extends CallCredentials {
        private final TokenManager tokenManager;
        private final Authentication auth;
        private final String recipientAddress;

        public SignedCallCredentials(TokenManager tokenManager, Authentication auth, String recipientAddress) {
            this.tokenManager = tokenManager;
            this.auth = auth;
            this.recipientAddress = recipientAddress;
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
            Metadata metadata = new Metadata();
            metadata.put(SecurityUtil.TIMESTAMP_HEADER, (Object)this.tokenManager.newTimestamp());
            String username = null;
            String userRoles = null;
            if (this.auth != null) {
                Collection authorities;
                username = "user;" + this.auth.getName();
                Object principal = this.auth.getPrincipal();
                if (principal instanceof AuthenticatedUser) {
                    authorities = ((AuthenticatedUser)principal).getExpandedAuthorities();
                } else {
                    if (!(this.auth instanceof PreAuthenticatedAuthenticationToken)) {
                        LOGGER.warn("Unexpected authentication principal class: {}", principal.getClass());
                    }
                    authorities = this.auth.getAuthorities();
                }
                userRoles = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
                metadata.put(SecurityUtil.AUTH_CONTEXT_HEADER_USERNAME, (Object)username);
                metadata.put(SecurityUtil.USER_AUTHORITIES, (Object)userRoles);
            }
            metadata.put(SecurityUtil.AUTHORIZATION_HEADER, (Object)this.tokenManager.signWithKeyword(SecurityUtil.createSummary(requestInfo, username, userRoles)));
            metadata.put(SecurityUtil.RECIPIENT_ADDRESS, (Object)this.recipientAddress);
            applier.apply(metadata);
        }
    }
}

