/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.statistics;

import com.ontotext.graphql.compiler.SparqlBuilderUtil;
import com.ontotext.graphql.compiler.querymodel.Base;
import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.Prefix;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.statistics.CachedRepoStatistics;
import com.ontotext.graphql.compiler.statistics.StatisticsCollectionException;
import com.ontotext.graphql.parser.argument.optimization.RepoStatistics;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollector;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.SparqlRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainPlanStatisticsCollector
implements StatisticsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainPlanStatisticsCollector.class);
    private static final String ONTO_EXPLAIN = "http://www.ontotext.com/explain";
    private static final Map<String, String> DEFAULT_PREFIXES;
    private static final Pattern LINE_PATTERN;
    private static final Pattern PFX_PATTERN;
    private final SparqlEndpoint sparqlEndpoint;
    private final SparqlQueryInvoker queryInvoker;
    private final Map<String, List<String>> bindings;
    private final SomlSchema soml;
    private String basePrefix;
    private final Map<String, String> prefixes = new HashMap<String, String>();
    private final Map<String, Set<String>> shapeToTypeMap = new HashMap<String, Set<String>>();
    private final Map<String, Double> shapeSize = new HashMap<String, Double>();
    private final Map<String, Double> propSize = new HashMap<String, Double>();
    private final Map<String, Set<Shape>> propToShape = new HashMap<String, Set<Shape>>();
    private final Shapes userDefinedShapes;

    public ExplainPlanStatisticsCollector(SparqlEndpoint sparqlEndpoint, SomlSchema soml) {
        this(sparqlEndpoint, soml, new SparqlQueryInvoker());
    }

    public ExplainPlanStatisticsCollector(SparqlEndpoint sparqlEndpoint, SomlSchema soml, SparqlQueryInvoker queryInvoker) {
        if (sparqlEndpoint == null) {
            throw new IllegalArgumentException("Repo statistics could be extracted only from SparqlEndpint");
        }
        this.sparqlEndpoint = sparqlEndpoint;
        soml.getConfig().getRepository().ifPresent(arg_0 -> ((SparqlEndpoint)this.sparqlEndpoint).setRepository(arg_0));
        this.soml = soml;
        this.queryInvoker = queryInvoker;
        this.bindings = new HashMap<String, List<String>>();
        this.bindings.put("plan", Collections.singletonList("plan"));
        this.prefixes.putAll(DEFAULT_PREFIXES);
        this.userDefinedShapes = ExplainPlanStatisticsCollector.getUserDefinedShapes(soml);
    }

    public RepoStatistics collect() {
        SelectQuery selectQuery = new ExplainQueryGenerator().generate();
        try {
            String executionPlan = this.getExecutionPlan(selectQuery);
            if (executionPlan == null) {
                return RepoStatistics.empty();
            }
            this.extractPatternStatistics(executionPlan);
            this.normalizeShapeSizes();
            this.buildPropertyClassMap();
            CachedRepoStatistics statistics = this.transformPatternStatistics();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("REPOSITORY STATISTICS COLLECTOR FROM GDB EXECUTION PLAN\n");
                LOGGER.trace(statistics.prettyPrint());
            } else {
                LOGGER.info("Successfully collected GDB statistics for {} repository.", (Object)this.sparqlEndpoint.getRepository());
            }
            return statistics;
        }
        catch (Exception ex) {
            LOGGER.error("Could not collect repository statistics", (Throwable)ex);
            throw new StatisticsCollectionException(ex);
        }
    }

    private void buildPropertyClassMap() {
        this.userDefinedShapes.values().stream().filter(CachedRepoStatistics.includeShapeInStatistics()).forEach(this.addShapeToPropertyClassMap());
    }

    private Consumer<Shape> addShapeToPropertyClassMap() {
        return shape -> shape.getAllProperties().values().stream().filter(CachedRepoStatistics.includePropInStatistics()).forEach(this.addPropertyShapeToPropertyClassMap((Shape)shape));
    }

    private Consumer<PropertyShape> addPropertyShapeToPropertyClassMap(Shape shape) {
        return propShape -> this.propToShape.computeIfAbsent(this.getRdfPropShapePredicate((PropertyShape)propShape), k -> new HashSet()).add(shape);
    }

    private CachedRepoStatistics transformPatternStatistics() {
        CachedRepoStatistics.Builder statBuilder = new CachedRepoStatistics.Builder();
        this.buildStatisticsForConcreteClasses(statBuilder);
        this.buildStatisticsForProperties(statBuilder);
        return statBuilder.build(this.userDefinedShapes);
    }

    private void buildStatisticsForProperties(CachedRepoStatistics.Builder statBuilder) {
        this.propSize.forEach(this.buildStatisticsForPredicate(statBuilder));
    }

    private void buildStatisticsForConcreteClasses(CachedRepoStatistics.Builder statBuilder) {
        this.shapeSize.forEach((shape, size) -> statBuilder.addShapeSize((Shape)this.userDefinedShapes.get(shape), (Double)size));
    }

    private BiConsumer<? super String, ? super Double> buildStatisticsForPredicate(CachedRepoStatistics.Builder statBuilder) {
        return (pred, size) -> {
            Double totalCountOfObjectContainingThisPredicate = this.propToShape.getOrDefault(pred, Collections.emptySet()).stream().map(Shape::getId).map(id -> this.shapeSize.getOrDefault(id, 0.0)).mapToDouble(Double::doubleValue).sum();
            for (Shape shape : this.propToShape.getOrDefault(pred, Collections.emptySet())) {
                double normalizedSize;
                if (totalCountOfObjectContainingThisPredicate == 0.0) {
                    normalizedSize = 0.0;
                } else {
                    double coef = this.shapeSize.get(shape.getId()) / totalCountOfObjectContainingThisPredicate;
                    normalizedSize = size * coef;
                }
                assert (normalizedSize < Double.MAX_VALUE);
                statBuilder.addShapePropSize(shape, this.getPropShape(shape, (String)pred), normalizedSize);
            }
        };
    }

    private void extractPatternStatistics(String executionPlan) {
        for (String line : executionPlan.split("\\n")) {
            Matcher pfxMatcher = PFX_PATTERN.matcher(line);
            if (pfxMatcher.find()) {
                String pfx = pfxMatcher.group("pfx");
                String iri = pfxMatcher.group("iri");
                if (pfx != null) {
                    this.prefixes.put(pfx, iri);
                    continue;
                }
                this.setBasePrefix(iri);
                continue;
            }
            Matcher matcher = LINE_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            String subject = matcher.group("subject");
            String predicate = this.normalizePredicate(matcher.group("predicate"));
            String object = this.normalizePredicate(matcher.group("object"));
            Double size = Double.valueOf(matcher.group("size").replace(",", ""));
            this.processExplainPlanEntry(subject, predicate, object, size);
        }
    }

    private void setBasePrefix(String iri) {
        assert (this.basePrefix == null) : "Base prefix should not be set more than once: " + this.basePrefix + " -> " + iri;
        this.basePrefix = Objects.requireNonNull(iri, "Base prefix value should not be null");
    }

    private void normalizeShapeSizes() {
        for (Map.Entry<String, Double> shapeStat : this.shapeSize.entrySet()) {
            Shape shape = (Shape)this.userDefinedShapes.get((Object)shapeStat.getKey());
            if (!shape.isAbstract() || shape.getTypeAsList().isEmpty()) continue;
            Double abstractShapeSize = shapeStat.getValue();
            double concreteShapesCombinedSize = ((Collection)this.userDefinedShapes.getIfPresent(shape.getId()).map(Shape::getConcreteSubTypes).orElse(List.of())).stream().filter(child -> this.shapeSize.containsKey(child.getId())).map(child -> this.shapeSize.get(child.getId())).mapToDouble(Double::doubleValue).sum();
            if (!(concreteShapesCombinedSize > abstractShapeSize)) continue;
            double coef = abstractShapeSize / concreteShapesCombinedSize;
            ((Collection)this.userDefinedShapes.getIfPresent(shape.getId()).map(Shape::getConcreteSubTypes).orElse(List.of())).stream().filter(child -> !child.getTypeProp().equals(shape.getTypeProp())).map(Shape::getId).filter(this.shapeSize::containsKey).forEach(id -> this.shapeSize.put((String)id, this.shapeSize.get(id) * coef));
        }
    }

    private void processExplainPlanEntry(String subject, String predicate, String object, Double size) {
        Prefixes somlPrefixes = this.soml.getPrefixes();
        String normalizedSubject = somlPrefixes.nameToShortIri(this.varNameToBoType(subject));
        Shape shape = (Shape)this.userDefinedShapes.get((Object)normalizedSubject);
        if (shape == null) {
            this.inversePropAndPropulatePropSizeMap(predicate, size);
            return;
        }
        if (this.determinesShapeSize(predicate, object, somlPrefixes, shape)) {
            this.shapeSize.compute(normalizedSubject, (id, oldValue) -> oldValue == null ? size : oldValue + size);
        } else {
            for (PropertyShape propertyShape : shape.getAllProperties().values()) {
                String fullRdfProperty;
                String rdfProperty = propertyShape.getRdfProperty();
                if (SparqlUtil.isSparqlTemplate((String)rdfProperty) || !somlPrefixes.irisAreEqual(fullRdfProperty = somlPrefixes.toIri(rdfProperty), predicate)) continue;
                this.populatePropSizeMap(fullRdfProperty, size);
                break;
            }
        }
    }

    private boolean determinesShapeSize(String predicate, String object, Prefixes prefixes, Shape shape) {
        if (!prefixes.irisAreEqual(predicate, shape.getTypePropIri())) {
            return false;
        }
        Set types = this.shapeToTypeMap.computeIfAbsent(shape.getId(), key -> shape.getTypeAsList().stream().map(arg_0 -> ((Prefixes)prefixes).toIri(arg_0)).collect(Collectors.toSet()));
        return types.contains(prefixes.toIri(object));
    }

    private void inversePropAndPropulatePropSizeMap(String property, Double size) {
        this.populatePropSizeMap("^" + property, size);
    }

    private void populatePropSizeMap(String property, Double size) {
        Double oldValue = this.propSize.put(property, size);
        assert (oldValue == null);
    }

    private String varNameToBoType(String subject) {
        return subject.replaceFirst("\\?", "");
    }

    private String normalizePredicate(String iri) {
        int colonIndex;
        boolean isIri = false;
        if (((String)iri).startsWith("<") && ((String)iri).endsWith(">")) {
            iri = ((String)iri).substring(1, ((String)iri).length() - 1);
            isIri = true;
        }
        if ((colonIndex = ((String)iri).indexOf(58)) > 0 && !isIri) {
            String prefix = ((String)iri).substring(0, colonIndex);
            String localName = ((String)iri).substring(colonIndex + 1).replace("\\", "");
            iri = this.prefixes.getOrDefault(prefix, prefix + ":") + localName;
        } else if (isIri && this.basePrefix != null && !((String)iri).contains(":/")) {
            String separator = "";
            if (!((String)iri).startsWith("/") && !this.basePrefix.endsWith("/")) {
                separator = "/";
            }
            iri = this.basePrefix + separator + (String)iri;
        }
        return iri;
    }

    private String getRdfPropShapePredicate(PropertyShape propertyShape) {
        return propertyShape.getInverseAliasProperty().map(prop -> "^" + this.soml.getPrefixes().toIri(prop)).orElse(this.soml.getPrefixes().toIri(propertyShape.getRdfProperty()));
    }

    private PropertyShape getPropShape(Shape shape, String predicate) {
        if (!predicate.startsWith("^")) {
            return shape.getPropertyOrFail(predicate);
        }
        String inversePredicate = predicate.substring(1);
        return shape.getAllProperties().values().stream().filter(prop -> prop.getInverseAliasProperty().map(arg_0 -> ((Prefixes)this.soml.getPrefixes()).toIri(arg_0)).filter(Predicate.isEqual(inversePredicate)).isPresent()).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Could not resolve inverse property: %s.%s", shape.getId(), inversePredicate)));
    }

    protected String getExecutionPlan(SelectQuery selectQuery) {
        QueryRequest request = (QueryRequest)new QueryRequest("", selectQuery.toSparql(), this.bindings, this.soml).disableRequestLogging();
        ExecutionResponse response = this.queryInvoker.invoke((SparqlRequest)request, this.sparqlEndpoint);
        if (this.soml.getConfig().getRepository().isPresent() && response.getError() != null && response.getError().getCause() instanceof PlatformConfigurationException) {
            throw (PlatformConfigurationException)response.getError().getCause();
        }
        RdfTree rdfTree = (RdfTree)response.getData();
        if (rdfTree == null || rdfTree.getResultIris("plan").isEmpty()) {
            LOGGER.warn("Could not generate Repo Statistics. Will continue without statistics. Most probably you are not using GraphDB");
            return null;
        }
        return (String)rdfTree.getResultIris("plan").iterator().next();
    }

    private static Shapes getUserDefinedShapes(SomlSchema schema) {
        Shapes userDefinedShapes = schema.getObjects().getUserDefinedShapes();
        userDefinedShapes.entrySet().removeIf(entry -> ((Shape)entry.getValue()).isUnion() || SparqlUtil.isSparqlTemplate((String)((Shape)entry.getValue()).getTypePropIri()) || ((Shape)entry.getValue()).getServiceAddress() != null);
        return userDefinedShapes;
    }

    static {
        LINE_PATTERN = Pattern.compile("^\\s*(?<subject>\\S+)\\s(?<predicate>\\S+)\\s(?<object>\\S+)\\s.*Collection size: (?<size>.*?)\\s.*$");
        PFX_PATTERN = Pattern.compile("\\s*(BASE|PREFIX\\s(?<pfx>\\S+):)\\s<(?<iri>\\S+)>.*$");
        DEFAULT_PREFIXES = new HashMap<String, String>();
        DEFAULT_PREFIXES.put("onto", "http://www.ontotext.com/");
    }

    class ExplainQueryGenerator {
        private static final int DEFAULT_UNION_BLOCK_SIZE = 200;
        private final int unionBlockSize;
        private Set<String> includedPredicates = new HashSet<String>();

        public ExplainQueryGenerator() {
            this(200);
        }

        public ExplainQueryGenerator(int unionBlockSize) {
            this.unionBlockSize = unionBlockSize;
        }

        SelectQuery generate() {
            return this.getSelectQuery();
        }

        private SelectQuery getSelectQuery() {
            SelectQuery query = new SelectQuery();
            query.addFrom(new Iri(ExplainPlanStatisticsCollector.ONTO_EXPLAIN));
            LinkedList<SparqlNode> nodes = new LinkedList<SparqlNode>();
            ExplainPlanStatisticsCollector.this.userDefinedShapes.values().stream().filter(CachedRepoStatistics.includeShapeInStatistics()).forEach(this.processShape(nodes::add));
            ExplainPlanStatisticsCollector.this.userDefinedShapes.values().stream().filter(Shape::isAbstract).forEach(this.collectShapeSize(nodes::add));
            this.addNodesToQuery(query, nodes);
            ExplainPlanStatisticsCollector.this.soml.getSpecialPrefixes().getBaseIri().map(Base::new).ifPresent(query::setBase);
            query.getUsedPrefixes().distinct().sorted().filter(arg_0 -> ExplainPlanStatisticsCollector.this.soml.getPrefixes().containsKey(arg_0)).map(pref -> new Prefix((String)pref, (String)ExplainPlanStatisticsCollector.this.soml.getPrefixes().get(pref))).forEach(query.getPrefixes()::add);
            return query;
        }

        private void addNodesToQuery(SelectQuery query, List<SparqlNode> nodes) {
            nodes.removeIf(Empty.class::isInstance);
            SparqlBuilderUtil.addNodesToQuery(nodes, query.getWhereBlock(), this.unionBlockSize);
        }

        Consumer<Shape> processShape(Consumer<SparqlNode> consumer) {
            return shape -> {
                this.collectShapeSize(consumer).accept((Shape)shape);
                Var shapeVar = new Var(null, shape.asGraphQl());
                shape.getAllProperties().forEach((sh, propertyShape) -> consumer.accept(this.sparqlNodeForPropertyShape(shapeVar, (PropertyShape)propertyShape)));
            };
        }

        Consumer<Shape> collectShapeSize(Consumer<SparqlNode> consumer) {
            return shape -> {
                Var shapeVar = new Var(null, shape.asGraphQl());
                if (!shape.getTypeAsList().isEmpty()) {
                    for (String type : shape.getTypeAsList()) {
                        consumer.accept(this.sparqlNodeForShapeType(shapeVar, (Shape)shape, ExplainPlanStatisticsCollector.this.soml.getPrefixes().toIri(type)));
                    }
                }
            };
        }

        private SparqlNode sparqlNodeForShapeType(Var shapeVar, Shape shape, String type) {
            return PatternNode.createPattern(shapeVar, new Iri(shape.getTypePropIri()), new Iri(type));
        }

        private SparqlNode sparqlNodeForPropertyShape(Var shapeVar, PropertyShape propertyShape) {
            if (!CachedRepoStatistics.includePropInStatistics().test(propertyShape)) {
                return Empty.INSTANCE;
            }
            String shapePropName = ExplainPlanStatisticsCollector.this.soml.getPrefixes().toName(propertyShape.getName());
            Var object = new Var(shapeVar, shapePropName);
            Value predicate = this.getPropShapePredicate(propertyShape);
            if (this.includedPredicates.contains(predicate.toSparql())) {
                return Empty.INSTANCE;
            }
            this.includedPredicates.add(predicate.toSparql());
            return PatternNode.createPattern(shapeVar, predicate, object);
        }

        private Value getPropShapePredicate(PropertyShape propertyShape) {
            return propertyShape.getInverseAliasProperty().map(s -> new Inverse(propertyShape.getName(), (String)s)).orElseGet(() -> new Iri(propertyShape.getRdfProperty()));
        }
    }
}

