/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Empty;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import java.util.stream.Stream;

public class UnionNode
implements SparqlNode {
    SparqlNode innerNode;

    public UnionNode(SparqlNode innerNode) {
        this.innerNode = innerNode;
    }

    @Override
    public String toSparql() {
        String innerSparql = this.innerNode.toSparql();
        if (innerSparql.startsWith("{") && !(this.innerNode instanceof UnionCollection)) {
            return innerSparql;
        }
        return "{ " + innerSparql + " }";
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.of(this.innerNode);
    }

    public static boolean isEmptyNode(SparqlNode node) {
        if (node instanceof UnionNode) {
            SparqlNode sparqlNode = ((UnionNode)node).innerNode;
            if (sparqlNode instanceof TriplePatternBlock && ((TriplePatternBlock)sparqlNode).getPatterns().isEmpty()) {
                return true;
            }
            return Empty.INSTANCE == sparqlNode;
        }
        return false;
    }
}

