/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Var;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TempVar
extends Var {
    private Var originalVar;
    private boolean temporary = true;

    public TempVar(Var parent, String localName) {
        super(parent, localName);
        this.originalVar = new Var(parent, localName);
    }

    public TempVar(Var parent, String localName, Boolean multiValued) {
        super(parent, localName, multiValued);
        this.originalVar = new Var(parent, localName, multiValued);
    }

    @Override
    public String toSparql() {
        return "?" + this.getFullName();
    }

    @Override
    public String getFullName() {
        if (this.temporary) {
            return super.getFullName() + "__1";
        }
        return super.getFullName();
    }

    public Var getOriginalVar() {
        return this.originalVar;
    }

    public void export(Consumer<SparqlNode> patternConsumer) {
        if (this.isTemporary()) {
            patternConsumer.accept(new Bind(this, this.getOriginalVar()));
        }
    }

    public void setAsNotTemporary() {
        this.temporary = false;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public String toString() {
        return this.toSparql();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TempVar)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TempVar tempVar = (TempVar)obj;
        return this.originalVar.equals(tempVar.originalVar);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originalVar);
    }

    @Override
    public TempVar copy() {
        TempVar copy = this.getParent() == null ? new TempVar(null, this.getLocalName(), this.getMultiValued()) : new TempVar(this.getParent().copy(), this.getLocalName(), this.getMultiValued());
        if (!this.isTemporary()) {
            copy.setAsNotTemporary();
        }
        return copy;
    }

    public static Stream<Var> getNonTempVars(SparqlNode node) {
        return Stream.concat(node.streamNodes().filter(Var.class::isInstance).map(Var.class::cast).filter(var -> !(var instanceof TempVar) || !((TempVar)var).isTemporary()).map(var -> {
            if (var instanceof TempVar) {
                return ((TempVar)var).getOriginalVar();
            }
            return var;
        }), node.streamNodes().flatMap(TempVar::getNonTempVars));
    }

    public static Stream<Var> getAllVars(SparqlNode node) {
        return Stream.concat(node.streamNodes().filter(Var.class::isInstance).map(Var.class::cast).map(var -> {
            if (var instanceof TempVar) {
                return ((TempVar)var).getOriginalVar();
            }
            return var;
        }), node.streamNodes().flatMap(TempVar::getAllVars));
    }

    public static Stream<TempVar> getAllTempVars(SparqlNode node) {
        return Stream.concat(node.streamNodes().filter(TempVar.class::isInstance).map(TempVar.class::cast), node.streamNodes().flatMap(TempVar::getAllTempVars));
    }
}

