/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.google.common.collect.Streams;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.HelperVar;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.TriplePatternChain;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.Concat;
import com.ontotext.graphql.compiler.querymodel.functions.Iri;
import com.ontotext.graphql.compiler.querymodel.functions.Str;
import com.ontotext.models.subscriptions.SubscriptionRequest;
import java.util.stream.Stream;

public class SubscriptionNode
implements SparqlNode {
    private static final String EC = "ec";
    private static final com.ontotext.graphql.compiler.querymodel.Iri TRANSACTION = new com.ontotext.graphql.compiler.querymodel.Iri("ec", "transaction");
    private static final com.ontotext.graphql.compiler.querymodel.Iri OP_NUMBER = new com.ontotext.graphql.compiler.querymodel.Iri("ec", "operationNumber");
    private static final com.ontotext.graphql.compiler.querymodel.Iri LIMIT = new com.ontotext.graphql.compiler.querymodel.Iri("ec", "limit");
    private static final com.ontotext.graphql.compiler.querymodel.Iri OFFSET = new com.ontotext.graphql.compiler.querymodel.Iri("ec", "offset");
    private static final com.ontotext.graphql.compiler.querymodel.Iri ENTITIES = new com.ontotext.graphql.compiler.querymodel.Iri("ec", "entities");
    private static final com.ontotext.graphql.compiler.querymodel.Iri ADD_ONLY = new com.ontotext.graphql.compiler.querymodel.Iri("ec", "addOnly");
    private static final com.ontotext.graphql.compiler.querymodel.Iri TX_ID = new com.ontotext.graphql.compiler.querymodel.Iri("ec", "transactionId");
    private static final Var SEARCH = new HelperVar("search");
    private static final Var ENTITY = new HelperVar("entity");
    private static final Var TX_ID_HELPER_VAT = new HelperVar(ENTITY, "txId");
    private static final Literal A = new Literal("a");
    private final SubscriptionRequest req;
    private final Var subject;
    private TriplePatternChain pluginCall;
    private SparqlNodeSequence bindingBlock;

    public SubscriptionNode(SubscriptionRequest req, Var subject) {
        this.req = req;
        this.subject = subject;
    }

    @Override
    public String toSparql() {
        this.init();
        return this.pluginCall.toSparql() + " " + this.bindingBlock.toSparql();
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        this.init();
        return Streams.concat((Stream[])new Stream[]{this.pluginCall.streamNodes(), this.bindingBlock.streamNodes()});
    }

    private void init() {
        if (this.pluginCall != null) {
            return;
        }
        this.pluginCall = new TriplePatternChain(SEARCH);
        this.addIfNotNull(A, new com.ontotext.graphql.compiler.querymodel.Iri(this.req.getPluginInstanceName()));
        this.addIfNotNull(TRANSACTION, this.req.getTransaction());
        this.addIfNotNull(OP_NUMBER, this.req.getTransactionLimit());
        this.addIfNotNull(LIMIT, this.req.getLimit());
        this.addIfNotNull(OFFSET, this.req.getOffset());
        this.addIfNotNull(ENTITIES, ENTITY);
        if (this.req.isAddOnly()) {
            this.addIfNotNull(ADD_ONLY, this.req.isAddOnly());
        }
        this.buildBindingBlock();
    }

    private void addIfNotNull(Value pred, Object value) {
        if (value != null) {
            this.pluginCall.add(pred, (Value)(value instanceof Value ? value : this.asLiteral(value)));
        }
    }

    private void buildBindingBlock() {
        this.bindingBlock = new SparqlNodeSequence();
        this.bindingBlock.add(new Bind(ENTITY, this.subject));
        this.bindingBlock.add(new TriplePattern((Value)ENTITY, (Value)TX_ID, TX_ID_HELPER_VAT));
        Iri value = new Iri(new Concat(new Str(ENTITY), (SparqlNode)TX_ID_HELPER_VAT));
        this.bindingBlock.add(new Bind(value, new Var(null, this.subject.getLocalName())));
    }

    private Literal asLiteral(Object value) {
        if (value instanceof String) {
            return Literal.asString((String)value);
        }
        return new Literal(value);
    }
}

