/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.OperationVisitorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;

public class SparqlBuilderContext
implements OperationVisitorContext {
    private static final String SUBJECT = "subject";
    private static final String PARENT_BLOCK = "parentBlock";
    private static final String ITERATE_OVER = "iterateOver";
    private static final String FILTER_BUILDER = "filterBuilder";
    private Map<String, Object> data = new HashMap<String, Object>();

    public SparqlBuilderContext() {
    }

    public SparqlBuilderContext(Var subject, TriplePatternBlock patternBlock) {
        this();
        this.data.put(SUBJECT, subject);
        if (patternBlock != null) {
            this.data.put(PARENT_BLOCK, patternBlock);
        }
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Var getSubject() {
        return (Var)this.data.get(SUBJECT);
    }

    public Optional<TriplePatternBlock> getParentBlock() {
        return Optional.ofNullable((TriplePatternBlock)this.data.get(PARENT_BLOCK));
    }

    public ExternalBinding getIterateOver() {
        return (ExternalBinding)this.data.get(ITERATE_OVER);
    }

    public void setIterateOver(ExternalBinding binding) {
        this.data.put(ITERATE_OVER, binding);
    }

    public FilterBuilder getFilterBuilder() {
        return (FilterBuilder)this.data.get(FILTER_BUILDER);
    }

    public void setFilterBuilder(FilterBuilder filterBuilder) {
        this.data.put(FILTER_BUILDER, filterBuilder);
    }

    public boolean isRootQuery() {
        return this.getIterateOver() == null;
    }

    public static SparqlBuilderContext of(Var subject) {
        return new SparqlBuilderContext(subject, null);
    }

    public static SparqlBuilderContext of(Var subject, TriplePatternBlock patternBlock) {
        return new SparqlBuilderContext(subject, patternBlock);
    }

    public static class ExternalBinding {
        private SparqlNode linkNode;
        private Var var;
        private Collection<String> values;

        public ExternalBinding(SparqlNode linkNode, Var var, Collection<String> values) {
            this.linkNode = linkNode;
            this.var = var;
            this.values = values;
        }

        public ExternalBinding(SparqlNode linkNode, Var var) {
            this(linkNode, var, new LinkedList<String>());
        }

        public SparqlNode getLinkNode() {
            return this.linkNode;
        }

        public Var getVar() {
            return this.var;
        }

        public Collection<String> getValues() {
            return this.values;
        }
    }
}

