/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.SparqlTermFunctions;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Var;
import java.util.stream.Stream;

public class Regex
implements SparqlNode {
    Var var;
    String value;
    String varType;
    boolean caseSensitive;
    boolean castVarToStr;

    public Regex(Var var, String varType, String value, boolean caseSensitive) {
        this(var, varType, value, caseSensitive, true);
    }

    public Regex(Var var, String varType, String value, boolean caseSensitive, boolean castVarToStr) {
        this.var = var;
        this.varType = varType;
        this.value = value;
        this.caseSensitive = caseSensitive;
        this.castVarToStr = castVarToStr;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.of(this.var);
    }

    @Override
    public String toSparql() {
        return "REGEX (" + (this.castVarToStr ? SparqlTermFunctions.str(this.var, this.varType).toSparql() : this.var.toSparql()) + ", " + this.getValueAsString() + (this.caseSensitive ? "" : ", \"i\"") + ")";
    }

    private String getValueAsString() {
        if (!this.valueStartsAndEndsIn("\"") && !this.valueStartsAndEndsIn("'")) {
            return String.format("\"%s\"", this.value);
        }
        return this.value;
    }

    private boolean valueStartsAndEndsIn(String pat) {
        return this.value.startsWith(pat) && this.value.endsWith(pat);
    }
}

