/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.SparqlFragment;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePattern;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.soaas.common.SparqlUtil;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class PatternNode
implements SparqlNode {
    private boolean restrictive;
    private Value subject;
    private Value object;

    public PatternNode(Value subject, Value object, boolean restrictive) {
        this.subject = subject;
        this.object = object;
        this.restrictive = restrictive;
    }

    public static PatternNode createPattern(Value subject, Value predicate, Value object) {
        return PatternNode.createPattern(subject, predicate, object, false);
    }

    public static PatternNode createPattern(Value subject, Value predicate, Value object, boolean restrictive) {
        String inverseValue;
        if (predicate instanceof Iri && SparqlUtil.isSparqlTemplate((String)predicate.getName())) {
            return SparqlFragment.create(predicate.getName(), subject, object, restrictive);
        }
        if (predicate instanceof Inverse && SparqlUtil.isSparqlTemplate((String)(inverseValue = ((Inverse)predicate).toIri().getName()))) {
            return SparqlFragment.createInverse(inverseValue, subject, object, restrictive);
        }
        return new TriplePattern(subject, predicate, object, restrictive);
    }

    public Value getSubject() {
        return this.subject;
    }

    public Value getObject() {
        return this.object;
    }

    public void setSubject(Value subject) {
        this.subject = subject;
    }

    public void setObject(Value object) {
        this.object = object;
    }

    public boolean isRestrictive() {
        return this.restrictive;
    }

    public void setRestrictive(boolean restrictive) {
        this.restrictive = restrictive;
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.of(this.subject, this.object);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatternNode)) {
            return false;
        }
        PatternNode that = (PatternNode)obj;
        return Objects.equals(this.subject, that.subject) && Objects.equals(this.object, that.object);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.object);
    }
}

