/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Asc;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.Coalesce;
import com.ontotext.graphql.compiler.querymodel.Desc;
import com.ontotext.graphql.compiler.querymodel.DescBound;
import com.ontotext.graphql.compiler.querymodel.FilterVar;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TempVar;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.Selectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Order
extends SparqlNode {
    public Var getVar();

    public static List<Order> createOrderList(Var initialVar, Selectable node, BiFunction<Var, Selectable, Var> varBuilder, BiConsumer<Var, Selectable> onNonRequestedSelection, Consumer<SparqlNode> onQueryAddition) {
        List orders = node.getArguments().getOrder().orElse(Collections.emptyList());
        ArrayList<Order> resultOrderNodes = new ArrayList<Order>(orders.size());
        LinkedList<Order> coalescedOrders = new LinkedList<Order>();
        for (com.ontotext.models.query.Order order : orders) {
            Order orderSelectionToNode;
            List orderPath = order.getOrderPath();
            if (orderPath.isEmpty()) {
                if (!node.isRequestedByUser()) {
                    onNonRequestedSelection.accept(initialVar, node);
                }
                Supplier<IllegalStateException> invalidSelection = () -> new IllegalStateException(String.format("%s does not define `%s` argument!", node.getName(), "dir"));
                Var orderVar = varBuilder.apply(initialVar, node);
                orderSelectionToNode = node.getArguments().isAscendingOrder().map(asc -> asc.equals(Boolean.TRUE) ? new Asc(orderVar) : new Desc(orderVar)).orElseThrow(invalidSelection);
            } else {
                String firstOrder = (String)orderPath.get(0);
                Selectable orderNodeSelection = node.getSelections().stream().filter(Selectable.byNameOrAlias((String)firstOrder)).reduce(Order.getTheSelectionNotRequestedByUser()).orElseThrow(IllegalStateException::new);
                orderSelectionToNode = Order.orderSelectionToNode(orderNodeSelection, initialVar, orderPath.subList(1, orderPath.size()), varBuilder, onNonRequestedSelection);
                orderNodeSelection.getProperty().filter(prop -> prop.isScalarType() && prop.getScalarType().isLangStringSupported()).ifPresent(prop -> coalescedOrders.add(orderSelectionToNode));
            }
            if (orderSelectionToNode instanceof Asc && !orderSelectionToNode.getVar().getName().endsWith("_count")) {
                resultOrderNodes.add(new DescBound(orderSelectionToNode.getVar()));
            }
            resultOrderNodes.add(orderSelectionToNode);
        }
        Order.coalesceLiteralOrders(resultOrderNodes, coalescedOrders, onQueryAddition);
        return resultOrderNodes;
    }

    public static void coalesceLiteralOrders(List<Order> orderList, List<Order> ordersToCoalesce, Consumer<SparqlNode> onQueryAddition) {
        if (ordersToCoalesce.size() > 1) {
            Order sample = ordersToCoalesce.get(0);
            Collection orderVars = ordersToCoalesce.stream().map(Order::getVar).collect(Collectors.toCollection(LinkedHashSet::new));
            FilterVar orderVar = new FilterVar(sample.getVar().getParent(), "coalesced", 0);
            onQueryAddition.accept(new Bind(new Coalesce(new ArrayList<SparqlNode>(orderVars)), orderVar));
            int index = orderList.indexOf(sample);
            index -= sample instanceof Asc ? 1 : 0;
            if (sample instanceof Asc) {
                orderList.add(index, new DescBound(orderVar));
                orderList.add(index + 1, new Asc(orderVar));
            } else {
                orderList.add(index, new Desc(orderVar));
            }
            orderList.removeIf(order -> orderVars.contains(order.getVar()));
        }
    }

    public static BinaryOperator<Selectable> getTheSelectionNotRequestedByUser() {
        return (selectable, selectable2) -> {
            if (!selectable.isRequestedByUser()) {
                return selectable;
            }
            if (!selectable2.isRequestedByUser()) {
                return selectable2;
            }
            return selectable;
        };
    }

    public static Order orderSelectionToNode(Selectable orderProperty, Var parentSubject, List<String> orderPath, BiFunction<Var, Selectable, Var> varBuilder, BiConsumer<Var, Selectable> onNonRequestedSelection) {
        String propertyName = orderProperty.getResponseName();
        Var orderingVar = varBuilder.apply(parentSubject, orderProperty);
        if (!orderProperty.isRequestedByUser()) {
            onNonRequestedSelection.accept(orderingVar, orderProperty);
        }
        if (orderProperty.isComplexType() && !orderPath.isEmpty()) {
            String orderPropertyPathNode = orderPath.get(0);
            Selectable subOrderProperty = (Selectable)orderProperty.getSelections().stream().filter(Selectable.byNameOrAlias((String)orderPropertyPathNode)).findFirst().orElseThrow(IllegalArgumentException::new);
            return Order.orderSelectionToNode(subOrderProperty, new TempVar(parentSubject, propertyName), orderPath.subList(1, orderPath.size()), varBuilder, onNonRequestedSelection);
        }
        Supplier<IllegalStateException> invalidSelection = () -> new IllegalStateException(String.format("%s does not define `%s` argument!", orderProperty.getName(), "dir"));
        return orderProperty.getArguments().isAscendingOrder().map(asc -> asc.equals(Boolean.TRUE) ? new Asc(orderingVar) : new Desc(orderingVar)).orElseThrow(invalidSelection);
    }
}

