/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.soaas.common.SparqlUtil;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class Literal
implements Value {
    public static final Literal EMPTY_STRING = new Literal("\"\"");
    private final String value;
    private final String lang;
    private final IRI datatype;

    public Literal(Object value) {
        this(Literal.getEscaped(value), null, Literal.resolveDatatype(value));
    }

    public Literal(Object value, String lang) {
        this(Literal.getEscaped(value), SparqlUtil.escape((String)lang), Literal.resolveDatatype(value));
    }

    private Literal(String value, String lang, IRI datatype) {
        this.value = value;
        this.lang = lang;
        this.datatype = datatype;
    }

    private static IRI resolveDatatype(Object obj) {
        org.eclipse.rdf4j.model.Literal literal;
        if (obj instanceof org.eclipse.rdf4j.model.Literal && !XSD.STRING.equals((Object)(literal = (org.eclipse.rdf4j.model.Literal)obj).getDatatype())) {
            return literal.getDatatype();
        }
        return null;
    }

    private static String getEscaped(Object val) {
        if (val instanceof org.eclipse.rdf4j.model.Literal) {
            org.eclipse.rdf4j.model.Literal literal = (org.eclipse.rdf4j.model.Literal)val;
            if (XSD.STRING.equals((Object)literal.getDatatype())) {
                return SparqlUtil.escapeXsdStringType((String)((org.eclipse.rdf4j.model.Literal)val).getLabel());
            }
            if (literal.getDatatype() != null && "http://www.w3.org/2001/XMLSchema#".equals(literal.getDatatype().getNamespace())) {
                return "\"" + literal.getLabel() + "\"^^xsd:" + literal.getDatatype().getLocalName();
            }
        }
        return SparqlUtil.escape((String)val.toString());
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    public String toSparql() {
        return this.value;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public Stream<String> getUsedPrefixes() {
        if (this.datatype == null) {
            return Stream.empty();
        }
        if ("http://www.w3.org/2001/XMLSchema#".equals(this.datatype.getNamespace())) {
            return Stream.of("xsd");
        }
        return Stream.of(this.datatype.stringValue());
    }

    public static Literal asString(String value) {
        return new Literal("'" + SparqlUtil.escape((String)value) + "'", null, null);
    }

    public static Literal asString(String value, String lang) {
        String escapedLang = SparqlUtil.escape((String)Objects.requireNonNull(StringUtils.trimToNull((String)lang), "Lang code is required"));
        return new Literal("\"" + SparqlUtil.escape((String)value) + "\"@" + escapedLang, escapedLang, null);
    }
}

