/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.Value;
import java.util.Objects;
import java.util.stream.Stream;

public class Iri
implements Value {
    private final String prefix;
    private final String name;

    public Iri(String name) {
        this.name = Objects.requireNonNull(name, "Constant value cannot be null");
        this.prefix = Iri.resolvePrefix(name);
    }

    public Iri(String prefix, String localname) {
        this.name = prefix + ":" + localname;
        this.prefix = prefix;
    }

    private static String resolvePrefix(String name) {
        int index;
        if (name.startsWith("<")) {
            return null;
        }
        int colonIndex = name.indexOf(58);
        int n = index = colonIndex < 0 ? name.indexOf(47) : colonIndex;
        if (index < 0) {
            return null;
        }
        if (index + 1 < name.length() && name.charAt(index + 1) == '/') {
            return null;
        }
        return name.substring(0, index);
    }

    @Override
    public String toSparql() {
        if (this.name.startsWith("<") && this.name.endsWith(">")) {
            return this.name;
        }
        int index = this.name.indexOf(47);
        if (!"a".equals(this.name) && (this.name.contains("://") || index > 0 && index + 1 < this.name.length() || this.name.indexOf(58) < 0)) {
            return "<" + this.name + ">";
        }
        if ("repository".equals(this.prefix)) {
            return "<" + this.name + ">";
        }
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Stream<String> getUsedPrefixes() {
        if (this.prefix == null) {
            return Stream.empty();
        }
        return Stream.of(this.prefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Iri constant = (Iri)obj;
        return Objects.equals(this.prefix, constant.prefix) && Objects.equals(this.name, constant.name);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.name);
    }

    public String toString() {
        if (this.name == null) {
            return "<null>";
        }
        return this.toSparql();
    }
}

