/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InValues
implements SparqlNode {
    private SparqlNode var;
    private Collection<SparqlNode> values;
    private final boolean negation;

    public InValues(SparqlNode var, Collection<SparqlNode> values) {
        this(var, values, false);
    }

    public InValues(SparqlNode var, Collection<SparqlNode> values, boolean negation) {
        this.var = var;
        this.values = values;
        this.negation = negation;
    }

    @Override
    public String toSparql() {
        if (this.values.size() == 1) {
            return this.var.toSparql() + (this.negation ? " !" : " ") + "= " + this.values.iterator().next().toSparql();
        }
        return this.var.toSparql() + (this.negation ? " NOT " : " ") + "IN " + this.values.stream().map(SparqlNode::toSparql).collect(Collectors.joining(", ", "(", ")"));
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.concat(Stream.of(this.var), this.values.stream().map(SparqlNode.class::cast));
    }

    public SparqlNode getVar() {
        return this.var;
    }

    public Collection<SparqlNode> getValues() {
        return this.values;
    }

    public boolean isNegation() {
        return this.negation;
    }
}

