/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class In
implements SparqlNode {
    private SparqlNode var;
    private Collection<? extends Value> values;
    private final int threshold;

    public In(SparqlNode var, Collection<? extends Value> values) {
        this(var, values, 1000);
    }

    public In(SparqlNode var, Collection<? extends Value> values, int threshold) {
        this.var = var;
        this.values = values;
        this.threshold = threshold;
    }

    @Override
    public String toSparql() {
        return this.buildSparql(false);
    }

    public String toNegativeSparql() {
        return this.buildSparql(true);
    }

    private String buildSparql(boolean negate) {
        String prefix;
        Object delimiter;
        String variable = this.var.toSparql();
        if (this.values.size() > this.threshold || !(this.var instanceof Var) && this.values.size() > 1) {
            delimiter = ", ";
            prefix = variable + (negate ? " NOT" : "") + " IN (";
        } else {
            delimiter = " || " + variable + " = ";
            prefix = (negate ? "!" : "") + "(" + variable + " = ";
        }
        return this.values.stream().map(SparqlNode::toSparql).collect(Collectors.joining((CharSequence)delimiter, prefix, ")"));
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return Stream.concat(Stream.of(this.var), this.values.stream().map(SparqlNode.class::cast));
    }

    public SparqlNode getVar() {
        return this.var;
    }

    public Collection<Value> getValues() {
        return new ArrayList<Value>(this.values);
    }
}

