/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler.querymodel;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Coalesce
implements SparqlNode {
    private final List<SparqlNode> expressions;

    public Coalesce(SparqlNode ... expressions) {
        this.expressions = Arrays.asList(expressions);
    }

    public Coalesce(List<SparqlNode> expressions) {
        this.expressions = Objects.requireNonNull(expressions, "Coalesce expressions are required");
    }

    @Override
    public String toSparql() {
        return "COALESCE(" + this.expressions.stream().map(SparqlNode::toSparql).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public Stream<SparqlNode> streamNodes() {
        return this.expressions.stream();
    }
}

