/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.Concat;
import com.ontotext.graphql.compiler.querymodel.functions.Contains;
import com.ontotext.graphql.compiler.querymodel.functions.DataType;
import com.ontotext.graphql.compiler.querymodel.functions.Iri;
import com.ontotext.graphql.compiler.querymodel.functions.Lang;
import com.ontotext.graphql.compiler.querymodel.functions.LangMatches;
import com.ontotext.graphql.compiler.querymodel.functions.LowerCase;
import com.ontotext.graphql.compiler.querymodel.functions.Str;
import com.ontotext.graphql.compiler.querymodel.functions.StringEnds;
import com.ontotext.graphql.compiler.querymodel.functions.StringStarts;
import com.ontotext.graphql.compiler.querymodel.functions.UpperCase;

public class SparqlTermFunctions {
    private static final String STRING_TYPE = "string";

    private SparqlTermFunctions() {
    }

    public static SparqlNode str(Var var, String type) {
        if (STRING_TYPE.equalsIgnoreCase(type)) {
            return var;
        }
        return SparqlTermFunctions.str(var);
    }

    public static Str str(SparqlNode node) {
        return new Str(node);
    }

    public static DataType dataType(SparqlNode node) {
        return new DataType(node);
    }

    public static Lang lang(SparqlNode node) {
        return new Lang(node);
    }

    public static LangMatches langMatches(Var var, String langRange) {
        return new LangMatches(var, new Literal(langRange));
    }

    public static LangMatches langMatches(Var var, Value langRange) {
        return new LangMatches(var, langRange);
    }

    public static LangMatches hasLanguageCheck(Var var) {
        return new LangMatches(var, Literal.asString("*"));
    }

    public static Iri iri(SparqlNode node) {
        return new Iri(node);
    }

    public static Concat concat(SparqlNode first, SparqlNode second) {
        return new Concat(first, second);
    }

    public static Concat concat(SparqlNode first, SparqlNode second, SparqlNode ... rest) {
        return new Concat(first, second, rest);
    }

    public static StringEnds strEnds(SparqlNode target, SparqlNode endsWith) {
        return new StringEnds(target, endsWith);
    }

    public static StringStarts strStarts(SparqlNode target, SparqlNode startsWith) {
        return new StringStarts(target, startsWith);
    }

    public static Contains contains(SparqlNode target, SparqlNode contains) {
        return new Contains(target, contains);
    }

    public static LowerCase lowerCase(SparqlNode target) {
        return new LowerCase(target);
    }

    public static UpperCase upperCase(SparqlNode target) {
        return new UpperCase(target);
    }
}

