/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.rdf.CardinalityAwareBindingDescriptor;
import com.ontotext.soaas.common.sparql.CompilationResult;
import com.ontotext.soaas.common.sparql.PreviousExecution;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class SparqlCompilationResult
implements CompilationResult {
    private List<SparqlExecutionStep> steps = new LinkedList<SparqlExecutionStep>();

    public List<SparqlExecutionStep> getSteps() {
        return this.steps;
    }

    public CompilationResult add(SparqlExecutionStep executionStep) {
        this.steps.add(executionStep);
        return this;
    }

    public Builder<CompilationResult> addStep() {
        return new Builder<CompilationResult>(this, this);
    }

    public static class Builder<P> {
        private final SparqlCompilationResult compilationResult;
        private final P parent;
        private String executionId = UUID.randomUUID().toString();
        private Function<PreviousExecution, String> queryBuilder;
        private Map<String, List<String>> bindings;
        private String parentExecutionId;
        private boolean update = false;

        private Builder(SparqlCompilationResult compilationResult, P parent) {
            this.compilationResult = compilationResult;
            this.parent = parent;
        }

        private Builder(SparqlCompilationResult compilationResult, String parentExecutionId, P parent) {
            this.compilationResult = compilationResult;
            this.parentExecutionId = parentExecutionId;
            this.parent = parent;
        }

        public Builder<P> addQueryBuilder(Function<PreviousExecution, String> queryBuilder) {
            this.update = false;
            this.queryBuilder = queryBuilder;
            return this;
        }

        public Builder<P> addUpdateBuilder(Function<PreviousExecution, String> queryBuilder) {
            this.update = true;
            this.queryBuilder = queryBuilder;
            return this;
        }

        public Builder<P> addQuery(String query) {
            this.update = false;
            this.queryBuilder = previousExecution -> query;
            return this;
        }

        public Builder<P> addUpdate(String query) {
            this.update = true;
            this.queryBuilder = previousExecution -> query;
            return this;
        }

        public Builder<P> addBindings(Collection<Var> vars) {
            CardinalityAwareBindingDescriptor descriptor = new CardinalityAwareBindingDescriptor();
            vars.forEach(var -> descriptor.put(var.getName(), var.getVarPath(), var.getMultiValued()));
            this.bindings = descriptor;
            return this;
        }

        public Builder<Builder<P>> addSubExecution() {
            return new Builder<Builder<P>>(this.compilationResult, this.executionId, this);
        }

        public P register() {
            this.compilationResult.add(new SparqlExecutionStepImpl(this.executionId, this.parentExecutionId, this.queryBuilder, this.bindings, this.update));
            return this.parent;
        }
    }

    private static class SparqlExecutionStepImpl
    implements SparqlExecutionStep {
        private final String id;
        private final String parentId;
        private final Function<PreviousExecution, String> queryBuilderFunction;
        private final Map<String, List<String>> bindings;
        private final boolean update;

        SparqlExecutionStepImpl(String id, String parentId, Function<PreviousExecution, String> queryBuilderFunction, Map<String, List<String>> bindings, boolean update) {
            this.id = id;
            this.parentId = parentId;
            this.queryBuilderFunction = queryBuilderFunction;
            this.bindings = (Map)ObjectsUtil.getOrDefault(bindings, Collections.emptyMap());
            this.update = update;
        }

        public Optional<String> getDependsOn() {
            return Optional.ofNullable(this.parentId);
        }

        public String getId() {
            return this.id;
        }

        public String getQuery(PreviousExecution previousExecution) {
            return this.queryBuilderFunction.apply(previousExecution);
        }

        public Map<String, List<String>> getBindings() {
            return this.bindings;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SparqlExecutionStepImpl)) {
                return false;
            }
            SparqlExecutionStepImpl that = (SparqlExecutionStepImpl)obj;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

