/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.querymodel.Inverse;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.UnionNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.templates.Template;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;

public class SparqlBuilderUtil {
    private SparqlBuilderUtil() {
    }

    public static Value getPropertyPredicate(PropertyShape property, Object templateArgs) {
        String predicate;
        Shape containedIn = property.getContainedIn().getContainedIn();
        Optional inverseAlias = containedIn.getProperty(predicate = property.getName()).flatMap(PropertyShape::getInverseAliasProperty);
        if (inverseAlias.isPresent()) {
            return new Inverse(predicate, (String)inverseAlias.get());
        }
        return Optional.of(property).map(PropertyShape::getSparqlTemplate).map(template -> new Iri(SparqlBuilderUtil.applyTemplateArguments(template, templateArgs))).orElseGet(() -> new Iri(property.getRdfProperty()));
    }

    public static String applyTemplateArguments(Template template, Object args) {
        return template.apply(SparqlBuilderUtil.convertValuesToSparqlModel(args));
    }

    private static Object convertValuesToSparqlModel(Object args) {
        if (args instanceof Map) {
            ((Map)args).replaceAll((key, value) -> SparqlBuilderUtil.convertValuesToSparqlModel(value));
            return args;
        }
        if (args instanceof Collection) {
            return ((Collection)args).stream().map(SparqlBuilderUtil::convertValuesToSparqlModel).collect(Collectors.toList());
        }
        if (args instanceof IRI) {
            return new Iri(args.toString());
        }
        return args;
    }

    public static void addNodesToQuery(List<SparqlNode> nodes, TriplePatternBlock block, int unionBlockSize) {
        if (nodes.size() < unionBlockSize) {
            block.addAll(nodes);
        } else {
            int idx = 0;
            UnionCollection union = new UnionCollection();
            SparqlNodeSequence curr = new SparqlNodeSequence();
            while (idx < nodes.size()) {
                curr.add(nodes.get(idx++));
                if (idx % unionBlockSize != 0) continue;
                union.addNode(new UnionNode(curr));
                curr = new SparqlNodeSequence();
            }
            if (!curr.isEmpty()) {
                union.addNode(new UnionNode(curr));
            }
            block.addNode(union);
        }
    }
}

