/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.BuilderTypeDecider;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.QueryOptimizer;
import com.ontotext.graphql.compiler.SparqlBuilder;
import com.ontotext.graphql.compiler.SparqlBuilderType;
import com.ontotext.models.Operation;
import com.ontotext.soaas.common.sparql.OperationBuilder;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.QueryBuilderFactory;
import java.util.Objects;

public class DynamicQueryBuilderFactory
implements QueryBuilderFactory<Operation> {
    private final QueryOptimizer queryOptimizer;
    private final BuilderTypeDecider builderTypeDecider;
    private final FilterFactory filterFactory;
    private final OperationBuilderOptions options;

    public DynamicQueryBuilderFactory(BuilderTypeDecider builderTypeDecider) {
        this(new QueryOptimizer(), builderTypeDecider, OperationBuilderOptions.DEFAULT);
    }

    public DynamicQueryBuilderFactory(QueryOptimizer queryOptimizer, BuilderTypeDecider builderTypeDecider) {
        this(queryOptimizer, builderTypeDecider, OperationBuilderOptions.DEFAULT);
    }

    public DynamicQueryBuilderFactory(QueryOptimizer queryOptimizer, BuilderTypeDecider builderTypeDecider, OperationBuilderOptions options) {
        this.queryOptimizer = queryOptimizer;
        this.builderTypeDecider = builderTypeDecider;
        this.filterFactory = new FilterFactory();
        this.options = options;
    }

    public OperationBuilder<Operation> createBuilder(Operation operation) {
        Objects.requireNonNull(operation, "Operation is required argument");
        SparqlBuilderType builderType = this.builderTypeDecider.decide(operation);
        SparqlBuilder builder = null;
        if (SparqlBuilderType.SUBQUERY.equals((Object)builderType)) {
            builder = new SparqlBuilder(operation.getSchema(), this.queryOptimizer, this.filterFactory, SparqlBuilder.SubSelectStrategy.SUB_SELECT, this.options);
        } else if (SparqlBuilderType.SPLIT.equals((Object)builderType)) {
            builder = new SparqlBuilder(operation.getSchema(), this.queryOptimizer, this.filterFactory, SparqlBuilder.SubSelectStrategy.SPLIT_QUERY, this.options);
        }
        if (builder != null) {
            return builder;
        }
        throw new IllegalArgumentException("Forgot to implement something???");
    }
}

