/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSameAsInverseRewriter;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.stream.Stream;

public class MappingSameAsInverseRewriterImpl
implements MappingSameAsInverseRewriter {
    private final AtomFactory atomFactory;
    private final IntermediateQueryFactory iqFactory;
    private final QueryTransformerFactory transformerFactory;
    private final SubstitutionFactory substitutionFactory;
    private final boolean enabled;

    @Inject
    private MappingSameAsInverseRewriterImpl(AtomFactory atomFactory, IntermediateQueryFactory iqFactory, QueryTransformerFactory transformerFactory, SubstitutionFactory substitutionFactory, OntopMappingSettings settings) {
        this.atomFactory = atomFactory;
        this.iqFactory = iqFactory;
        this.transformerFactory = transformerFactory;
        this.substitutionFactory = substitutionFactory;
        this.enabled = settings.isSameAsInMappingsEnabled();
    }

    @Override
    public ImmutableList<MappingAssertion> rewrite(ImmutableList<MappingAssertion> mapping) {
        if (!this.enabled) {
            return mapping;
        }
        return (ImmutableList)mapping.stream().flatMap(this::transform).collect(ImmutableCollectors.toList());
    }

    private Stream<MappingAssertion> transform(MappingAssertion assertion) {
        return assertion.getIndex().isClass() || !assertion.getIndex().getIri().equals((Object)OWL.SAME_AS) ? Stream.of(assertion) : Stream.of(assertion, this.getInverse(assertion));
    }

    private MappingAssertion getInverse(MappingAssertion assertion) {
        RDFAtomPredicate rdfAtomPredicate = assertion.getRDFAtomPredicate();
        ImmutableList variables = assertion.getProjectionAtom().getArguments();
        Variable originalSubject = (Variable)rdfAtomPredicate.getSubject(variables);
        Variable originalObject = (Variable)rdfAtomPredicate.getObject(variables);
        VariableGenerator generator = assertion.getQuery().getVariableGenerator();
        Variable newSubject = generator.generateNewVariableFromVar(originalSubject);
        Variable newObject = generator.generateNewVariableFromVar(originalObject);
        DistinctVariableOnlyDataAtom newProjectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)rdfAtomPredicate, rdfAtomPredicate.updateSPO(variables, (ImmutableTerm)newSubject, (ImmutableTerm)((Variable)rdfAtomPredicate.getProperty(variables)), (ImmutableTerm)newObject));
        InjectiveSubstitution renamingSubstitution = this.substitutionFactory.getSubstitution(originalSubject, (ImmutableTerm)newObject, originalObject, (ImmutableTerm)newSubject).injective();
        return assertion.copyOf(this.iqFactory.createIQ(newProjectionAtom, this.transformerFactory.createRenamer(renamingSubstitution).transform(assertion.getQuery()).getTree()));
    }
}

