/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.constraints.Homomorphism;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.constraints.impl.ExtensionalDataNodeHomomorphismIteratorImpl;
import it.unibz.inf.ontop.constraints.impl.ExtensionalDataNodeListContainmentCheck;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.DisjunctionOfConjunctions;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MappingAssertionUnion {
    private final List<ConjunctiveIQ> conjunctiveIqs = new ArrayList<ConjunctiveIQ>();
    private final List<IQ> otherIqs = new ArrayList<IQ>();
    private final ExtensionalDataNodeListContainmentCheck cqc;
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final HomomorphismFactory homomorphismFactory;
    private final CoreSingletons coreSingletons;
    private final UnionBasedQueryMerger queryMerger;

    public static Collector<MappingAssertion, MappingAssertionUnion, Optional<MappingAssertion>> toMappingAssertion(ExtensionalDataNodeListContainmentCheck cqc, CoreSingletons coreSingletons, UnionBasedQueryMerger queryMerger) {
        return Collector.of(() -> new MappingAssertionUnion(cqc, coreSingletons, queryMerger), MappingAssertionUnion::add, (b1, b2) -> {
            throw new MinorOntopInternalBugException("no merge");
        }, MappingAssertionUnion::build, Collector.Characteristics.UNORDERED);
    }

    public MappingAssertionUnion(ExtensionalDataNodeListContainmentCheck cqc, CoreSingletons coreSingletons, UnionBasedQueryMerger queryMerger) {
        this.cqc = cqc;
        this.termFactory = coreSingletons.getTermFactory();
        this.iqFactory = coreSingletons.getIQFactory();
        this.homomorphismFactory = coreSingletons.getHomomorphismFactory();
        this.coreSingletons = coreSingletons;
        this.queryMerger = queryMerger;
    }

    public MappingAssertionUnion add(MappingAssertion assertion) {
        Optional<ConjunctiveIQ> cq = this.extractConjunctiveIQ(assertion);
        cq.ifPresentOrElse(this::mergeMappingsWithCQC, () -> this.otherIqs.add(assertion.getQuery()));
        return this;
    }

    private Optional<ConjunctiveIQ> extractConjunctiveIQ(MappingAssertion assertion) {
        DistinctVariableOnlyDataAtom projectionAtom = assertion.getProjectionAtom();
        ConstructionNode constructionNode = (ConstructionNode)assertion.getQuery().getTree().getRootNode();
        IQTree topTree = assertion.getTopChild();
        if (topTree instanceof TrueNode) {
            return Optional.of(new ConjunctiveIQ(projectionAtom, constructionNode, (ImmutableList<ExtensionalDataNode>)ImmutableList.of(), Optional.empty(), DisjunctionOfConjunctions.getTrue()));
        }
        if (topTree instanceof ExtensionalDataNode) {
            return Optional.of(new ConjunctiveIQ(projectionAtom, constructionNode, (ImmutableList<ExtensionalDataNode>)ImmutableList.of((Object)((ExtensionalDataNode)topTree)), Optional.empty(), DisjunctionOfConjunctions.getTrue()));
        }
        if (topTree instanceof ValuesNode) {
            return Optional.of(new ConjunctiveIQ(projectionAtom, constructionNode, (ImmutableList<ExtensionalDataNode>)ImmutableList.of(), Optional.of((ValuesNode)topTree), DisjunctionOfConjunctions.getTrue()));
        }
        QueryNode topNode = topTree.getRootNode();
        if (topNode instanceof FilterNode) {
            ImmutableExpression filter = ((FilterNode)topNode).getFilterCondition();
            IQTree childTree = ((UnaryIQTree)topTree).getChild();
            if (childTree instanceof ExtensionalDataNode) {
                return Optional.of(new ConjunctiveIQ(projectionAtom, constructionNode, (ImmutableList<ExtensionalDataNode>)ImmutableList.of((Object)((ExtensionalDataNode)childTree)), Optional.empty(), DisjunctionOfConjunctions.of(filter)));
            }
            if (childTree instanceof ValuesNode) {
                return Optional.of(new ConjunctiveIQ(projectionAtom, constructionNode, (ImmutableList<ExtensionalDataNode>)ImmutableList.of(), Optional.of((ValuesNode)childTree), DisjunctionOfConjunctions.of(filter)));
            }
        }
        if (topNode instanceof InnerJoinNode) {
            ImmutableList childrenTrees = topTree.getChildren();
            ImmutableList extensionalDataNodes = (ImmutableList)childrenTrees.stream().filter(n -> n instanceof ExtensionalDataNode).map(n -> (ExtensionalDataNode)n).collect(ImmutableCollectors.toList());
            ImmutableList valuesNodes = (ImmutableList)childrenTrees.stream().filter(n -> n instanceof ValuesNode).map(n -> (ValuesNode)n).collect(ImmutableCollectors.toList());
            if (extensionalDataNodes.size() + valuesNodes.size() == childrenTrees.size() && valuesNodes.size() <= 1) {
                DisjunctionOfConjunctions filter = ((InnerJoinNode)topNode).getOptionalFilterCondition().map(DisjunctionOfConjunctions::of).orElseGet(DisjunctionOfConjunctions::getTrue);
                return Optional.of(new ConjunctiveIQ(projectionAtom, constructionNode, (ImmutableList<ExtensionalDataNode>)extensionalDataNodes, valuesNodes.stream().findFirst(), filter));
            }
        }
        return Optional.empty();
    }

    public Optional<MappingAssertion> build() {
        Optional<IQ> query = this.queryMerger.mergeDefinitions((Collection)Stream.concat(this.conjunctiveIqs.stream().map(ConjunctiveIQ::asIQ), this.otherIqs.stream()).collect(ImmutableCollectors.toList())).map(IQ::normalizeForOptimization);
        return query.map(q -> new MappingAssertion((IQ)q, null));
    }

    private void mergeMappingsWithCQC(ConjunctiveIQ newCIQ) {
        if (this.conjunctiveIqs.contains(newCIQ)) {
            return;
        }
        Iterator<ConjunctiveIQ> iterator = this.conjunctiveIqs.iterator();
        while (iterator.hasNext()) {
            DisjunctionOfConjunctions newCIQCombinedConditionsImage;
            ImmutableSet currentCIQDatabaseAtomVariables;
            ConjunctiveIQ currentCIQ = iterator.next();
            boolean currentCiqContainsNewCiqButIsLonger = false;
            Optional<Homomorphism> fromCurrentCIQ = this.getHomomorphismIterator(currentCIQ, newCIQ).filter(Iterator::hasNext).map(Iterator::next);
            Optional<DisjunctionOfConjunctions> currentCIQConditionsImage = fromCurrentCIQ.map(h -> this.applyHomomorphism((Homomorphism)h, currentCIQ.getConditions()));
            if (fromCurrentCIQ.isPresent() && this.contains(currentCIQConditionsImage.get(), newCIQ.getConditions()) && this.contains(fromCurrentCIQ.get(), currentCIQ.getValuesNode(), newCIQ.getValuesNode())) {
                if (newCIQ.getDatabaseAtoms().size() >= currentCIQ.getDatabaseAtoms().size()) {
                    return;
                }
                currentCiqContainsNewCiqButIsLonger = true;
            }
            Optional<Homomorphism> fromNewCIQ = this.getHomomorphismIterator(newCIQ, currentCIQ).filter(Iterator::hasNext).map(Iterator::next);
            Optional<DisjunctionOfConjunctions> newCIQConditionsImage = fromNewCIQ.map(h -> this.applyHomomorphism((Homomorphism)h, newCIQ.getConditions()));
            if (fromNewCIQ.isPresent() && this.contains(newCIQConditionsImage.get(), currentCIQ.getConditions()) && this.contains(fromNewCIQ.get(), newCIQ.getValuesNode(), currentCIQ.getValuesNode())) {
                iterator.remove();
                continue;
            }
            if (currentCiqContainsNewCiqButIsLonger) {
                return;
            }
            if (!fromCurrentCIQ.isPresent() || !fromNewCIQ.isPresent()) continue;
            if (currentCIQ.getConditions().isTrue() && newCIQ.getConditions().isTrue() || newCIQConditionsImage.get().equals(currentCIQ.getConditions())) {
                ValuesNode newCIQValuesNodeImage;
                ValuesNode currentCIQValuesNode = currentCIQ.getValuesNode().get();
                Optional<ValuesNode> optionalNewCIQValuesNodeImage = this.applyHomomorphism(fromNewCIQ.get(), newCIQ.getValuesNode().get());
                if (optionalNewCIQValuesNodeImage.isPresent() && (newCIQValuesNodeImage = optionalNewCIQValuesNodeImage.get()).getVariables().equals((Object)currentCIQValuesNode.getVariables())) {
                    iterator.remove();
                    this.conjunctiveIqs.add(new ConjunctiveIQ(currentCIQ, currentCIQ.getConditions(), Optional.of(this.iqFactory.createValuesNode(currentCIQValuesNode.getVariables(), (ImmutableList)Stream.concat(newCIQValuesNodeImage.getValueMaps().stream(), currentCIQValuesNode.getValueMaps().stream()).distinct().collect(ImmutableCollectors.toList())))));
                    return;
                }
            }
            if (!(currentCIQDatabaseAtomVariables = (ImmutableSet)currentCIQ.getDatabaseAtoms().stream().flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet())).containsAll((newCIQCombinedConditionsImage = DisjunctionOfConjunctions.getAND(newCIQConditionsImage.get(), this.applyHomomorphism(fromNewCIQ.get(), this.translate(newCIQ.getValuesNode())))).getVariables())) continue;
            iterator.remove();
            this.conjunctiveIqs.add(new ConjunctiveIQ(currentCIQ, DisjunctionOfConjunctions.getOR(DisjunctionOfConjunctions.getAND(currentCIQ.getConditions(), this.translate(currentCIQ.getValuesNode())), newCIQCombinedConditionsImage), Optional.empty()));
            return;
        }
        this.conjunctiveIqs.add(newCIQ);
    }

    DisjunctionOfConjunctions translate(Optional<ValuesNode> valuesNode) {
        if (valuesNode.isEmpty()) {
            return DisjunctionOfConjunctions.getTrue();
        }
        return DisjunctionOfConjunctions.of(this.termFactory.getDisjunction((ImmutableList)valuesNode.get().getValueMaps().stream().map(m -> this.termFactory.getConjunction((ImmutableList)m.entrySet().stream().map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0])).collect(ImmutableCollectors.toList()))).collect(ImmutableCollectors.toList())));
    }

    private Optional<Iterator<Homomorphism>> getHomomorphismIterator(ConjunctiveIQ from, ConjunctiveIQ to) {
        Homomorphism.Builder builder = this.homomorphismFactory.getHomomorphismBuilder();
        if (!builder.extend(from.getHeadTerms(), to.getHeadTerms()).isValid()) {
            return Optional.empty();
        }
        Homomorphism h = builder.build();
        return Optional.of(new ExtensionalDataNodeHomomorphismIteratorImpl(h, from.getDatabaseAtoms(), (ImmutableCollection)this.cqc.chase(to.getDatabaseAtoms())));
    }

    private DisjunctionOfConjunctions applyHomomorphism(Homomorphism h, DisjunctionOfConjunctions f) {
        return f.stream().map(d -> (ImmutableSet)d.stream().map(atom -> h.applyToBooleanExpression(atom, this.termFactory)).collect(ImmutableCollectors.toSet())).collect(DisjunctionOfConjunctions.toDisjunctionOfConjunctions());
    }

    private boolean contains(DisjunctionOfConjunctions f1, DisjunctionOfConjunctions f2) {
        return f1.isTrue() || !f2.isTrue() && f2.stream().allMatch(c -> f1.stream().anyMatch(arg_0 -> c.containsAll(arg_0)));
    }

    private Optional<ValuesNode> applyHomomorphism(Homomorphism h, ValuesNode n) {
        ImmutableSet newVariables = (ImmutableSet)n.getVariables().stream().map(arg_0 -> ((Homomorphism)h).apply(arg_0)).map(v -> (Variable)v).collect(ImmutableCollectors.toSet());
        if (newVariables.size() < n.getVariables().size()) {
            return Optional.empty();
        }
        return Optional.of(this.iqFactory.createValuesNode(newVariables, (ImmutableList)n.getValueMaps().stream().map(m -> (ImmutableMap)m.entrySet().stream().collect(ImmutableCollectors.toMap(e -> (Variable)h.apply((VariableOrGroundTerm)e.getKey()), Map.Entry::getValue))).collect(ImmutableCollectors.toList())));
    }

    private boolean contains(Homomorphism h, Optional<ValuesNode> v1, Optional<ValuesNode> v2) {
        if (v1.isEmpty()) {
            return true;
        }
        Optional<ValuesNode> v1Image = this.applyHomomorphism(h, v1.get());
        return v1Image.filter(valuesNode -> v2.isPresent() && ((ValuesNode)v2.get()).getValueMaps().stream().allMatch(c -> valuesNode.getValueMaps().stream().anyMatch(m -> c.entrySet().containsAll((Collection)m.entrySet())))).isPresent();
    }

    private class ConjunctiveIQ {
        private final DistinctVariableOnlyDataAtom projectionAtom;
        private final Substitution<ImmutableTerm> substitution;
        private final ImmutableList<ExtensionalDataNode> extensionalDataNodes;
        private final Optional<ValuesNode> valuesNode;
        private final DisjunctionOfConjunctions filter;

        ConjunctiveIQ(DistinctVariableOnlyDataAtom projectionAtom, ConstructionNode constructionNode, ImmutableList<ExtensionalDataNode> extensionalDataNodes, Optional<ValuesNode> valuesNode, DisjunctionOfConjunctions filter) {
            VariableGenerator variableGenerator = MappingAssertionUnion.this.coreSingletons.getCoreUtilsFactory().createVariableGenerator((Collection)Stream.concat(constructionNode.getVariables().stream(), Stream.concat(extensionalDataNodes.stream().flatMap(n -> n.getVariables().stream()), valuesNode.stream().flatMap(n -> n.getVariables().stream()))).collect(ImmutableCollectors.toSet()));
            this.projectionAtom = projectionAtom;
            RDFAtomPredicate rdfAtomPredicate = (RDFAtomPredicate)projectionAtom.getPredicate();
            ImmutableList args = constructionNode.getSubstitution().apply(projectionAtom.getArguments());
            ImmutableMap map = (ImmutableMap)Stream.of(Optional.of(rdfAtomPredicate.getSubject(args)), rdfAtomPredicate.getPropertyIRI(args).filter(i -> !i.equals((Object)RDF.TYPE)).map(i -> rdfAtomPredicate.getObject(args)), rdfAtomPredicate.getGraph(args)).flatMap(Optional::stream).filter(c -> c instanceof IRIConstant).map(c -> (IRIConstant)c).distinct().collect(ImmutableCollectors.toMap(c -> c, c -> variableGenerator.generateNewVariable()));
            this.substitution = constructionNode.getSubstitution().transform(t -> Optional.ofNullable((Variable)map.get(t)).map(arg_0 -> ((TermFactory)MappingAssertionUnion.this.termFactory).getIRIFunctionalTerm(arg_0)).orElse((ImmutableTerm)t));
            ImmutableMap constantSubstitutionEntries = (ImmutableMap)map.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getValue, e -> MappingAssertionUnion.this.termFactory.getDBStringConstant(((IRIConstant)e.getKey()).getIRI().getIRIString())));
            ImmutableMap variableMap = (ImmutableMap)IntStream.range(0, extensionalDataNodes.size()).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> (ImmutableMap)((ExtensionalDataNode)extensionalDataNodes.get(i.intValue())).getArgumentMap().entrySet().stream().filter(e -> e.getValue() instanceof Constant).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> variableGenerator.generateNewVariable()))));
            this.extensionalDataNodes = variableMap.isEmpty() ? extensionalDataNodes : (ImmutableList)IntStream.range(0, extensionalDataNodes.size()).mapToObj(i -> ((ImmutableMap)variableMap.get((Object)i)).isEmpty() ? (ExtensionalDataNode)extensionalDataNodes.get(i) : MappingAssertionUnion.this.iqFactory.createExtensionalDataNode(((ExtensionalDataNode)extensionalDataNodes.get(i)).getRelationDefinition(), (ImmutableMap)((ExtensionalDataNode)extensionalDataNodes.get(i)).getArgumentMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable((VariableOrGroundTerm)((ImmutableMap)variableMap.get((Object)i)).get(e.getKey())).orElseGet(e::getValue))))).collect(ImmutableCollectors.toList());
            Optional<ImmutableMap> constantsMap = Optional.of((ImmutableMap)Stream.concat(constantSubstitutionEntries.entrySet().stream(), variableMap.entrySet().stream().flatMap(me -> ((ImmutableMap)me.getValue()).entrySet().stream().map(e -> Maps.immutableEntry((Object)((Variable)e.getValue()), (Object)((Constant)((ExtensionalDataNode)extensionalDataNodes.get(((Integer)me.getKey()).intValue())).getArgumentMap().get(e.getKey())))))).collect(ImmutableCollectors.toMap())).filter(cm -> !cm.isEmpty());
            this.valuesNode = valuesNode.map(v -> constantsMap.map(cm -> MappingAssertionUnion.this.iqFactory.createValuesNode(Sets.union((Set)v.getVariables(), (Set)cm.keySet()).immutableCopy(), (ImmutableList)v.getValueMaps().stream().map(m -> (ImmutableMap)Stream.concat(m.entrySet().stream(), cm.entrySet().stream()).collect(ImmutableCollectors.toMap())).collect(ImmutableCollectors.toList()))).orElse((ValuesNode)v)).or(() -> constantsMap.map(cm -> MappingAssertionUnion.this.iqFactory.createValuesNode(cm.keySet(), ImmutableList.of((Object)cm))));
            this.filter = filter;
        }

        ConjunctiveIQ(ConjunctiveIQ other, DisjunctionOfConjunctions filter, Optional<ValuesNode> valuesNode) {
            this.projectionAtom = other.projectionAtom;
            this.substitution = other.substitution;
            this.extensionalDataNodes = other.extensionalDataNodes;
            this.filter = filter;
            this.valuesNode = valuesNode;
        }

        IQ asIQ() {
            return MappingAssertionUnion.this.iqFactory.createIQ(this.projectionAtom, (IQTree)MappingAssertionUnion.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MappingAssertionUnion.this.iqFactory.createConstructionNode(this.projectionAtom.getVariables(), this.substitution), this.getTree()));
        }

        IQTree getTree() {
            Optional<ImmutableExpression> mergedConditions = this.translate(this.filter);
            if (this.extensionalDataNodes.isEmpty() && this.valuesNode.isEmpty()) {
                return MappingAssertionUnion.this.iqFactory.createTrueNode();
            }
            if (this.valuesNode.isEmpty() && this.extensionalDataNodes.size() == 1) {
                return mergedConditions.map(c -> MappingAssertionUnion.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MappingAssertionUnion.this.iqFactory.createFilterNode(c), (IQTree)this.extensionalDataNodes.get(0))).orElseGet(() -> (IQTree)this.extensionalDataNodes.get(0));
            }
            if (this.valuesNode.isPresent() && this.extensionalDataNodes.isEmpty()) {
                return mergedConditions.map(c -> MappingAssertionUnion.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MappingAssertionUnion.this.iqFactory.createFilterNode(c), (IQTree)this.valuesNode.get())).orElseGet(this.valuesNode::get);
            }
            return MappingAssertionUnion.this.iqFactory.createNaryIQTree((NaryOperatorNode)MappingAssertionUnion.this.iqFactory.createInnerJoinNode(mergedConditions), (ImmutableList)Stream.concat(this.extensionalDataNodes.stream(), this.valuesNode.stream()).collect(ImmutableCollectors.toList()));
        }

        Optional<ImmutableExpression> translate(DisjunctionOfConjunctions filter) {
            switch (filter.getNumberOfConjunctions()) {
                case 0: {
                    return Optional.empty();
                }
                case 1: {
                    return MappingAssertionUnion.this.termFactory.getDisjunction(filter.stream().map(e -> MappingAssertionUnion.this.termFactory.getConjunction(ImmutableList.copyOf((Collection)e))));
                }
            }
            ImmutableSet sharedAtoms = filter.stream().findFirst().map(e -> (ImmutableSet)e.stream().filter(c -> filter.stream().allMatch(e2 -> e2.contains(c))).collect(ImmutableCollectors.toSet())).get();
            return MappingAssertionUnion.this.termFactory.getConjunction(Stream.concat(sharedAtoms.stream(), MappingAssertionUnion.this.termFactory.getDisjunction(filter.stream().map(e -> MappingAssertionUnion.this.termFactory.getConjunction(ImmutableList.copyOf((Collection)Sets.difference((Set)e, (Set)sharedAtoms))))).stream()));
        }

        public ImmutableList<ImmutableTerm> getHeadTerms() {
            return this.substitution.applyToTerms(this.projectionAtom.getArguments());
        }

        public Substitution<ImmutableTerm> getSubstitution() {
            return this.substitution;
        }

        public ImmutableList<ExtensionalDataNode> getDatabaseAtoms() {
            return this.extensionalDataNodes;
        }

        public Optional<ValuesNode> getValuesNode() {
            return this.valuesNode;
        }

        public DisjunctionOfConjunctions getConditions() {
            return this.filter;
        }

        public int hashCode() {
            return Objects.hash(this.substitution, this.extensionalDataNodes, this.valuesNode, this.filter);
        }

        public boolean equals(Object o) {
            if (o instanceof ConjunctiveIQ) {
                ConjunctiveIQ other = (ConjunctiveIQ)o;
                return this.projectionAtom.equals(other.projectionAtom) && this.substitution.equals(other.substitution) && this.extensionalDataNodes.equals(other.extensionalDataNodes) && this.valuesNode.equals(other.valuesNode) && this.filter.equals(other.filter);
            }
            return false;
        }

        public String toString() {
            return this.projectionAtom.getPredicate() + "(" + this.getHeadTerms() + ") <- " + this.extensionalDataNodes + " FILTER " + this.filter + " " + this.valuesNode;
        }
    }
}

