/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.optimizer.DisjunctionOfEqualitiesMergingSimplifier;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.impl.MappingImpl;
import it.unibz.inf.ontop.spec.mapping.transformer.FactIntoMappingConverter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingDistinctTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSameAsInverseRewriter;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSaturator;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingTransformer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingValuesWrapper;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingVariableNameNormalizer;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyBuilderImpl;
import it.unibz.inf.ontop.spec.rule.RuleExecutor;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class DefaultMappingTransformer
implements MappingTransformer {
    private final MappingVariableNameNormalizer mappingVariableNameNormalizer;
    private final MappingSaturator mappingSaturator;
    private final FactIntoMappingConverter factConverter;
    private final OntopMappingSettings settings;
    private final MappingSameAsInverseRewriter sameAsInverseRewriter;
    private final SpecificationFactory specificationFactory;
    private final RDF rdfFactory;
    private final MappingDistinctTransformer mappingDistinctTransformer;
    private final MappingValuesWrapper mappingValuesWrapper;
    private final TermFactory termFactory;
    private final RuleExecutor ruleExecutor;
    private final DisjunctionOfEqualitiesMergingSimplifier disjunctionOfEqualitiesMergingSimplifier;

    @Inject
    private DefaultMappingTransformer(MappingVariableNameNormalizer mappingVariableNameNormalizer, MappingSaturator mappingSaturator, FactIntoMappingConverter inserter, OntopMappingSettings settings, MappingSameAsInverseRewriter sameAsInverseRewriter, SpecificationFactory specificationFactory, RDF rdfFactory, MappingDistinctTransformer mappingDistinctTransformer, MappingValuesWrapper mappingValuesWrapper, DisjunctionOfEqualitiesMergingSimplifier disjunctionOfEqualitiesMergingSimplifier, TermFactory termFactory, RuleExecutor ruleExecutor) {
        this.mappingVariableNameNormalizer = mappingVariableNameNormalizer;
        this.mappingSaturator = mappingSaturator;
        this.factConverter = inserter;
        this.settings = settings;
        this.sameAsInverseRewriter = sameAsInverseRewriter;
        this.specificationFactory = specificationFactory;
        this.rdfFactory = rdfFactory;
        this.mappingDistinctTransformer = mappingDistinctTransformer;
        this.mappingValuesWrapper = mappingValuesWrapper;
        this.disjunctionOfEqualitiesMergingSimplifier = disjunctionOfEqualitiesMergingSimplifier;
        this.termFactory = termFactory;
        this.ruleExecutor = ruleExecutor;
    }

    @Override
    public OBDASpecification transform(ImmutableList<MappingAssertion> mapping, DBParameters dbParameters, Optional<Ontology> optionalOntology, ImmutableSet<RDFFact> facts, ImmutableList<IQ> rules) {
        ImmutableList<MappingAssertion> factsAsMapping = this.factConverter.convert(facts);
        ImmutableList mappingWithFacts = (ImmutableList)Stream.concat(mapping.stream(), factsAsMapping.stream()).collect(ImmutableCollectors.toList());
        Ontology ontology = optionalOntology.orElseGet(() -> OntologyBuilderImpl.builder((RDF)this.rdfFactory, (TermFactory)this.termFactory).build());
        ImmutableList<MappingAssertion> sameAsRewrittenMapping = this.sameAsInverseRewriter.rewrite((ImmutableList<MappingAssertion>)mappingWithFacts);
        ImmutableList<MappingAssertion> saturatedMapping = this.mappingSaturator.saturate(sameAsRewrittenMapping, ontology.tbox());
        ImmutableList simplifiedBooleanExpressionsMapping = (ImmutableList)saturatedMapping.stream().map(m -> m.copyOf(this.disjunctionOfEqualitiesMergingSimplifier.optimize(m.getQuery()))).collect(ImmutableCollectors.toList());
        ImmutableList<MappingAssertion> mappingAfterApplyingRules = this.ruleExecutor.apply((ImmutableList<MappingAssertion>)simplifiedBooleanExpressionsMapping, rules);
        ImmutableList<MappingAssertion> mappingWithNormalizedVarNames = this.mappingVariableNameNormalizer.normalize(mappingAfterApplyingRules);
        ImmutableList<MappingAssertion> mappingWithRightCardinality = this.settings.getCardinalityPreservationMode() == OntopModelSettings.CardinalityPreservationMode.LOOSE ? mappingWithNormalizedVarNames : this.mappingDistinctTransformer.addDistinct(mappingWithNormalizedVarNames);
        ImmutableList<MappingAssertion> finalMapping = this.mappingValuesWrapper.normalize(mappingWithRightCardinality, dbParameters);
        return this.specificationFactory.createSpecification(this.getMapping(finalMapping), dbParameters, ontology.tbox());
    }

    private Mapping getMapping(ImmutableList<MappingAssertion> assertions) {
        ImmutableTable propertyDefinitions = (ImmutableTable)assertions.stream().filter(e -> !e.getIndex().isClass()).map(DefaultMappingTransformer::asCell).collect(ImmutableCollectors.toTable());
        ImmutableTable classDefinitions = (ImmutableTable)assertions.stream().filter(e -> e.getIndex().isClass()).map(DefaultMappingTransformer::asCell).collect(ImmutableCollectors.toTable());
        return new MappingImpl(propertyDefinitions, classDefinitions);
    }

    private static Table.Cell<RDFAtomPredicate, IRI, IQ> asCell(MappingAssertion assertion) {
        MappingAssertionIndex index = assertion.getIndex();
        return Tables.immutableCell((Object)index.getPredicate(), (Object)index.getIri(), (Object)assertion.getQuery());
    }
}

