/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.transformer.FactIntoMappingConverter;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABoxFactIntoMappingConverterImpl
implements FactIntoMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ABoxFactIntoMappingConverterImpl.class);
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final VariableGenerator projectedVariableGenerator;
    private final DBTypeFactory dbTypeFactory;
    private final FactType CLASS_IN_DEFAULT_GRAPH;
    private final FactType PROPERTY_IN_DEFAULT_GRAPH;
    private final FactType CLASS_IN_NON_DEFAULT_GRAPH;
    private final FactType PROPERTY_IN_NON_DEFAULT_GRAPH;

    @Inject
    protected ABoxFactIntoMappingConverterImpl(TermFactory termFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, AtomFactory atomFactory, CoreUtilsFactory coreUtilsFactory, TypeFactory typeFactory) {
        this.termFactory = termFactory;
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.dbTypeFactory = typeFactory.getDBTypeFactory();
        this.projectedVariableGenerator = coreUtilsFactory.createVariableGenerator((Collection)ImmutableSet.of());
        DistinctVariableOnlyDataAtom tripleAtom = atomFactory.getDistinctTripleAtom(this.projectedVariableGenerator.generateNewVariable(), this.projectedVariableGenerator.generateNewVariable(), this.projectedVariableGenerator.generateNewVariable());
        DistinctVariableOnlyDataAtom quadAtom = atomFactory.getDistinctQuadAtom(this.projectedVariableGenerator.generateNewVariable(), this.projectedVariableGenerator.generateNewVariable(), this.projectedVariableGenerator.generateNewVariable(), this.projectedVariableGenerator.generateNewVariable());
        IRIConstant RDF_TYPE = termFactory.getConstantIRI(RDF.TYPE);
        this.CLASS_IN_DEFAULT_GRAPH = new FactType((ImmutableList<Function<RDFFact, RDFConstant>>)ImmutableList.of(RDFFact::getSubject), (terms, iriConstant) -> ImmutableList.of((Object)((ImmutableTerm)terms.get(0)), (Object)RDF_TYPE, (Object)iriConstant), tripleAtom);
        this.PROPERTY_IN_DEFAULT_GRAPH = new FactType((ImmutableList<Function<RDFFact, RDFConstant>>)ImmutableList.of(RDFFact::getSubject, RDFFact::getObject), (terms, iriConstant) -> ImmutableList.of((Object)((ImmutableTerm)terms.get(0)), (Object)iriConstant, (Object)((ImmutableTerm)terms.get(1))), tripleAtom);
        this.CLASS_IN_NON_DEFAULT_GRAPH = new FactType((ImmutableList<Function<RDFFact, RDFConstant>>)ImmutableList.of(RDFFact::getSubject, f -> (RDFConstant)f.getGraph().get()), (terms, iriConstant) -> ImmutableList.of((Object)((ImmutableTerm)terms.get(0)), (Object)RDF_TYPE, (Object)iriConstant, (Object)((ImmutableTerm)terms.get(1))), quadAtom);
        this.PROPERTY_IN_NON_DEFAULT_GRAPH = new FactType((ImmutableList<Function<RDFFact, RDFConstant>>)ImmutableList.of(RDFFact::getSubject, RDFFact::getObject, f -> (RDFConstant)f.getGraph().get()), (terms, iriConstant) -> ImmutableList.of((Object)((ImmutableTerm)terms.get(0)), (Object)iriConstant, (Object)((ImmutableTerm)terms.get(1)), (Object)((ImmutableTerm)terms.get(2))), quadAtom);
    }

    @Override
    public ImmutableList<MappingAssertion> convert(ImmutableSet<RDFFact> facts) {
        ImmutableMultimap dict = (ImmutableMultimap)facts.stream().collect(ImmutableCollectors.toMultimap(this::getIndex, f -> f));
        ImmutableList assertions = (ImmutableList)dict.asMap().entrySet().stream().map(entry -> new MappingAssertion(this.createIQ((MappingAssertionIndex)entry.getKey(), (Collection)entry.getValue()), new PPMappingAssertionProvenance((Map.Entry)entry){
            private final String provenance;
            final /* synthetic */ Map.Entry val$entry;
            {
                this.val$entry = entry;
                this.provenance = ((Collection)this.val$entry.getValue()).toString();
            }

            @Override
            public String getProvenanceInfo() {
                return this.provenance;
            }
        })).collect(ImmutableCollectors.toList());
        LOGGER.debug("Transformed {} rdfFacts into {} mappingAssertions", (Object)facts.size(), (Object)assertions.size());
        return assertions;
    }

    private MappingAssertionIndex getIndex(RDFFact fact) {
        RDFAtomPredicate predicate = (RDFAtomPredicate)fact.getGraph().map((Function<ObjectConstant, FactType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIndex$8(it.unibz.inf.ontop.model.term.ObjectConstant ), (Lit/unibz/inf/ontop/model/term/ObjectConstant;)Lit/unibz/inf/ontop/spec/mapping/transformer/impl/ABoxFactIntoMappingConverterImpl$FactType;)((ABoxFactIntoMappingConverterImpl)this)).orElse((FactType)this.CLASS_IN_DEFAULT_GRAPH).atom.getPredicate();
        Optional<IRI> optionalIri = Optional.of(fact.getClassOrProperty()).filter(i -> i instanceof IRIConstant).map(i -> (IRIConstant)i).map(IRIConstant::getIRI);
        return fact.isClassAssertion() ? MappingAssertionIndex.ofClass(predicate, optionalIri) : MappingAssertionIndex.ofProperty(predicate, optionalIri);
    }

    private FactType getFactType(MappingAssertionIndex index) {
        if (index.getPredicate().getArity() == 3) {
            if (index.isClass()) {
                return this.CLASS_IN_DEFAULT_GRAPH;
            }
            return this.PROPERTY_IN_DEFAULT_GRAPH;
        }
        if (index.isClass()) {
            return this.CLASS_IN_NON_DEFAULT_GRAPH;
        }
        return this.PROPERTY_IN_NON_DEFAULT_GRAPH;
    }

    private IQ createIQ(MappingAssertionIndex index, Collection<RDFFact> facts) {
        ImmutableList terms;
        ImmutableList orderedVariables;
        ValuesNode valuesNode;
        FactType type = this.getFactType(index);
        if (type.termGetter.stream().anyMatch(e -> this.containsMultipleTypes(facts, (Function<RDFFact, RDFConstant>)e))) {
            valuesNode = this.iqFactory.createValuesNode((ImmutableList)Stream.concat(type.termGetter.stream(), type.termGetter.stream()).map(e -> this.projectedVariableGenerator.generateNewVariable()).collect(ImmutableCollectors.toList()), (ImmutableList)facts.stream().map(rdfFact -> (ImmutableList)Stream.concat(type.termGetter.stream().map(e -> this.termFactory.getDBStringConstant(((RDFConstant)e.apply(rdfFact)).getValue())), type.termGetter.stream().map(e -> this.termFactory.getRDFTermTypeConstant(((RDFConstant)e.apply(rdfFact)).getType()))).collect(ImmutableCollectors.toList())).collect(ImmutableCollectors.toList()));
            orderedVariables = valuesNode.getOrderedVariables();
            terms = (ImmutableList)IntStream.range(0, type.termGetter.size()).mapToObj(i -> this.termFactory.getRDFFunctionalTerm((ImmutableTerm)orderedVariables.get(i), (ImmutableTerm)orderedVariables.get(type.termGetter.size() + i))).collect(ImmutableCollectors.toList());
        } else {
            valuesNode = this.iqFactory.createValuesNode((ImmutableList)type.termGetter.stream().map(e -> this.projectedVariableGenerator.generateNewVariable()).collect(ImmutableCollectors.toList()), (ImmutableList)facts.stream().map(rdfFact -> (ImmutableList)type.termGetter.stream().map(e -> (RDFConstant)e.apply(rdfFact)).map(this::extractNaturalDBValue).collect(ImmutableCollectors.toList())).collect(ImmutableCollectors.toList()));
            orderedVariables = valuesNode.getOrderedVariables();
            RDFFact firstFact = facts.iterator().next();
            terms = (ImmutableList)IntStream.range(0, type.termGetter.size()).mapToObj(i -> this.getTerm((RDFConstant)((Function)type.termGetter.get(i)).apply(firstFact), (Variable)orderedVariables.get(i))).collect(ImmutableCollectors.toList());
        }
        IRIConstant iriConstant = this.termFactory.getConstantIRI(index.getIri());
        ImmutableList<ImmutableTerm> arguments = type.termListConstructor.apply((ImmutableList<ImmutableFunctionalTerm>)terms, iriConstant);
        Substitution substitution = this.substitutionFactory.getSubstitution(type.atom.getArguments(), arguments);
        return this.iqFactory.createIQ(type.atom, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(substitution.getDomain(), substitution), (IQTree)valuesNode));
    }

    private ImmutableFunctionalTerm getTerm(RDFConstant constant, Variable variable) {
        RDFTermType type = constant.getType();
        DBTermType dbType = type.getClosestDBType(this.dbTypeFactory);
        RDFTermTypeConstant rdfTypeConstant = this.termFactory.getRDFTermTypeConstant(type);
        return this.termFactory.getRDFFunctionalTerm((ImmutableTerm)this.termFactory.getConversion2RDFLexical(dbType, (ImmutableTerm)variable, rdfTypeConstant.getRDFTermType()), (ImmutableTerm)rdfTypeConstant);
    }

    private boolean containsMultipleTypes(Collection<RDFFact> facts, Function<RDFFact, RDFConstant> extractor) {
        RDFFact firstFact = facts.iterator().next();
        RDFTermType firstRDFTermType = extractor.apply(firstFact).getType();
        return facts.stream().map(extractor).anyMatch(c -> !c.getType().equals(firstRDFTermType));
    }

    private Constant extractNaturalDBValue(RDFConstant rdfConstant) {
        ImmutableFunctionalTerm functionalTerm = this.termFactory.getConversionFromRDFLexical2DB((ImmutableTerm)this.termFactory.getDBStringConstant(rdfConstant.getValue()), rdfConstant.getType());
        return (Constant)functionalTerm.simplify();
    }

    private /* synthetic */ FactType lambda$getIndex$8(ObjectConstant g) {
        return this.CLASS_IN_NON_DEFAULT_GRAPH;
    }

    private static class FactType {
        final ImmutableList<Function<RDFFact, RDFConstant>> termGetter;
        final BiFunction<ImmutableList<ImmutableFunctionalTerm>, IRIConstant, ImmutableList<ImmutableTerm>> termListConstructor;
        final DistinctVariableOnlyDataAtom atom;

        FactType(ImmutableList<Function<RDFFact, RDFConstant>> termGetter, BiFunction<ImmutableList<ImmutableFunctionalTerm>, IRIConstant, ImmutableList<ImmutableTerm>> termListConstructor, DistinctVariableOnlyDataAtom atom) {
            this.termGetter = termGetter;
            this.termListConstructor = termListConstructor;
            this.atom = atom;
        }
    }
}

